/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.binding.def;

import org.apache.bcel.generic.Type;
import org.jibx.binding.classes.ClassFile;
import org.jibx.binding.classes.ClassItem;
import org.jibx.binding.classes.ContextMethodBuilder;
import org.jibx.binding.classes.ExceptionMethodBuilder;
import org.jibx.binding.classes.MungedClass;
import org.jibx.binding.def.BindingDefinition;
import org.jibx.binding.def.DefinitionContext;
import org.jibx.binding.def.IComponent;
import org.jibx.binding.def.IContainer;
import org.jibx.binding.def.MappingDefinition;
import org.jibx.binding.def.NameDefinition;
import org.jibx.runtime.JiBXException;

public class DirectObject
implements IComponent {
    private static final String GETUNMARSHALLER_METHOD = "org.jibx.runtime.IUnmarshallingContext.getUnmarshaller";
    private static final String GETUNMARSHALLER_SIGNATURE = "(Ljava/lang/String;)Lorg/jibx/runtime/IUnmarshaller;";
    private static final String GETMARSHALLER_METHOD = "org.jibx.runtime.IMarshallingContext.getMarshaller";
    private static final String GETMARSHALLER_SIGNATURE = "(Ljava/lang/String;)Lorg/jibx/runtime/IMarshaller;";
    private static final String MARSHALLER_MARSHAL_METHOD = "org.jibx.runtime.IMarshaller.marshal";
    private static final String MARSHALLER_MARSHAL_SIGNATURE = "(Ljava/lang/Object;Lorg/jibx/runtime/IMarshallingContext;)V";
    private static final String UNMARSHALLER_TESTPRESENT_METHOD = "org.jibx.runtime.IUnmarshaller.isPresent";
    private static final String UNMARSHALLER_TESTPRESENT_SIGNATURE = "(Lorg/jibx/runtime/IUnmarshallingContext;)Z";
    private static final String UNMARSHALLER_UNMARSHAL_METHOD = "org.jibx.runtime.IUnmarshaller.unmarshal";
    private static final String UNMARSHALLER_UNMARSHAL_SIGNATURE = "(Ljava/lang/Object;Lorg/jibx/runtime/IUnmarshallingContext;)Ljava/lang/Object;";
    private static final String ABSTRACTMARSHALLER_INTERFACE = "org.jibx.runtime.IAbstractMarshaller";
    private static final String ABSTRACTMARSHAL_METHOD = "org.jibx.runtime.IAbstractMarshaller.baseMarshal";
    private static final String ABSTRACTMARSHAL_SIGNATURE = "(Ljava/lang/Object;Lorg/jibx/runtime/IMarshallingContext;)V";
    private static final String ALIASABLE_INTERFACETYPE = "Lorg/jibx/runtime/IAliasable;";
    private static final String ANY_INIT_SIG = "()V";
    private static final String ANY_INITCLASS_SIG = "(Ljava/lang/String;)V";
    private static final String MARSHALUNMARSHAL_INIT_SIG = "(Ljava/lang/String;ILjava/lang/String;)V";
    private static final String MARSHALONLY_INIT_SIG = "(ILjava/lang/String;)V";
    private static final String UNMARSHALONLY_INIT_SIG = "(Ljava/lang/String;Ljava/lang/String;)V";
    private static final String MARSHALUNMARSHAL_INITCLASS_SIG = "(Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;)V";
    private static final String MARSHALONLY_INITCLASS_SIG = "(ILjava/lang/String;Ljava/lang/String;)V";
    private static final String UNMARSHALONLY_INITCLASS_SIG = "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V";
    private static final String PUSH_NAMESPACES_METHOD = "org.jibx.runtime.IMarshallingContext.pushNamespaces";
    private static final String PUSH_NAMESPACES_SIG = "(Ljava/lang/String;)V";
    private static final String POP_NAMESPACES_METHOD = "org.jibx.runtime.IMarshallingContext.popNamespaces";
    private static final String POP_NAMESPACES_SIG = "()V";
    private final IContainer m_parent;
    private final DefinitionContext m_defContext;
    private final boolean m_isAbstract;
    private final NameDefinition m_name;
    private final ClassFile m_targetClass;
    private final ClassFile m_marshallerBase;
    private final ClassFile m_unmarshallerBase;
    private final boolean m_fixedName;
    private final String m_factoryName;
    private ClassFile m_marshaller;
    private ClassFile m_unmarshaller;
    private String m_mappingName;

    public DirectObject(IContainer parent, DefinitionContext defc, ClassFile target, boolean abs, ClassFile mcf, ClassFile ucf, String mapname, NameDefinition name, String factname) throws JiBXException {
        this.m_parent = parent;
        this.m_defContext = defc == null ? this.m_parent.getDefinitionContext() : defc;
        this.m_isAbstract = abs;
        this.m_targetClass = target;
        this.m_marshallerBase = mcf;
        this.m_unmarshallerBase = ucf;
        this.m_name = name;
        this.m_fixedName = mapname != null;
        this.m_mappingName = mapname;
        this.m_factoryName = factname;
        if (name == null) {
            if (mcf != null) {
                if (mcf.getInitializerMethod("()V") != null) {
                    this.m_marshaller = mcf;
                } else if (mcf.getInitializerMethod("(Ljava/lang/String;)V") == null) {
                    throw new JiBXException("Marshaller class " + mcf.getName() + " requires name to be set");
                }
            }
            if (ucf != null) {
                if (ucf.getInitializerMethod("()V") != null) {
                    this.m_unmarshaller = ucf;
                } else if (ucf.getInitializerMethod("(Ljava/lang/String;)V") == null) {
                    throw new JiBXException("Unmarshaller class " + ucf.getName() + " requires name to be set");
                }
            }
        }
        if (name != null) {
            if (mcf != null && !mcf.isImplements(ALIASABLE_INTERFACETYPE)) {
                throw new JiBXException("Marshaller class " + mcf.getName() + " does not allow name to be set");
            }
            if (ucf != null && !ucf.isImplements(ALIASABLE_INTERFACETYPE)) {
                throw new JiBXException("Unmarshaller class " + ucf.getName() + " does not allow name to be set");
            }
        }
    }

    private void genLoadName(ContextMethodBuilder mb) throws JiBXException {
        if (this.m_mappingName == null) {
            BindingDefinition bdef = this.m_parent.getBindingRoot();
            this.m_mappingName = bdef.getMarshallerUnmarshallerName(this.m_targetClass.getName());
            String mclas = null;
            String uclas = null;
            if (bdef.isOutput()) {
                if (this.m_marshaller == null) {
                    this.createSubclass(true);
                }
                mclas = this.m_marshaller.getName();
            }
            if (bdef.isInput()) {
                if (this.m_unmarshaller == null) {
                    this.createSubclass(false);
                }
                uclas = this.m_unmarshaller.getName();
            }
            bdef.setMarshallerUnmarshallerClasses(this.m_mappingName, mclas, uclas);
        }
        mb.appendLoadConstant(this.m_mappingName);
    }

    private void createSubclass(boolean out) throws JiBXException {
        BindingDefinition def;
        String pack;
        ClassFile base;
        ClassItem init = null;
        boolean dual = false;
        boolean classed = true;
        boolean named = false;
        ClassFile classFile = base = out ? this.m_marshallerBase : this.m_unmarshallerBase;
        if (this.m_name == null) {
            init = base.getInitializerMethod("(Ljava/lang/String;)V");
            boolean bl = classed = init != null;
        }
        if (init == null) {
            named = true;
            if (this.m_unmarshallerBase == this.m_marshallerBase) {
                init = base.getInitializerMethod(MARSHALUNMARSHAL_INITCLASS_SIG);
                if (init == null) {
                    classed = false;
                    init = base.getInitializerMethod(MARSHALUNMARSHAL_INIT_SIG);
                }
                dual = true;
            } else {
                String sig = out ? MARSHALONLY_INITCLASS_SIG : UNMARSHALONLY_INITCLASS_SIG;
                init = base.getInitializerMethod(sig);
                if (init == null) {
                    sig = MARSHALUNMARSHAL_INITCLASS_SIG;
                    init = base.getInitializerMethod(sig);
                    dual = true;
                    if (init == null) {
                        classed = false;
                        sig = out ? MARSHALONLY_INIT_SIG : UNMARSHALONLY_INIT_SIG;
                        init = base.getInitializerMethod(sig);
                        dual = false;
                        if (init == null) {
                            sig = MARSHALUNMARSHAL_INIT_SIG;
                            init = base.getInitializerMethod(sig);
                            dual = true;
                        }
                    }
                }
            }
        }
        if (init == null || (init.getAccessFlags() & 1) == 0) {
            throw new JiBXException("No usable constructor for marshaller or unmarshaller based on " + base.getName());
        }
        String tname = base.getName();
        int split = tname.lastIndexOf(46);
        if (split >= 0) {
            tname = tname.substring(split + 1);
        }
        if ((pack = (def = this.m_parent.getBindingRoot()).getDefaultPackage()).length() > 0) {
            pack = pack + '.';
        }
        String suffix = "";
        if (!this.m_fixedName) {
            split = this.m_mappingName.lastIndexOf(46) + 1;
            StringBuffer buff = new StringBuffer(this.m_mappingName.substring(split));
            for (int i = 0; i < buff.length(); ++i) {
                char chr = buff.charAt(i);
                if (i == 0 && !Character.isJavaIdentifierStart(chr) || !Character.isJavaIdentifierPart(chr)) {
                    buff.setCharAt(i, '_');
                }
                suffix = buff.toString();
            }
            suffix = this.m_mappingName.substring(split).replace('-', '_').replace('[', '_').replace(']', '_');
        }
        String name = pack + def.getPrefix() + tname + suffix;
        String[] intfs = def.isInput() ? (def.isOutput() ? MappingDefinition.BOTH_INTERFACES : MappingDefinition.UNMARSHALLER_INTERFACES) : MappingDefinition.MARSHALLER_INTERFACES;
        ClassFile cf = new ClassFile(name, def.getDefaultRoot(), base, 1, intfs);
        ExceptionMethodBuilder mb = new ExceptionMethodBuilder("<init>", (Type)Type.VOID, new Type[0], cf, 1);
        mb.appendLoadLocal(0);
        if (this.m_name == null) {
            if (named) {
                if (dual) {
                    mb.appendACONST_NULL();
                    mb.appendICONST_0();
                    mb.appendACONST_NULL();
                } else if (out) {
                    mb.appendICONST_0();
                    mb.appendACONST_NULL();
                } else {
                    mb.appendACONST_NULL();
                    mb.appendACONST_NULL();
                }
            }
        } else if (dual) {
            this.m_name.genPushUri(mb);
            this.m_name.genPushIndexPair(mb);
        } else if (out) {
            this.m_name.genPushIndexPair(mb);
        } else {
            this.m_name.genPushUriPair(mb);
        }
        if (classed) {
            mb.appendLoadConstant(this.m_targetClass.getName());
        }
        mb.appendCallInit(base.getName(), init.getSignature());
        mb.appendReturn();
        mb.codeComplete(false);
        mb.addMethod();
        cf = MungedClass.getUniqueSupportClass(cf);
        if (dual) {
            this.m_marshaller = this.m_unmarshaller = cf;
        } else if (out) {
            this.m_marshaller = cf;
        } else {
            this.m_unmarshaller = cf;
        }
    }

    public void genTestPresent(ContextMethodBuilder mb) throws JiBXException {
        mb.loadContext();
        this.genLoadName(mb);
        mb.appendCallInterface(GETUNMARSHALLER_METHOD, GETUNMARSHALLER_SIGNATURE);
        mb.loadContext();
        mb.appendCallInterface(UNMARSHALLER_TESTPRESENT_METHOD, UNMARSHALLER_TESTPRESENT_SIGNATURE);
    }

    public void genUnmarshal(ContextMethodBuilder mb) throws JiBXException {
        mb.loadContext();
        this.genLoadName(mb);
        mb.appendCallInterface(GETUNMARSHALLER_METHOD, GETUNMARSHALLER_SIGNATURE);
        mb.appendSWAP();
        mb.loadContext();
        mb.appendCallInterface(UNMARSHALLER_UNMARSHAL_METHOD, UNMARSHALLER_UNMARSHAL_SIGNATURE);
    }

    public void genMarshal(ContextMethodBuilder mb) throws JiBXException {
        if (this.m_factoryName != null) {
            mb.loadContext();
            mb.appendLoadConstant(this.m_factoryName);
            mb.appendCallInterface(PUSH_NAMESPACES_METHOD, "(Ljava/lang/String;)V");
        }
        mb.loadContext();
        this.genLoadName(mb);
        mb.appendCallInterface(GETMARSHALLER_METHOD, GETMARSHALLER_SIGNATURE);
        if (this.m_isAbstract) {
            mb.appendCreateCast(ABSTRACTMARSHALLER_INTERFACE);
            mb.appendSWAP();
            mb.loadContext();
            mb.appendCallInterface(ABSTRACTMARSHAL_METHOD, "(Ljava/lang/Object;Lorg/jibx/runtime/IMarshallingContext;)V");
        } else {
            mb.appendSWAP();
            mb.loadContext();
            mb.appendCallInterface(MARSHALLER_MARSHAL_METHOD, "(Ljava/lang/Object;Lorg/jibx/runtime/IMarshallingContext;)V");
        }
        if (this.m_factoryName != null) {
            mb.loadContext();
            mb.appendCallInterface(POP_NAMESPACES_METHOD, "()V");
        }
    }

    public ClassFile getTargetClass() {
        return this.m_targetClass;
    }

    public ClassFile getMarshaller() throws JiBXException {
        if (this.m_marshaller == null && this.m_marshallerBase != null) {
            this.createSubclass(true);
        }
        return this.m_marshaller;
    }

    public ClassFile getUnmarshaller() throws JiBXException {
        if (this.m_unmarshaller == null && this.m_unmarshallerBase != null) {
            this.createSubclass(false);
        }
        return this.m_unmarshaller;
    }

    public boolean isOptional() {
        return false;
    }

    public boolean hasAttribute() {
        return false;
    }

    public void genAttrPresentTest(ContextMethodBuilder mb) {
        throw new IllegalStateException("Internal error - no attributes defined");
    }

    public void genAttributeUnmarshal(ContextMethodBuilder mb) {
        throw new IllegalStateException("Internal error - no attributes defined");
    }

    public void genAttributeMarshal(ContextMethodBuilder mb) {
        throw new IllegalStateException("Internal error - no attributes defined");
    }

    public boolean hasContent() {
        return true;
    }

    public void genContentPresentTest(ContextMethodBuilder mb) throws JiBXException {
        this.genTestPresent(mb);
    }

    public void genContentUnmarshal(ContextMethodBuilder mb) throws JiBXException {
        this.genUnmarshal(mb);
    }

    public void genContentMarshal(ContextMethodBuilder mb) throws JiBXException {
        this.genMarshal(mb);
    }

    public void genNewInstance(ContextMethodBuilder mb) {
        throw new IllegalStateException("Internal error - no instance creation");
    }

    public String getType() {
        return this.m_targetClass.getFile().getName();
    }

    public boolean hasId() {
        return false;
    }

    public void genLoadId(ContextMethodBuilder mb) {
        throw new IllegalStateException("Internal error - no ID allowed");
    }

    public NameDefinition getWrapperName() {
        return this.m_name;
    }

    public void setLinkages() throws JiBXException {
        if (this.m_name != null) {
            this.m_name.fixNamespace(this.m_defContext);
        }
    }

    public void print(int depth) {
        BindingDefinition.indent(depth);
        System.out.println("direct marshaller/unmarshaller reference");
    }
}

