/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.runtime;

import java.lang.reflect.Array;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.jibx.runtime.JiBXException;

public abstract class Utility {
    public static final int MINIMUM_GROWN_ARRAY_SIZE = 16;
    private static final int MSPERMINUTE = 60000;
    private static final int MSPERHOUR = 3600000;
    private static final int MSPERDAY = 86400000;
    private static final long LMSPERDAY = 86400000L;
    private static final long MSPERYEAR = 31536000000L;
    private static final long MSPERAVGYEAR = 31557600000L;
    private static final long MSPERCENTURY = 3155695200000L;
    private static final long TIME_BASE = 62135596800000L;
    private static final int[] MONTHS_NONLEAP;
    private static final int[] MONTHS_LEAP;
    private static final long[] BIAS_MONTHMS;
    private static final char PAD_CHAR = '=';
    private static final char[] s_base64Chars;
    private static final byte[] s_base64Values;

    private static int parseDigits(String string, int n, int n2) throws JiBXException {
        int n3 = 0;
        if (n2 > 9) {
            try {
                n3 = Integer.parseInt(string.substring(n, n + n2));
            }
            catch (NumberFormatException numberFormatException) {
                throw new JiBXException(numberFormatException.getMessage());
            }
        } else {
            int n4 = n + n2;
            while (n < n4) {
                char c;
                if ((c = string.charAt(n++)) >= '0' && c <= '9') {
                    n3 = n3 * 10 + (c - 48);
                    continue;
                }
                throw new JiBXException("Non-digit in number value");
            }
        }
        return n3;
    }

    public static int parseInt(String string) throws JiBXException {
        string = string.trim();
        int n = 0;
        int n2 = string.length();
        if (n2 == 0) {
            throw new JiBXException("Empty number value");
        }
        boolean bl = false;
        char c = string.charAt(0);
        if (c == '-') {
            if (n2 > 9) {
                try {
                    return Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new JiBXException(numberFormatException.getMessage());
                }
            }
            bl = true;
            ++n;
        } else if (c == '+') {
            ++n;
        }
        if (n >= n2) {
            throw new JiBXException("Invalid number format");
        }
        int n3 = Utility.parseDigits(string, n, n2 - n);
        if (bl) {
            return -n3;
        }
        return n3;
    }

    public static String serializeInt(int n) {
        return Integer.toString(n);
    }

    public static long parseLong(String string) throws JiBXException {
        string = string.trim();
        int n = 0;
        int n2 = string.length();
        if (n2 == 0) {
            throw new JiBXException("Empty number value");
        }
        boolean bl = false;
        char c = string.charAt(0);
        if (c == '-') {
            bl = true;
            ++n;
        } else if (c == '+') {
            ++n;
        }
        if (n >= n2) {
            throw new JiBXException("Invalid number format");
        }
        long l = 0L;
        if (n2 - n > 18) {
            if (c == '+') {
                string = string.substring(1);
            }
            try {
                l = Long.parseLong(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new JiBXException(numberFormatException.getMessage());
            }
        } else {
            while (n < n2) {
                if ((c = string.charAt(n++)) >= '0' && c <= '9') {
                    l = l * 10L + (long)(c - 48);
                    continue;
                }
                throw new JiBXException("Non-digit in number value");
            }
            if (bl) {
                l = -l;
            }
        }
        return l;
    }

    public static String serializeLong(long l) {
        return Long.toString(l);
    }

    public static short parseShort(String string) throws JiBXException {
        int n = Utility.parseInt(string);
        if (n < Short.MIN_VALUE || n > Short.MAX_VALUE) {
            throw new JiBXException("Value out of range");
        }
        return (short)n;
    }

    public static String serializeShort(short s) {
        return Short.toString(s);
    }

    public static byte parseByte(String string) throws JiBXException {
        int n = Utility.parseInt(string);
        if (n < -128 || n > 127) {
            throw new JiBXException("Value out of range");
        }
        return (byte)n;
    }

    public static String serializeByte(byte by) {
        return Byte.toString(by);
    }

    public static boolean parseBoolean(String string) throws JiBXException {
        if ("true".equals(string = string.trim()) || "1".equals(string)) {
            return true;
        }
        if ("false".equals(string) || "0".equals(string)) {
            return false;
        }
        throw new JiBXException("Invalid boolean value");
    }

    public static String serializeBoolean(boolean bl) {
        return bl ? "true" : "false";
    }

    public static char parseChar(String string) throws JiBXException {
        int n = Utility.parseInt(string);
        if (n < 0 || n > 65535) {
            throw new JiBXException("Value out of range");
        }
        return (char)n;
    }

    public static String serializeChar(char c) {
        return Integer.toString(c);
    }

    public static char parseCharString(String string) throws JiBXException {
        if (string.length() == 1) {
            return string.charAt(0);
        }
        throw new JiBXException("Input must be a single character");
    }

    public static char deserializeCharString(String string) throws JiBXException {
        if (string == null) {
            return '\u0000';
        }
        return Utility.parseCharString(string);
    }

    public static String serializeCharString(char c) {
        return String.valueOf(c);
    }

    public static float parseFloat(String string) throws JiBXException {
        if ("-INF".equals(string = string.trim())) {
            return Float.NEGATIVE_INFINITY;
        }
        if ("INF".equals(string)) {
            return Float.POSITIVE_INFINITY;
        }
        try {
            return Float.parseFloat(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new JiBXException(numberFormatException.getMessage());
        }
    }

    public static String serializeFloat(float f) {
        if (Float.isInfinite(f)) {
            return f < 0.0f ? "-INF" : "INF";
        }
        return Float.toString(f);
    }

    public static double parseDouble(String string) throws JiBXException {
        if ("-INF".equals(string = string.trim())) {
            return Double.NEGATIVE_INFINITY;
        }
        if ("INF".equals(string)) {
            return Double.POSITIVE_INFINITY;
        }
        try {
            return Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new JiBXException(numberFormatException.getMessage());
        }
    }

    public static String serializeDouble(double d) {
        if (Double.isInfinite(d)) {
            return d < 0.0 ? "-INF" : "INF";
        }
        return Double.toString(d);
    }

    public static long parseYear(String string) throws JiBXException {
        string = string.trim();
        boolean bl = true;
        int n = 4;
        char c = string.charAt(0);
        if (c == '-') {
            n = 5;
        } else if (c == '+') {
            bl = false;
        }
        if (string.length() < n) {
            bl = false;
        }
        if (!bl) {
            throw new JiBXException("Invalid year format");
        }
        int n2 = Utility.parseInt(string);
        if (n2 == 0) {
            throw new JiBXException("Year value 0 is not allowed");
        }
        if (n2 > 0) {
            --n2;
        }
        long l = (long)n2 * 365L + (long)(n2 / 4) - (long)(n2 / 100) + (long)(n2 / 400);
        return l * 86400000L - 62135596800000L;
    }

    public static long parseYearMonth(String string) throws JiBXException {
        boolean bl;
        string = string.trim();
        boolean bl2 = true;
        int n = 7;
        char c = string.charAt(0);
        if (c == '-') {
            n = 8;
        } else if (c == '+') {
            bl2 = false;
        }
        int n2 = string.length() - 3;
        if (string.length() < n) {
            bl2 = false;
        } else if (string.charAt(n2) != '-') {
            bl2 = false;
        }
        if (!bl2) {
            throw new JiBXException("Invalid date format");
        }
        int n3 = Utility.parseInt(string.substring(0, n2));
        if (n3 == 0) {
            throw new JiBXException("Year value 0 is not allowed");
        }
        int n4 = Utility.parseDigits(string, n2 + 1, 2) - 1;
        if (n4 < 0 || n4 > 11) {
            throw new JiBXException("Month value out of range");
        }
        boolean bl3 = bl = n3 % 4 == 0 && (n3 % 100 != 0 || n3 % 400 == 0);
        if (n3 > 0) {
            --n3;
        }
        long l = (long)n3 * 365L + (long)(n3 / 4) - (long)(n3 / 100) + (long)(n3 / 400) + (long)(bl ? MONTHS_LEAP : MONTHS_NONLEAP)[n4];
        return l * 86400000L - 62135596800000L;
    }

    public static long parseDate(String string) throws JiBXException {
        int[] nArray;
        boolean bl = true;
        int n = 10;
        char c = string.charAt(0);
        if (c == '-') {
            n = 11;
        } else if (c == '+') {
            bl = false;
        }
        int n2 = string.length() - 6;
        if (string.length() < n) {
            bl = false;
        } else if (string.charAt(n2) != '-' || string.charAt(n2 + 3) != '-') {
            bl = false;
        }
        if (!bl) {
            throw new JiBXException("Invalid date format");
        }
        int n3 = Utility.parseInt(string.substring(0, n2));
        if (n3 == 0) {
            throw new JiBXException("Year value 0 is not allowed");
        }
        int n4 = Utility.parseDigits(string, n2 + 1, 2) - 1;
        if (n4 < 0 || n4 > 11) {
            throw new JiBXException("Month value out of range");
        }
        long l = Utility.parseDigits(string, n2 + 4, 2) - 1;
        boolean bl2 = n3 % 4 == 0 && (n3 % 100 != 0 || n3 % 400 == 0);
        int[] nArray2 = nArray = bl2 ? MONTHS_LEAP : MONTHS_NONLEAP;
        if (l < 0L || l >= (long)(nArray[n4 + 1] - nArray[n4])) {
            throw new JiBXException("Day value out of range");
        }
        if (n3 > 0) {
            --n3;
        }
        return (l += (long)n3 * 365L + (long)(n3 / 4) - (long)(n3 / 100) + (long)(n3 / 400) + (long)nArray[n4]) * 86400000L - 62135596800000L;
    }

    public static Date deserializeDate(String string) throws JiBXException {
        if (string == null) {
            return null;
        }
        return new Date(Utility.parseDate(string));
    }

    public static java.sql.Date deserializeSqlDate(String string) throws JiBXException {
        if (string == null) {
            return null;
        }
        long l = Utility.parseDate(string);
        return new java.sql.Date(l += (long)(TimeZone.getDefault().getRawOffset() + 0x6DDD00));
    }

    public static long parseTime(String string, int n, int n2) throws JiBXException {
        boolean bl;
        long l = 0L;
        boolean bl2 = bl = n2 > n + 7 && string.charAt(n + 2) == ':' && string.charAt(n + 5) == ':';
        if (bl) {
            int n3 = Utility.parseDigits(string, n, 2);
            int n4 = Utility.parseDigits(string, n + 3, 2);
            int n5 = Utility.parseDigits(string, n + 6, 2);
            if (n3 > 23 || n4 > 59 || n5 > 60) {
                bl = false;
            } else {
                l = ((n3 * 60 + n4) * 60 + n5) * 1000;
                if (n2 > (n += 8)) {
                    if (string.charAt(n2 - 1) == 'Z') {
                        --n2;
                    } else {
                        char c = string.charAt(n2 - 6);
                        if (c == '-' || c == '+') {
                            n3 = Utility.parseDigits(string, n2 - 5, 2);
                            n4 = Utility.parseDigits(string, n2 - 2, 2);
                            if (n3 > 23 || n4 > 59) {
                                bl = false;
                            } else {
                                int n6 = (n3 * 60 + n4) * 60 * 1000;
                                l = c == '-' ? (l += (long)n6) : (l -= (long)n6);
                            }
                            n2 -= 6;
                        }
                    }
                    if (string.charAt(n) == '.') {
                        double d = Double.parseDouble(string.substring(n, n2));
                        l = (long)((double)l + d * 1000.0);
                    } else if (n2 > n) {
                        bl = false;
                    }
                }
            }
        }
        if (bl) {
            return l;
        }
        throw new JiBXException("Invalid dateTime format");
    }

    public static long parseDateTime(String string) throws JiBXException {
        int n = string.indexOf(84);
        if (n < 0) {
            throw new JiBXException("Missing 'T' separator in dateTime");
        }
        return Utility.parseDate(string.substring(0, n)) + Utility.parseTime(string, n + 1, string.length());
    }

    public static Date deserializeDateTime(String string) throws JiBXException {
        if (string == null) {
            return null;
        }
        return new Date(Utility.parseDateTime(string));
    }

    public static Timestamp deserializeTimestamp(String string) throws JiBXException {
        if (string == null) {
            return null;
        }
        int n = string.indexOf(46);
        int n2 = 0;
        if (n > 0) {
            int n3;
            if (string.indexOf(46, n) > 0) {
                throw new JiBXException("Not a valid dateTime value");
            }
            int n4 = string.length();
            int n5 = n;
            while (++n5 < n4 && (n3 = string.charAt(n5)) >= 48 && n3 <= 57) {
            }
            n3 = n5 - n - 1;
            if (n3 > 9) {
                n3 = 9;
            }
            n2 = Utility.parseDigits(string, n + 1, n3);
            while (n3 < 9) {
                n2 *= 10;
                ++n3;
            }
            string = n5 < n4 ? string.substring(0, n) + string.substring(n5) : string.substring(0, n);
        }
        Timestamp timestamp = new Timestamp(Utility.parseDateTime(string));
        timestamp.setNanos(n2);
        return timestamp;
    }

    public static Time deserializeSqlTime(String string) throws JiBXException {
        if (string == null) {
            return null;
        }
        return new Time(Utility.parseTime(string, 0, string.length()));
    }

    protected static void formatYearNumber(long l, StringBuffer stringBuffer) {
        if (l <= 0L) {
            stringBuffer.append('-');
            l = -(l - 1L);
        }
        if (l < 1000L) {
            stringBuffer.append('0');
            if (l < 100L) {
                stringBuffer.append('0');
                if (l < 10L) {
                    stringBuffer.append('0');
                }
            }
        }
        stringBuffer.append(l);
    }

    protected static void formatTwoDigits(int n, StringBuffer stringBuffer) {
        if (n < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(n);
    }

    protected static void formatYear(long l, StringBuffer stringBuffer) {
        long l2;
        int n;
        int n2;
        long l3 = l + 26438400000L + 64800000L;
        long l4 = l3 / 3155695200000L;
        long l5 = l3 + (l4 - l4 / 4L) * 86400000L;
        int n3 = (int)(l5 / 31557600000L);
        if (l5 < 0L) {
            --n3;
        }
        if ((n2 = (5 * (n = (int)((l2 = l5 + 21600000L - (long)(n3 * 365 + n3 / 4) * 86400000L) / 86400000L)) + 456) / 153) > 12) {
            ++n3;
        }
        Utility.formatYearNumber(n3, stringBuffer);
    }

    protected static long formatYearMonth(long l, StringBuffer stringBuffer) {
        int n;
        long l2;
        int n2;
        long l3 = l + 26438400000L + 64800000L;
        long l4 = l3 / 3155695200000L;
        long l5 = l3 + (l4 - l4 / 4L) * 86400000L;
        int n3 = (int)(l5 / 31557600000L);
        if (l5 < 0L) {
            --n3;
        }
        if ((n2 = (int)((l2 = l5 + 21600000L - (long)(n3 * 365 + n3 / 4) * 86400000L) / 86400000L)) == 0) {
            int n4;
            int n5 = n = n3 < 0 ? 1 : 0;
            if (n != 0) {
                --n3;
            }
            int n6 = n4 = n3 % 4 == 0 ? 366 : 365;
            if (n == 0) {
                --n3;
            }
            l2 += (long)n4 * 86400000L;
            n2 += n4;
        }
        n = (5 * n2 + 456) / 153;
        long l6 = l2 - BIAS_MONTHMS[n] - 86400000L;
        if (n > 12) {
            ++n3;
            n -= 12;
        }
        Utility.formatYearNumber(n3, stringBuffer);
        stringBuffer.append('-');
        Utility.formatTwoDigits(n, stringBuffer);
        return l6;
    }

    protected static int formatYearMonthDay(long l, StringBuffer stringBuffer) {
        long l2 = Utility.formatYearMonth(l, stringBuffer);
        int n = (int)(l2 / 86400000L) + 1;
        stringBuffer.append('-');
        Utility.formatTwoDigits(n, stringBuffer);
        return (int)(l2 % 86400000L);
    }

    public static String serializeYear(long l) throws JiBXException {
        StringBuffer stringBuffer = new StringBuffer(6);
        Utility.formatYear(l + 62135596800000L, stringBuffer);
        return stringBuffer.toString();
    }

    public static String serializeYear(Date date) throws JiBXException {
        return Utility.serializeYear(date.getTime());
    }

    public static String serializeYearMonth(long l) throws JiBXException {
        StringBuffer stringBuffer = new StringBuffer(12);
        Utility.formatYearMonth(l + 62135596800000L, stringBuffer);
        return stringBuffer.toString();
    }

    public static String serializeYearMonth(Date date) throws JiBXException {
        return Utility.serializeYearMonth(date.getTime());
    }

    public static String serializeDate(long l) throws JiBXException {
        StringBuffer stringBuffer = new StringBuffer(12);
        Utility.formatYearMonthDay(l + 62135596800000L, stringBuffer);
        return stringBuffer.toString();
    }

    public static String serializeDate(Date date) throws JiBXException {
        return Utility.serializeDate(date.getTime());
    }

    public static String serializeSqlDate(java.sql.Date date) throws JiBXException {
        long l = date.getTime();
        return Utility.serializeDate(l -= (long)(TimeZone.getDefault().getRawOffset() - 0x6DDD00));
    }

    public static void serializeTime(int n, StringBuffer stringBuffer) throws JiBXException {
        Utility.formatTwoDigits(n / 3600000, stringBuffer);
        stringBuffer.append(':');
        Utility.formatTwoDigits((n %= 3600000) / 60000, stringBuffer);
        stringBuffer.append(':');
        Utility.formatTwoDigits((n %= 60000) / 1000, stringBuffer);
        if ((n %= 1000) > 0) {
            stringBuffer.append('.');
            stringBuffer.append(n / 100);
            if ((n %= 100) > 0) {
                stringBuffer.append(n / 10);
                if ((n %= 10) > 0) {
                    stringBuffer.append(n);
                }
            }
        }
    }

    public static String serializeDateTime(long l, boolean bl) throws JiBXException {
        StringBuffer stringBuffer = new StringBuffer(25);
        int n = Utility.formatYearMonthDay(l + 62135596800000L, stringBuffer);
        stringBuffer.append('T');
        Utility.serializeTime(n, stringBuffer);
        if (bl) {
            stringBuffer.append('Z');
        }
        return stringBuffer.toString();
    }

    public static String serializeDateTime(long l) throws JiBXException {
        return Utility.serializeDateTime(l, false);
    }

    public static String serializeDateTime(Date date) throws JiBXException {
        return Utility.serializeDateTime(date.getTime(), false);
    }

    public static String serializeTimestamp(Timestamp timestamp) throws JiBXException {
        int n = timestamp.getNanos();
        if (n > 0) {
            int n2;
            String string = Utility.serializeInt(n);
            StringBuffer stringBuffer = new StringBuffer(9);
            if (string.length() < 9) {
                n2 = 9 - string.length();
                for (int i = 0; i < n2; ++i) {
                    stringBuffer.append('0');
                }
            }
            stringBuffer.append(string);
            n2 = 9;
            while (--n2 > 0 && stringBuffer.charAt(n2) == '0') {
            }
            stringBuffer.setLength(n2);
            return Utility.serializeDateTime(timestamp.getTime(), false) + '.' + stringBuffer + 'Z';
        }
        return Utility.serializeDateTime(timestamp.getTime(), true);
    }

    public static String serializeSqlTime(Time time) throws JiBXException {
        StringBuffer stringBuffer = new StringBuffer(12);
        Utility.serializeTime((int)time.getTime(), stringBuffer);
        return stringBuffer.toString();
    }

    public static boolean isEqual(Object object, Object object2) {
        return object == null ? object2 == null : object.equals(object2);
    }

    public static int enumValue(String string, String[] stringArray, int[] nArray) throws JiBXException {
        int n = 0;
        int n2 = stringArray.length - 1;
        while (n <= n2) {
            int n3 = n + n2 >> 1;
            int n4 = string.compareTo(stringArray[n3]);
            if (n4 < 0) {
                n2 = n3 - 1;
                continue;
            }
            if (n4 > 0) {
                n = n3 + 1;
                continue;
            }
            if (nArray != null) {
                return nArray[n3];
            }
            return n3;
        }
        throw new JiBXException("Target value \"" + string + "\" not found in enumeration");
    }

    private static int decodeChunk(int n, char[] cArray, int n2, byte[] byArray) throws JiBXException {
        int n3 = 3;
        if (cArray[n + 3] == '=') {
            n3 = 2;
            if (cArray[n + 2] == '=') {
                n3 = 1;
            }
        }
        byte by = s_base64Values[cArray[n + 0]];
        byte by2 = s_base64Values[cArray[n + 1]];
        byte by3 = s_base64Values[cArray[n + 2]];
        byte by4 = s_base64Values[cArray[n + 3]];
        switch (n3) {
            case 3: {
                byArray[n2 + 2] = (byte)(by3 << 6 | by4);
            }
            case 2: {
                byArray[n2 + 1] = (byte)(by2 << 4 | by3 >> 2);
            }
            case 1: {
                byArray[n2] = (byte)(by << 2 | by2 >> 4);
            }
        }
        return n3;
    }

    public static byte[] parseBase64(String string) throws JiBXException {
        int n;
        char[] cArray = new char[string.length()];
        int n2 = 0;
        for (n = 0; n < string.length(); ++n) {
            char c = string.charAt(n);
            if (c >= '\u0080' || s_base64Values[c] < 0) continue;
            cArray[n2++] = c;
        }
        if (n2 % 4 != 0) {
            throw new JiBXException("Text length for base64 must be a multiple of 4");
        }
        if (n2 == 0) {
            return new byte[0];
        }
        n = n2 / 4 * 3;
        if (cArray[n2 - 1] == '=') {
            --n;
            if (cArray[n2 - 2] == '=') {
                --n;
            }
        }
        byte[] byArray = new byte[n];
        int n3 = 0;
        for (int i = 0; i < n2; i += 4) {
            n3 += Utility.decodeChunk(i, cArray, n3, byArray);
        }
        if (n3 != n) {
            throw new JiBXException("Embedded padding characters in byte64 text");
        }
        return byArray;
    }

    public static byte[] deserializeBase64(String string) throws JiBXException {
        if (string == null) {
            return null;
        }
        return Utility.parseBase64(string);
    }

    public static void encodeChunk(int n, byte[] byArray, StringBuffer stringBuffer) {
        int n2 = 3;
        if (n + n2 > byArray.length) {
            n2 = byArray.length - n;
        }
        byte by = byArray[n];
        int n3 = by >> 2 & 0x3F;
        stringBuffer.append(s_base64Chars[n3]);
        if (n2 > 1) {
            byte by2 = byArray[n + 1];
            n3 = ((by & 3) << 4) + (by2 >> 4 & 0xF);
            stringBuffer.append(s_base64Chars[n3]);
            if (n2 > 2) {
                byte by3 = byArray[n + 2];
                n3 = ((by2 & 0xF) << 2) + (by3 >> 6 & 3);
                stringBuffer.append(s_base64Chars[n3]);
                n3 = by3 & 0x3F;
                stringBuffer.append(s_base64Chars[n3]);
            } else {
                n3 = (by2 & 0xF) << 2;
                stringBuffer.append(s_base64Chars[n3]);
                stringBuffer.append('=');
            }
        } else {
            n3 = (by & 3) << 4;
            stringBuffer.append(s_base64Chars[n3]);
            stringBuffer.append('=');
            stringBuffer.append('=');
        }
    }

    public static String serializeBase64(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer((byArray.length + 2) / 3 * 4);
        for (int i = 0; i < byArray.length; i += 3) {
            Utility.encodeChunk(i, byArray, stringBuffer);
            if (i <= 0 || i % 57 != 0 || i + 3 >= byArray.length) continue;
            stringBuffer.append("\r\n");
        }
        return stringBuffer.toString();
    }

    public static Object resizeArray(int n, Object object) {
        int n2 = Array.getLength(object);
        if (n == n2) {
            return object;
        }
        Class<?> clazz = object.getClass().getComponentType();
        Object object2 = Array.newInstance(clazz, n);
        int n3 = Math.min(n, n2);
        System.arraycopy(object, 0, object2, 0, n3);
        return object2;
    }

    public static Object growArray(Object object) {
        int n = Array.getLength(object);
        Class<?> clazz = object.getClass().getComponentType();
        int n2 = Math.max(n * 2, 16);
        Object object2 = Array.newInstance(clazz, n2);
        System.arraycopy(object, 0, object2, 0, n);
        return object2;
    }

    public static List arrayListFactory() {
        return new ArrayList();
    }

    static {
        int n;
        MONTHS_NONLEAP = new int[]{0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334, 365};
        MONTHS_LEAP = new int[]{0, 31, 60, 91, 121, 152, 182, 213, 244, 274, 305, 335, 366};
        BIAS_MONTHMS = new long[]{0L, 0L, 0L, 0L, 2678400000L, 5270400000L, 7948800000L, 10540800000L, 13219200000L, 15897600000L, 18489600000L, 21168000000L, 23760000000L, 26438400000L, 29116800000L};
        s_base64Chars = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
        s_base64Values = new byte[128];
        for (n = 0; n < s_base64Values.length; ++n) {
            Utility.s_base64Values[n] = -1;
        }
        Utility.s_base64Values[61] = 0;
        for (n = 0; n < s_base64Chars.length; ++n) {
            Utility.s_base64Values[Utility.s_base64Chars[n]] = (byte)n;
        }
    }
}

