/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.binding.generator;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jibx.binding.generator.BindGenCommandLine;
import org.jibx.binding.generator.BindingMappingDetail;
import org.jibx.binding.model.BindingElement;
import org.jibx.binding.model.BindingHolder;
import org.jibx.binding.model.BindingOrganizer;
import org.jibx.binding.model.CollectionElement;
import org.jibx.binding.model.ElementBase;
import org.jibx.binding.model.FormatElement;
import org.jibx.binding.model.MappingElement;
import org.jibx.binding.model.MappingElementBase;
import org.jibx.binding.model.NestingElementBase;
import org.jibx.binding.model.StructureElement;
import org.jibx.binding.model.StructureElementBase;
import org.jibx.binding.model.ValidationContext;
import org.jibx.binding.model.ValueElement;
import org.jibx.custom.classes.ClassCustom;
import org.jibx.custom.classes.GlobalCustom;
import org.jibx.custom.classes.PackageCustom;
import org.jibx.custom.classes.ValueCustom;
import org.jibx.runtime.JiBXException;
import org.jibx.runtime.QName;
import org.jibx.runtime.Utility;
import org.jibx.schema.generator.SchemaGen;
import org.jibx.util.IClass;
import org.jibx.util.IClassLocator;
import org.jibx.util.ReferenceCountMap;
import org.jibx.util.Types;
import org.jibx.util.UniqueNameSet;

public class BindGen {
    private final GlobalCustom m_global;
    private final Set m_includeSet;
    private final Set m_ignoreSet;
    private final Set m_directSet;
    private final Set m_superSet;
    private final Set m_formatSet;
    private final Map m_mappingDetailsMap;
    private final Map m_typeNamesMap;
    private final Map m_elementNamesMap;
    private String m_targetPackage;
    private BindingOrganizer m_directory;

    public BindGen(GlobalCustom glob) {
        this.m_global = glob;
        this.m_includeSet = new HashSet();
        this.m_ignoreSet = new HashSet();
        this.m_directSet = new HashSet();
        this.m_superSet = new HashSet();
        this.m_formatSet = new HashSet();
        this.m_mappingDetailsMap = new HashMap();
        this.m_typeNamesMap = new HashMap();
        this.m_elementNamesMap = new HashMap();
        this.m_directory = new BindingOrganizer(glob.isForceClasses(), glob.isTrackSource(), glob.isAddConstructors(), glob.isInput(), glob.isOutput(), false);
    }

    public boolean isValueClass(String type) {
        ClassCustom clas = this.m_global.addClassCustomization(type);
        if (clas.isSimpleValue()) {
            this.m_formatSet.add(type);
            return true;
        }
        IClass sinfo = clas.getClassInformation().getSuperClass();
        return sinfo != null && "java.lang.Enum".equals(sinfo.getName());
    }

    public boolean checkInclude(String type) {
        String stype;
        if (this.m_includeSet.contains(type)) {
            return true;
        }
        if (this.m_ignoreSet.contains(type)) {
            return false;
        }
        boolean include = false;
        ClassCustom clas = this.m_global.addClassCustomization(type);
        if (clas.isSimpleValue()) {
            include = true;
        } else {
            Iterator iter = clas.getMembers().iterator();
            while (iter.hasNext()) {
                String mtype;
                ValueCustom memb = (ValueCustom)iter.next();
                String string = mtype = memb.isCollection() ? memb.getItemType() : memb.getWorkingType();
                if (!Types.isSimpleValue((String)mtype) && !this.isValueClass(mtype) && this.m_global.isKnownMapping(mtype) && !this.checkInclude(mtype)) continue;
                include = true;
                break;
            }
        }
        if (!include && clas.getMembers().size() > 0 && clas.isUseSuper() && !"java.lang.Object".equals(stype = clas.getClassInformation().getSuperClass().getName()) && this.checkInclude(stype)) {
            include = true;
        }
        if (include) {
            this.m_includeSet.add(type);
        } else {
            this.m_ignoreSet.add(type);
        }
        return include;
    }

    public void expandReferences(String type, ReferenceCountMap refmap) {
        if (this.checkInclude(type)) {
            String stype;
            ClassCustom clas = this.m_global.addClassCustomization(type);
            if (clas.isSimpleValue()) {
                return;
            }
            if (clas.isForceMapping() || clas.isAbstractMappingForced() || clas.isConcreteMappingForced()) {
                refmap.incrementCount((Object)type);
            }
            Iterator iter = clas.getMembers().iterator();
            while (iter.hasNext()) {
                ValueCustom memb = (ValueCustom)iter.next();
                String mtype = memb.isCollection() ? memb.getItemType() : memb.getWorkingType();
                if (Types.isSimpleValue((String)mtype) || this.isValueClass(mtype) || this.m_global.isKnownMapping(mtype)) continue;
                if (mtype.startsWith("java.") || mtype.startsWith("javax.")) {
                    throw new IllegalStateException("No way to handle type " + mtype + ", referenced from " + type);
                }
                if (!this.checkInclude(mtype)) continue;
                if (refmap.incrementCount((Object)mtype) <= 1) {
                    this.expandReferences(mtype, refmap);
                }
                this.m_directSet.add(mtype);
            }
            if (clas.getMembers().size() > 0 && clas.isUseSuper() && !"java.lang.Object".equals(stype = clas.getClassInformation().getSuperClass().getName()) && !Types.isSimpleValue((String)stype) && !this.isValueClass(stype) && !this.m_global.isKnownMapping(stype) && this.checkInclude(stype)) {
                if (refmap.incrementCount((Object)stype) <= 1) {
                    this.expandReferences(stype, refmap);
                }
                this.m_superSet.add(stype);
            }
        }
    }

    private void setTypes(ValueCustom memb, StructureElementBase struct) {
        String type = memb.getActualType();
        if (type != null && !type.equals(memb.getStatedType())) {
            struct.setDeclaredType(type);
        }
        struct.setCreateType(memb.getCreateType());
        struct.setFactoryName(memb.getFactoryMethod());
    }

    public void defineCollection(String itype, String iname, CollectionElement coll, BindingHolder hold) {
        BindingMappingDetail detail = (BindingMappingDetail)this.m_mappingDetailsMap.get(itype);
        ClassCustom custom = this.m_global.getClassCustomization(itype);
        if (detail != null) {
            if (detail.isUseAbstract() && !detail.isExtended()) {
                QName qname = detail.getTypeQName();
                if (iname == null) {
                    iname = custom.getElementName();
                }
                StructureElement struct = new StructureElement();
                if (qname == null) {
                    struct.setMapAsName(itype);
                } else {
                    String uri = qname.getUri();
                    hold.addTypeNameReference(uri, (Object)uri);
                    struct.setMapAsQName(qname);
                }
                struct.setName(iname);
                hold.addNamespaceUsage(hold.getNamespace());
                struct.setCreateType(custom.getCreateType());
                struct.setFactoryName(custom.getFactoryMethod());
                coll.addChild((Object)struct);
            } else {
                coll.setItemTypeName(itype);
            }
        } else if (this.m_global.isKnownMapping(itype)) {
            coll.setItemTypeName(itype);
        } else if (Types.isSimpleValue((String)itype) || this.isValueClass(itype)) {
            ValueElement value = new ValueElement();
            value.setName(iname);
            value.setDeclaredType(itype);
            coll.addChild((Object)value);
            if (custom != null) {
                value.setDefaultText(custom.getEnumValueMethod());
            }
        } else {
            StructureElement struct = new StructureElement();
            struct.setDeclaredType(itype);
            if (iname == null) {
                iname = custom.getElementName();
            }
            struct.setName(iname);
            hold.addNamespaceUsage(hold.getNamespace());
            this.fillStructure(custom, null, null, struct, hold);
            coll.addChild((Object)struct);
        }
    }

    private void addMemberBindings(ClassCustom cust, Map exmethmap, Map inmethmap, NestingElementBase parent, BindingHolder hold) {
        Iterator iter = cust.getMembers().iterator();
        while (iter.hasNext()) {
            ValueCustom memb = (ValueCustom)iter.next();
            String gmeth = memb.getGetName();
            String smeth = memb.getSetName();
            if (memb.isProperty() && !memb.isPrivate()) {
                ValueCustom match = (ValueCustom)(gmeth != null ? exmethmap.get(gmeth) : exmethmap.get(smeth));
                if (match != null) continue;
                if (inmethmap != null) {
                    if (gmeth != null) {
                        inmethmap.put(gmeth, memb);
                    }
                    if (smeth != null) {
                        inmethmap.put(smeth, memb);
                    }
                }
            }
            if (memb.isCollection()) {
                String itype;
                CollectionElement coll = new CollectionElement();
                if (memb.getFieldName() == null) {
                    coll.setGetName(gmeth);
                    coll.setSetName(memb.getSetName());
                } else {
                    coll.setFieldName(memb.getFieldName());
                }
                this.setTypes(memb, (StructureElementBase)coll);
                String name = memb.getXmlName();
                if ((cust.isWrapCollections() || memb.isElementForced()) && name != null) {
                    coll.setName(name);
                    hold.addNamespaceUsage(hold.getNamespace());
                }
                if (!memb.isRequired()) {
                    coll.setUsageName("optional");
                }
                if ((itype = memb.getItemType()) != null) {
                    CollectionElement lastcoll;
                    ElementBase sibling;
                    String iname = memb.getItemName();
                    if (iname == null) {
                        String simple = itype;
                        int split = simple.lastIndexOf(46);
                        if (split >= 0) {
                            simple = simple.substring(0, split);
                        }
                        iname = cust.convertName(simple);
                    }
                    this.defineCollection(itype, iname, coll, hold);
                    ArrayList siblings = parent.children();
                    if (siblings.size() > 0 && coll.children().size() == 0 && coll.getName() == null && (sibling = (ElementBase)siblings.get(siblings.size() - 1)).type() == 1 && (lastcoll = (CollectionElement)sibling).children().size() == 0 && lastcoll.getName() == null && Utility.safeEquals((Object)lastcoll.getItemTypeName(), (Object)coll.getItemTypeName())) {
                        throw new IllegalStateException("Need to use wrapper element for collection member '" + memb.getBaseName() + "' of class " + cust.getName());
                    }
                }
                parent.addChild((Object)coll);
                continue;
            }
            String wtype = memb.getWorkingType();
            if (Types.isSimpleValue((String)wtype) || this.isValueClass(wtype)) {
                int style;
                ValueElement value = new ValueElement();
                if (memb.getFieldName() == null) {
                    value.setGetName(gmeth);
                    value.setSetName(memb.getSetName());
                } else {
                    value.setFieldName(memb.getFieldName());
                }
                value.setName(memb.getXmlName());
                hold.addNamespaceUsage(hold.getNamespace());
                ClassCustom icust = this.m_global.getClassCustomization(wtype);
                if (icust != null) {
                    value.setEnumValueName(icust.getEnumValueMethod());
                }
                if (!memb.isRequired()) {
                    value.setUsageName("optional");
                }
                if ((style = memb.getStyle()) == 0) {
                    value.setStyleName("attribute");
                } else if (style == 1) {
                    value.setStyleName("element");
                } else {
                    value.setStyleName("text");
                    value.setName(null);
                }
                if (memb.getActualType() != null) {
                    value.setDeclaredType(memb.getActualType());
                }
                parent.addChild((Object)value);
                continue;
            }
            StructureElement struct = new StructureElement();
            if (memb.getFieldName() == null) {
                struct.setGetName(gmeth);
                struct.setSetName(memb.getSetName());
            } else {
                struct.setFieldName(memb.getFieldName());
            }
            this.setTypes(memb, (StructureElementBase)struct);
            if (!memb.isRequired()) {
                struct.setUsageName("optional");
            }
            ClassCustom mcust = this.m_global.getClassCustomization(memb.getWorkingType());
            this.fillStructure(mcust, memb, null, struct, hold);
            parent.addChild((Object)struct);
        }
    }

    private void fillStructure(ClassCustom cust, ValueCustom memb, Map inmethmap, StructureElement struct, BindingHolder hold) {
        String type = cust.getName();
        BindingMappingDetail detail = (BindingMappingDetail)this.m_mappingDetailsMap.get(type);
        if (detail != null) {
            if (detail.isUseAbstract() && !detail.isExtended()) {
                QName qname = detail.getTypeQName();
                String uri = qname.getUri();
                hold.addTypeNameReference(uri, (Object)uri);
                struct.setMapAsQName(qname);
                if (memb != null) {
                    struct.setName(memb.getXmlName());
                    hold.addNamespaceUsage(hold.getNamespace());
                }
            } else {
                struct.setMapAsName(cust.getName());
            }
            if (inmethmap != null) {
                inmethmap.putAll(detail.getAccessMethodMap());
            }
        } else if (!this.m_global.isKnownMapping(type)) {
            if (memb != null) {
                if (memb.getActualType() != null) {
                    struct.setDeclaredType(memb.getActualType());
                }
                if (memb.getCreateType() != null) {
                    struct.setCreateType(memb.getCreateType());
                }
                if (memb.getFactoryMethod() != null) {
                    struct.setFactoryName(memb.getFactoryMethod());
                }
                if (cust.isForceStructureNames() || !memb.isRequired()) {
                    struct.setName(memb.getXmlName());
                    hold.addNamespaceUsage(hold.getNamespace());
                }
            }
            IClass clas = cust.getClassInformation();
            IClass sclas = clas.getSuperClass();
            String stype = sclas.getName();
            Map exmethmap = Collections.EMPTY_MAP;
            if (this.checkInclude(stype)) {
                ClassCustom scust = this.m_global.getClassCustomization(stype);
                exmethmap = new HashMap();
                if (cust.getMembers().size() > 0) {
                    StructureElement sstruct = new StructureElement();
                    sstruct.setDeclaredType(stype);
                    this.fillStructure(scust, null, exmethmap, sstruct, hold);
                    struct.addChild((Object)sstruct);
                } else {
                    struct.setDeclaredType(stype);
                    this.fillStructure(scust, null, exmethmap, struct, hold);
                }
            } else {
                String[] intfs = sclas.getInterfaces();
                for (int i = 0; i < intfs.length; ++i) {
                    String intf = intfs[i];
                    BindingMappingDetail idetail = (BindingMappingDetail)this.m_mappingDetailsMap.get(intf);
                    if (idetail == null || !idetail.isUseAbstract() || idetail.getTypeQName() != null) continue;
                    struct = new StructureElement();
                    struct.setMapAsName(intf);
                    exmethmap = idetail.getAccessMethodMap();
                    break;
                }
            }
            if (inmethmap != null) {
                inmethmap.putAll(exmethmap);
            }
            if (cust.getMembers().size() > 0) {
                this.addMemberBindings(cust, exmethmap, inmethmap, (NestingElementBase)struct, hold);
            }
        }
    }

    private void addMapping(String type, BindingMappingDetail detail) {
        HashMap inmembmap;
        ClassCustom cust = this.m_global.addClassCustomization(type);
        MappingElement mainmapping = null;
        QName qname = null;
        MappingElement mapcon = null;
        IClass clas = cust.getClassInformation();
        if (detail.isUseConcrete()) {
            mapcon = this.createMapping(type, cust);
            qname = detail.getElementQName();
            mapcon.setName(qname.getName());
            detail.setConcreteMapping((MappingElementBase)mapcon);
            if (clas.isAbstract() || clas.isInterface()) {
                mapcon.setAbstract(true);
            }
            mainmapping = mapcon;
        }
        MappingElement mapabs = null;
        if (detail.isUseAbstract()) {
            mapabs = this.createMapping(type, cust);
            mapabs.setAbstract(true);
            qname = detail.getTypeQName();
            mapabs.setTypeQName(qname);
            detail.setAbstractMapping(mapabs);
            mainmapping = mapabs;
        }
        if (mainmapping != null) {
            String uri = qname.getUri();
            BindingHolder hold = this.m_directory.getBinding((Object)uri);
            if (mainmapping.isAbstract()) {
                hold.addTypeNameReference(uri, (Object)uri);
            }
            StructureElement struct = null;
            String ptype = detail.getExtendsType();
            HashMap exmembmap = Collections.EMPTY_MAP;
            inmembmap = new HashMap();
            if (ptype == null) {
                IClass parent = clas.getSuperClass();
                if (cust.isUseSuper() && parent != null && this.checkInclude(ptype = parent.getName())) {
                    struct = new StructureElement();
                    struct.setDeclaredType(ptype);
                    ClassCustom scust = this.m_global.getClassCustomization(ptype);
                    exmembmap = new HashMap();
                    this.fillStructure(scust, null, exmembmap, struct, hold);
                }
            } else {
                struct = new StructureElement();
                BindingMappingDetail pdetail = (BindingMappingDetail)this.m_mappingDetailsMap.get(ptype);
                if (!pdetail.isGenerated()) {
                    this.addMapping(ptype, pdetail);
                }
                exmembmap = pdetail.getAccessMethodMap();
                if (pdetail.isUseAbstract()) {
                    QName tname = pdetail.getTypeQName();
                    if (tname == null) {
                        throw new IllegalStateException("Internal error: unimplemented case of superclass " + ptype + " to be extended by subclass " + type + ", without an abstract <mapping> ");
                    }
                    uri = tname.getUri();
                    hold.addTypeNameReference(uri, (Object)uri);
                    struct.setMapAsQName(tname);
                } else {
                    struct.setMapAsName(ptype);
                }
                if (mapcon != null) {
                    mapcon.setExtendsName(ptype);
                }
            }
            if (struct != null) {
                mainmapping.addChild((Object)struct);
            }
            inmembmap.putAll(exmembmap);
            this.addMemberBindings(cust, exmembmap, inmembmap, (NestingElementBase)mainmapping, hold);
            hold.addMapping((MappingElementBase)mainmapping);
            if (mapabs != null && mapcon != null) {
                struct = new StructureElement();
                QName tname = detail.getTypeQName();
                uri = tname.getUri();
                hold.addTypeNameReference(uri, (Object)uri);
                struct.setMapAsQName(tname);
                mapcon.addChild((Object)struct);
                hold.addMapping((MappingElementBase)mapcon);
            }
        } else {
            throw new IllegalStateException("Internal error: mapping detail for " + type + " with neither abstract nor concrete mapping");
        }
        detail.setAccessMethodMap(inmembmap);
        detail.setGenerated(true);
    }

    private MappingElement createMapping(String type, ClassCustom cust) {
        MappingElement mapabs = new MappingElement();
        mapabs.setClassName(type);
        mapabs.setCreateType(cust.getCreateType());
        mapabs.setFactoryName(cust.getFactoryMethod());
        return mapabs;
    }

    private BindingMappingDetail addMappingDetails(Boolean abstr, QName ename, String type) {
        BindingMappingDetail detail = (BindingMappingDetail)this.m_mappingDetailsMap.get(type);
        if (detail == null) {
            QName tname;
            String uri;
            ClassCustom cust = this.m_global.getClassCustomization(type);
            IClass sclas = cust.getClassInformation();
            if (sclas.isInterface() && !cust.isPropertyAccess()) {
                System.out.println("Warning: generating mapping for interface " + type + " without checking properties - consider setting property-access='true'");
            }
            String stype = null;
            Boolean isabs = null;
            while ((sclas = sclas.getSuperClass()) != null) {
                if (!this.m_directSet.contains(sclas.getName())) continue;
                stype = sclas.getName();
                isabs = sclas.isAbstract();
                break;
            }
            if (stype == null) {
                block1: for (sclas = cust.getClassInformation(); sclas != null; sclas = sclas.getSuperClass()) {
                    String[] intfs = sclas.getInterfaces();
                    block2: for (int i = 0; i < intfs.length; ++i) {
                        String itype = intfs[i];
                        while (true) {
                            String[] sintfs;
                            if (this.m_directSet.contains(itype)) {
                                stype = itype;
                                isabs = Boolean.TRUE;
                                break block1;
                            }
                            ClassCustom icust = this.m_global.getClassCustomization(itype);
                            if (icust == null || (sintfs = icust.getClassInformation().getInterfaces()).length <= 0) continue block2;
                            itype = sintfs[0];
                        }
                    }
                }
            }
            if (stype != null) {
                BindingMappingDetail sdetail = this.addMappingDetails(isabs, null, stype);
                sdetail.setExtended(true);
            }
            if (this.m_directory.getBinding((Object)(uri = (tname = ename == null ? cust.getTypeQName() : new QName(ename.getUri(), cust.getTypeName())).getUri())) == null) {
                this.m_directory.addBinding((Object)uri, uri, null, true);
            }
            if (this.isQNameUsed(ename, this.m_elementNamesMap)) {
                throw new IllegalStateException("Internal error - attempting to create mapping with element name " + ename + " already used");
            }
            if (ename == null) {
                ename = cust.getElementQName();
            }
            tname = this.fixTypeName(tname);
            ename = this.fixElementName(ename);
            boolean abs = (abstr != null ? abstr != false : cust.isMapAbstract()) || cust.isAbstractMappingForced();
            detail = new BindingMappingDetail(type, tname, ename, stype);
            if (abs || !cust.isConcreteClass()) {
                detail.setUseAbstract(true);
            }
            if ((!abs || cust.isConcreteMappingForced() || sclas != null || this.m_superSet.contains(type) || abstr != null && !abstr.booleanValue()) && cust.isConcreteClass()) {
                detail.setUseConcrete(true);
            }
            this.m_mappingDetailsMap.put(type, detail);
            if (this.m_targetPackage == null && cust.getClassInformation().isModifiable()) {
                this.m_targetPackage = ((PackageCustom)cust.getParent()).getName();
            }
        } else if (abstr != null) {
            if (abstr.booleanValue()) {
                detail.setUseAbstract(true);
            } else {
                detail.setUseConcrete(true);
            }
        }
        return detail;
    }

    private boolean isQNameUsed(QName qname, Map map) {
        UniqueNameSet nameset;
        if (qname != null && (nameset = (UniqueNameSet)map.get(qname.getUri())) != null) {
            return nameset.contains(qname.getName());
        }
        return false;
    }

    private QName fixQName(QName qname, Map map) {
        if (qname != null) {
            String base;
            String name;
            String uri = qname.getUri();
            UniqueNameSet nameset = (UniqueNameSet)map.get(uri);
            if (nameset == null) {
                nameset = new UniqueNameSet();
                map.put(uri, nameset);
            }
            if ((name = nameset.add(base = qname.getName())).equals(base)) {
                return qname;
            }
            return new QName(uri, name);
        }
        return null;
    }

    private QName fixElementName(QName qname) {
        return this.fixQName(qname, this.m_elementNamesMap);
    }

    private QName fixTypeName(QName qname) {
        return this.fixQName(qname, this.m_typeNamesMap);
    }

    private void findReferences(List classes, ReferenceCountMap refmap) {
        for (int i = 0; i < classes.size(); ++i) {
            String type = (String)classes.get(i);
            int split = type.indexOf(60);
            if (split > 0) {
                type = type.substring(split + 1, type.length() - 1);
            }
            this.expandReferences(type, refmap);
        }
    }

    private void flagMultipleReferences(ReferenceCountMap refmap) {
        Iterator iter = refmap.iterator();
        while (iter.hasNext()) {
            String type = (String)iter.next();
            if (refmap.getCount((Object)type) <= 1) continue;
            this.m_directSet.add(type);
        }
    }

    private void addReferencedMappings(ReferenceCountMap refmap) {
        Iterator iter = refmap.iterator();
        while (iter.hasNext()) {
            String type = (String)iter.next();
            if (refmap.getCount((Object)type) <= 1 || this.m_mappingDetailsMap.containsKey(type)) continue;
            this.addMappingDetails(null, null, type);
        }
    }

    private void generateReferencedMappings(ReferenceCountMap refmap) {
        Iterator iter = refmap.iterator();
        while (iter.hasNext()) {
            BindingMappingDetail detail;
            String type = (String)iter.next();
            if (refmap.getCount((Object)type) <= 1 || (detail = (BindingMappingDetail)this.m_mappingDetailsMap.get(type)).isGenerated()) continue;
            this.addMapping(type, detail);
        }
    }

    private void generateMappings(List classes) {
        for (int i = 0; i < classes.size(); ++i) {
            String type = (String)classes.get(i);
            BindingMappingDetail detail = (BindingMappingDetail)this.m_mappingDetailsMap.get(type);
            if (detail.isGenerated()) continue;
            this.addMapping(type, detail);
        }
    }

    private void fixBaseClasses() {
        Iterator iter = this.m_directSet.iterator();
        while (iter.hasNext()) {
            String type = (String)iter.next();
            BindingMappingDetail detail = (BindingMappingDetail)this.m_mappingDetailsMap.get(type);
            if (detail == null || !detail.isExtended()) continue;
            detail.setUseConcrete(true);
        }
    }

    private void generateFormats() {
        Iterator iter = this.m_formatSet.iterator();
        while (iter.hasNext()) {
            String type = (String)iter.next();
            ClassCustom clas = this.m_global.getClassCustomization(type);
            if (clas.getSerializer() == null && clas.getDeserializer() == null) continue;
            FormatElement format = new FormatElement();
            format.setDeserializerName(clas.getDeserializer());
            format.setSerializerName(clas.getSerializer());
            format.setTypeName(type);
            this.m_directory.addFormat(format);
        }
    }

    public void generate(Boolean abstr, List classes) {
        ReferenceCountMap refmap = new ReferenceCountMap();
        this.m_directSet.addAll(classes);
        this.findReferences(classes, refmap);
        this.flagMultipleReferences(refmap);
        for (int i = 0; i < classes.size(); ++i) {
            BindingMappingDetail detail = this.addMappingDetails(abstr, null, (String)classes.get(i));
            if (abstr != null) continue;
            detail.setUseAbstract(true);
            detail.setUseConcrete(true);
        }
        this.addReferencedMappings(refmap);
        this.fixBaseClasses();
        this.generateMappings(classes);
        this.generateReferencedMappings(refmap);
        this.generateFormats();
    }

    public void generateSpecified(ArrayList qnames, List concrs, List abstrs) {
        int i;
        ReferenceCountMap refmap = new ReferenceCountMap();
        this.m_directSet.addAll(concrs);
        this.m_directSet.addAll(abstrs);
        this.findReferences(concrs, refmap);
        this.findReferences(abstrs, refmap);
        this.flagMultipleReferences(refmap);
        for (i = 0; i < concrs.size(); ++i) {
            BindingMappingDetail detail = this.addMappingDetails(Boolean.FALSE, (QName)qnames.get(i), (String)concrs.get(i));
            if (detail.getElementQName() != null) continue;
            detail.setElementQName(this.fixElementName((QName)qnames.get(i)));
        }
        for (i = 0; i < abstrs.size(); ++i) {
            this.addMappingDetails(Boolean.TRUE, null, (String)abstrs.get(i));
        }
        this.addReferencedMappings(refmap);
        this.fixBaseClasses();
        this.generateMappings(concrs);
        this.generateMappings(abstrs);
        this.generateReferencedMappings(refmap);
        this.generateFormats();
    }

    public BindingMappingDetail getMappingDetail(String type) {
        return (BindingMappingDetail)this.m_mappingDetailsMap.get(type);
    }

    public BindingHolder getBinding(String uri) {
        return this.m_directory.getRequiredBinding((Object)uri);
    }

    public BindingHolder addBinding(String uri, boolean dflt) {
        BindingHolder hold = this.m_directory.getBinding((Object)uri);
        if (hold == null) {
            hold = this.m_directory.addBinding((Object)uri, uri, null, dflt);
        }
        return hold;
    }

    public BindingHolder finish(String name) {
        BindingHolder root = this.m_directory.configureFiles(name, this.m_targetPackage, Collections.EMPTY_LIST);
        return root;
    }

    public List validateFiles(File dir, IClassLocator loc, BindingHolder root) throws IOException, JiBXException {
        this.m_directory.writeBindings(dir);
        File file = new File(dir, root.getFileName());
        ValidationContext vctx = new ValidationContext(loc);
        FileInputStream is = new FileInputStream(file);
        BindingElement binding = BindingElement.validateBinding((String)root.getFileName(), (URL)file.toURI().toURL(), (InputStream)is, (ValidationContext)vctx);
        if (binding == null || vctx.getErrorCount() > 0 || vctx.getFatalCount() > 0) {
            return null;
        }
        List uris = this.m_directory.getKeys();
        ArrayList<BindingElement> bindings = new ArrayList<BindingElement>();
        bindings.add(binding);
        URL base = dir.toURI().toURL();
        Iterator iter = uris.iterator();
        while (iter.hasNext()) {
            String uri = (String)iter.next();
            BindingHolder hold = this.getBinding(uri);
            if (hold == root) continue;
            URL url = new URL(base, hold.getFileName());
            if (binding.addIncludePath(url.toExternalForm(), false)) {
                throw new IllegalStateException("Binding not found when read from file");
            }
            bindings.add(binding.getExistingIncludeBinding(url));
        }
        return bindings;
    }

    public static void main(String[] args) throws JiBXException, IOException {
        BindGenCommandLine parms = new BindGenCommandLine();
        if (args.length > 0 && parms.processArgs(args)) {
            BindGen gen = new BindGen(parms.getGlobal());
            gen.generate(parms.getAbstract(), parms.getExtraArgs());
            BindingHolder root = gen.finish(parms.getBindingName());
            List bindings = gen.validateFiles(parms.getGeneratePath(), parms.getLocator(), root);
            if (!parms.isBindingOnly()) {
                SchemaGen sgen = new SchemaGen(parms.getLocator(), parms.getGlobal(), parms.getUriNames());
                List schemas = sgen.generate(bindings);
                SchemaGen.writeSchemas(parms.getGeneratePath(), schemas);
            }
        } else {
            if (args.length > 0) {
                System.err.println("Terminating due to command line errors");
            } else {
                parms.printUsage();
            }
            System.exit(1);
        }
    }
}

