/*
 * Decompiled with CFR 0.152.
 */
package org.jmxtrans.embedded.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.URL;
import java.util.StringTokenizer;
import org.apache.commons.io.IOUtils;
import org.jmxtrans.embedded.EmbeddedJmxTransException;
import org.jmxtrans.embedded.config.KVStore;
import org.jmxtrans.embedded.config.KeyValue;
import org.jmxtrans.embedded.util.json.PlaceholderEnabledJsonNodeFactory;

public class EtcdKVStore
implements KVStore {
    private static final String HTTP_ERR = "ERR";
    private final ObjectMapper mapper = new ObjectMapper();

    public EtcdKVStore() {
        this.mapper.setNodeFactory((JsonNodeFactory)new PlaceholderEnabledJsonNodeFactory());
    }

    @Override
    public KeyValue getKeyValue(String KeyURI) throws EmbeddedJmxTransException {
        String etcdURI = KeyURI.substring(0, KeyURI.indexOf("/", 7));
        String key = KeyURI.substring(KeyURI.indexOf("/", 7));
        try {
            return this.getFromEtcd(this.makeEtcdBaseUris(etcdURI), key);
        }
        catch (Throwable t) {
            throw new EmbeddedJmxTransException("Exception reading etcd key '" + KeyURI + "': " + t.getMessage(), t);
        }
    }

    private URL[] makeEtcdBaseUris(String etcdURI) throws EmbeddedJmxTransException {
        String serverList = null;
        try {
            serverList = etcdURI.indexOf("[") > 0 ? etcdURI.substring(etcdURI.indexOf("[") + 1, etcdURI.indexOf("]")) : etcdURI.substring(7, etcdURI.indexOf("/", 7));
            StringTokenizer st = new StringTokenizer(serverList, ",");
            URL[] result = new URL[st.countTokens()];
            int k = 0;
            while (st.hasMoreTokens()) {
                result[k] = new URL("http://" + st.nextToken().trim());
                ++k;
            }
            return result;
        }
        catch (Exception e) {
            throw new EmbeddedJmxTransException("Exception buildind etcd server list from: '" + etcdURI + "': " + e.getMessage(), e);
        }
    }

    private KeyValue getFromEtcd(URL[] baseUris, String key) throws EmbeddedJmxTransException {
        String json = null;
        int k = -1;
        while (k < baseUris.length - 1) {
            String httpResponse;
            if ((httpResponse = this.httpGET(baseUris[++k], key)) == null) {
                return null;
            }
            if (HTTP_ERR.equals(httpResponse)) continue;
            json = httpResponse;
            break;
        }
        if (json == null) {
            return null;
        }
        EtcdResult res = null;
        try {
            res = (EtcdResult)this.mapper.readValue(json, EtcdResult.class);
        }
        catch (Exception e) {
            throw new EmbeddedJmxTransException("Exception parsing etcd response: '" + json + "': " + e.getMessage(), e);
        }
        if (res.errorCode == null) {
            return new KeyValue(res.node.value, Long.toString(res.node.modifiedIndex));
        }
        if (res.errorCode == 100) {
            return null;
        }
        throw new EmbeddedJmxTransException("Etcd error reading etcd key '" + key + "': " + res.errorCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String httpGET(URL base, String key) {
        InputStream is = null;
        HttpURLConnection conn = null;
        String json = null;
        try {
            URL url = new URL(base + "/v2/keys/" + key);
            conn = (HttpURLConnection)url.openConnection(Proxy.NO_PROXY);
            conn.setRequestMethod("GET");
            conn.setConnectTimeout(2000);
            conn.setReadTimeout(2000);
            conn.connect();
            int respCode = conn.getResponseCode();
            if (respCode == 404) {
                String string = null;
                return string;
            }
            if (respCode > 400) {
                String string = HTTP_ERR;
                return string;
            }
            is = conn.getInputStream();
            String contentEncoding = conn.getContentEncoding() != null ? conn.getContentEncoding() : "UTF-8";
            json = IOUtils.toString((InputStream)is, (String)contentEncoding);
        }
        catch (MalformedURLException e) {
            json = HTTP_ERR;
        }
        catch (ProtocolException e) {
            json = HTTP_ERR;
        }
        catch (IOException e) {
            json = HTTP_ERR;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
            if (conn != null) {
                conn.disconnect();
            }
        }
        return json;
    }

    public static class EtcdResult {
        private String action;
        private EtcdNode node;
        private Integer errorCode;
        private String message;
        private String cause;
        private int errorIndex;

        public String getAction() {
            return this.action;
        }

        public void setAction(String action) {
            this.action = action;
        }

        public EtcdNode getNode() {
            return this.node;
        }

        public void setNode(EtcdNode node) {
            this.node = node;
        }

        public Integer getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(Integer errorCode) {
            this.errorCode = errorCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getCause() {
            return this.cause;
        }

        public void setCause(String cause) {
            this.cause = cause;
        }

        public int getErrorIndex() {
            return this.errorIndex;
        }

        public void setErrorIndex(int errorIndex) {
            this.errorIndex = errorIndex;
        }
    }

    public static class EtcdNode {
        private String key;
        private long createdIndex;
        private long modifiedIndex;
        private String value;
        private String expiration;
        private Integer ttl;

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public long getCreatedIndex() {
            return this.createdIndex;
        }

        public void setCreatedIndex(long createdIndex) {
            this.createdIndex = createdIndex;
        }

        public long getModifiedIndex() {
            return this.modifiedIndex;
        }

        public void setModifiedIndex(long modifiedIndex) {
            this.modifiedIndex = modifiedIndex;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getExpiration() {
            return this.expiration;
        }

        public void setExpiration(String expiration) {
            this.expiration = expiration;
        }

        public Integer getTtl() {
            return this.ttl;
        }

        public void setTtl(Integer ttl) {
            this.ttl = ttl;
        }
    }
}

