/*
 * Decompiled with CFR 0.152.
 */
package org.jmxtrans.embedded.util.net;

import javax.annotation.Nonnull;
import org.jmxtrans.embedded.util.Preconditions;

public class HostAndPort {
    private final String host;
    private final int port;

    public HostAndPort(@Nonnull String host, int port) {
        this.host = Preconditions.checkNotEmpty(host, "'host' can not be empty");
        this.port = port;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HostAndPort)) {
            return false;
        }
        HostAndPort that = (HostAndPort)o;
        if (this.port != that.port) {
            return false;
        }
        return this.host.equals(that.host);
    }

    public int hashCode() {
        int result = this.host.hashCode();
        result = 31 * result + this.port;
        return result;
    }

    public String toString() {
        return "HostAndPort{host='" + this.host + '\'' + ", port=" + this.port + '}';
    }
}

