/*
 * Decompiled with CFR 0.152.
 */
package org.joda.money;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.joda.money.CurrencyUnitDataProvider;

class DefaultCurrencyUnitDataProvider
extends CurrencyUnitDataProvider {
    private static final Pattern CURRENCY_REGEX_LINE = Pattern.compile("([A-Z]{3}),(-1|[0-9]{1,3}),(-1|[0-9]|[1-2][0-9]|30) *(#.*)?");
    private static final Pattern COUNTRY_REGEX_LINE = Pattern.compile("([A-Z]{2}),([A-Z]{3}) *(#.*)?");

    DefaultCurrencyUnitDataProvider() {
    }

    @Override
    protected void registerCurrencies() throws Exception {
        this.parseCurrencies(this.loadFromFile("/org/joda/money/CurrencyData.csv"));
        this.parseCountries(this.loadFromFile("/org/joda/money/CountryData.csv"));
        this.parseCurrencies(this.loadFromFiles("META-INF/org/joda/money/CurrencyDataExtension.csv"));
        this.parseCountries(this.loadFromFiles("META-INF/org/joda/money/CountryDataExtension.csv"));
    }

    private List<String> loadFromFile(String fileName) throws Exception {
        try (InputStream in = this.getClass().getResourceAsStream(fileName);){
            String line;
            if (in == null) {
                throw new FileNotFoundException("Data file " + fileName + " not found");
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(in, "UTF-8"));
            ArrayList<String> content = new ArrayList<String>();
            while ((line = reader.readLine()) != null) {
                content.add(line);
            }
            ArrayList<String> arrayList = content;
            return arrayList;
        }
    }

    private List<String> loadFromFiles(String fileName) throws Exception {
        ArrayList<String> content = new ArrayList<String>();
        Enumeration<URL> en = this.getClass().getClassLoader().getResources(fileName);
        while (en.hasMoreElements()) {
            URL url = en.nextElement();
            InputStream in = url.openStream();
            Throwable throwable = null;
            try {
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader(in, "UTF-8"));
                while ((line = reader.readLine()) != null) {
                    content.add(line);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (in == null) continue;
                DefaultCurrencyUnitDataProvider.$closeResource(throwable, in);
            }
        }
        return content;
    }

    private void parseCurrencies(List<String> content) throws Exception {
        for (String line : content) {
            Matcher matcher = CURRENCY_REGEX_LINE.matcher(line);
            if (!matcher.matches()) continue;
            String currencyCode = matcher.group(1);
            int numericCode = Integer.parseInt(matcher.group(2));
            int digits = Integer.parseInt(matcher.group(3));
            this.registerCurrency(currencyCode, numericCode, digits);
        }
    }

    private void parseCountries(List<String> content) throws Exception {
        for (String line : content) {
            Matcher matcher = COUNTRY_REGEX_LINE.matcher(line);
            if (!matcher.matches()) continue;
            String countryCode = matcher.group(1);
            String currencyCode = matcher.group(2);
            this.registerCountry(countryCode, currencyCode);
        }
    }
}

