/*
 * Decompiled with CFR 0.152.
 */
package jodd.typeconverter.impl;

import jodd.typeconverter.ConvertBean;
import jodd.typeconverter.TypeConverter;
import jodd.util.CsvUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DoubleArrayConverter
implements TypeConverter<double[]> {
    protected final ConvertBean convertBean;

    public DoubleArrayConverter(ConvertBean convertBean) {
        this.convertBean = convertBean;
    }

    @Override
    public double[] convert(Object value) {
        if (value == null) {
            return null;
        }
        Class<?> type = value.getClass();
        if (!type.isArray()) {
            if (type == String.class) {
                Object[] values = CsvUtil.toStringArray(value.toString());
                return this.convertArray(values);
            }
            return new double[]{this.convertBean.toDoubleValue(value)};
        }
        if (type.getComponentType().isPrimitive()) {
            if (type == double[].class) {
                return (double[])value;
            }
            if (type == float[].class) {
                float[] values = (float[])value;
                double[] results = new double[values.length];
                for (int i = 0; i < values.length; ++i) {
                    results[i] = values[i];
                }
                return results;
            }
            if (type == int[].class) {
                int[] values = (int[])value;
                double[] results = new double[values.length];
                for (int i = 0; i < values.length; ++i) {
                    results[i] = values[i];
                }
                return results;
            }
            if (type == long[].class) {
                long[] values = (long[])value;
                double[] results = new double[values.length];
                for (int i = 0; i < values.length; ++i) {
                    results[i] = values[i];
                }
                return results;
            }
            if (type == byte[].class) {
                byte[] values = (byte[])value;
                double[] results = new double[values.length];
                for (int i = 0; i < values.length; ++i) {
                    results[i] = values[i];
                }
                return results;
            }
            if (type == boolean[].class) {
                boolean[] values = (boolean[])value;
                double[] results = new double[values.length];
                for (int i = 0; i < values.length; ++i) {
                    results[i] = values[i] ? 1 : 0;
                }
                return results;
            }
            if (type == short[].class) {
                short[] values = (short[])value;
                double[] results = new double[values.length];
                for (int i = 0; i < values.length; ++i) {
                    results[i] = values[i];
                }
                return results;
            }
        }
        return this.convertArray((Object[])value);
    }

    protected double[] convertArray(Object[] values) {
        double[] results = new double[values.length];
        for (int i = 0; i < values.length; ++i) {
            results[i] = this.convertBean.toDoubleValue(values[i]);
        }
        return results;
    }
}

