/*
 * Decompiled with CFR 0.152.
 */
package jodd.util;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import jodd.JoddCore;

public class URLCoder {
    protected static final char[][] URL_CHARS = new char[256][];
    protected static final char[][] URI_CHARS = new char[128][];
    private static final char[] HEX_DIGITS;

    public static String encodeUrl(String url) {
        return URLCoder.encodeUrl(url, JoddCore.encoding);
    }

    public static String encodeUrl(String url, String encoding) {
        int paramNdx = url.indexOf(63);
        if (paramNdx == -1) {
            return URLCoder.encodePath(url);
        }
        StringBuilder result = new StringBuilder(url.length() >> 1);
        URLCoder.appendPath(result, url.substring(0, paramNdx));
        result.append('?');
        ++paramNdx;
        while (true) {
            int ampNdx;
            String q;
            int eqNdx;
            if ((eqNdx = (q = (ampNdx = url.indexOf(38, paramNdx)) == -1 ? url.substring(paramNdx) : url.substring(paramNdx, ampNdx)).indexOf(61)) == -1) {
                URLCoder.appendQuery(result, q, encoding);
            } else {
                String name = q.substring(0, eqNdx);
                URLCoder.appendQuery(result, name, encoding);
                result.append('=');
                String value = q.substring(eqNdx + 1);
                if (value.length() > 0) {
                    URLCoder.appendQuery(result, value, encoding);
                }
            }
            if (ampNdx == -1) break;
            result.append('&');
            paramNdx = ampNdx + 1;
        }
        return result.toString();
    }

    protected static void appendQuery(StringBuilder result, String value, String encoding) {
        byte[] bytes;
        try {
            bytes = value.getBytes(encoding);
        }
        catch (UnsupportedEncodingException ueex) {
            throw new IllegalArgumentException(ueex.toString());
        }
        for (byte b : bytes) {
            int i = b & 0xFF;
            result.append(URL_CHARS[i]);
        }
    }

    public static String encodeQuery(String value, String encoding) {
        StringBuilder sb = new StringBuilder(value.length());
        URLCoder.appendQuery(sb, value, encoding);
        return sb.toString();
    }

    public static String encodeQuery(String value) {
        return URLCoder.encodeQuery(value, JoddCore.encoding);
    }

    protected static void appendPath(StringBuilder result, String value) {
        int len = value.length();
        for (int i = 0; i < len; ++i) {
            char c = value.charAt(i);
            if (c < '\u0080') {
                result.append(URI_CHARS[c]);
                continue;
            }
            if (Character.isSpaceChar(c) || Character.isISOControl(c)) {
                URLCoder.appendEncoded(result, c);
                continue;
            }
            result.append(c);
        }
    }

    public static String encodePath(String value) {
        StringBuilder sb = new StringBuilder(value.length());
        URLCoder.appendPath(sb, value);
        return sb.toString();
    }

    private static void appendEncoded(StringBuilder sb, char c) {
        byte[] bytes;
        try {
            bytes = String.valueOf(c).getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ignore) {
            return;
        }
        for (byte b : bytes) {
            int i = b & 0xFF;
            if (i >= 128) {
                sb.append('%');
                sb.append(HEX_DIGITS[i >> 4]);
                sb.append(HEX_DIGITS[i & 0xF]);
                continue;
            }
            sb.append((char)i);
        }
    }

    public static Builder build() {
        return new Builder(JoddCore.encoding);
    }

    static {
        for (char c = '\u0000'; c < URL_CHARS.length; c = (char)(c + '\u0001')) {
            try {
                URLCoder.URL_CHARS[c] = URLEncoder.encode(String.valueOf(c), "ISO-8859-1").toCharArray();
            }
            catch (UnsupportedEncodingException ueex) {
                ueex.printStackTrace();
            }
            if (c >= URI_CHARS.length) continue;
            try {
                URI uri = new URI("a", "", '/' + String.valueOf(c), null, null);
                URLCoder.URI_CHARS[c] = uri.toString().substring(5).toCharArray();
                continue;
            }
            catch (URISyntaxException usex) {
                usex.printStackTrace();
            }
        }
        HEX_DIGITS = "0123456789ABCDEF".toCharArray();
    }

    public static class Builder {
        protected final StringBuilder url = new StringBuilder();
        protected final String encoding;
        protected boolean hasParams = false;

        public Builder(String encoding) {
            this.encoding = encoding;
        }

        public Builder path(String value) {
            if (this.hasParams) {
                throw new IllegalArgumentException("Path element can't come after query parameters");
            }
            URLCoder.appendPath(this.url, value);
            return this;
        }

        public Builder param(String name, Object value) {
            return this.param(name, value == null ? null : value.toString());
        }

        public Builder param(String name, String value) {
            this.url.append(this.hasParams ? (char)'&' : '?');
            this.hasParams = true;
            URLCoder.appendQuery(this.url, name, this.encoding);
            if (value != null && value.length() > 0) {
                this.url.append('=');
                URLCoder.appendQuery(this.url, value, this.encoding);
            }
            return this;
        }

        public Builder param(String nameValue) {
            String name;
            this.url.append(this.hasParams ? (char)'&' : '?');
            this.hasParams = true;
            int eqNdx = nameValue.indexOf(61);
            String value = null;
            if (eqNdx == -1) {
                name = nameValue;
            } else {
                name = nameValue.substring(0, eqNdx);
                value = nameValue.substring(eqNdx + 1);
            }
            URLCoder.appendQuery(this.url, name, this.encoding);
            if (value != null && value.length() > 0) {
                this.url.append('=');
                URLCoder.appendQuery(this.url, value, this.encoding);
            }
            return this;
        }

        public String toString() {
            return this.url.toString();
        }
    }
}

