/*
 * Decompiled with CFR 0.152.
 */
package jodd.util.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class Annotations<A extends Annotation> {
    private final Class<A> annotationClass;
    private final List<A> annotations = new ArrayList<A>();

    public Annotations(Class<A> annotationClass) {
        this.annotationClass = annotationClass;
    }

    public static <T extends Annotation> Annotations<T> of(Class<T> annotationClass) {
        return new Annotations<T>(annotationClass);
    }

    public Annotations onMethod(Method method) {
        A a = method.getAnnotation(this.annotationClass);
        if (a != null) {
            this.annotations.add(a);
        }
        return this;
    }

    public Annotations<A> onClass(Class type) {
        A a = type.getAnnotation(this.annotationClass);
        if (a != null) {
            this.annotations.add(a);
        }
        return this;
    }

    public Annotations<A> onPackageHierarchyOf(Class type) {
        return this.onPackageHierarchy(type.getPackage());
    }

    public Annotations<A> onPackageHierarchy(Package pck) {
        String packageName = pck.getName();
        while (true) {
            int ndx;
            A a;
            if (pck != null && (a = pck.getAnnotation(this.annotationClass)) != null) {
                this.annotations.add(a);
            }
            if ((ndx = packageName.lastIndexOf(46)) == -1) break;
            packageName = packageName.substring(0, ndx);
            pck = Package.getPackage(packageName);
        }
        return this;
    }

    public List<A> collect() {
        return this.annotations;
    }
}

