/*
 * Decompiled with CFR 0.152.
 */
package jodd.system;

import java.lang.management.ManagementFactory;
import jodd.system.OsInfo;
import jodd.util.Format;

abstract class RuntimeInfo
extends OsInfo {
    private Runtime runtime = Runtime.getRuntime();

    RuntimeInfo() {
    }

    public final long getMaxMemory() {
        return this.runtime.maxMemory();
    }

    public final long getTotalMemory() {
        return this.runtime.totalMemory();
    }

    public final long getFreeMemory() {
        return this.runtime.freeMemory();
    }

    public final long getAvailableMemory() {
        return this.runtime.maxMemory() - this.runtime.totalMemory() + this.runtime.freeMemory();
    }

    public final long getCurrentPID() {
        return Long.parseLong(ManagementFactory.getRuntimeMXBean().getName().split("@")[0]);
    }

    @Override
    public String toString() {
        return super.toString() + "\nMax memory:              " + Format.humanReadableByteCount(this.getMaxMemory(), false) + "\nTotal memory:            " + Format.humanReadableByteCount(this.getTotalMemory(), false) + "\nFree memory:             " + Format.humanReadableByteCount(this.getFreeMemory(), false) + "\nAvailableMemory memory:  " + Format.humanReadableByteCount(this.getAvailableMemory(), false) + "\nProcess ID (PID):        " + this.getCurrentPID();
    }
}

