/*
 * Decompiled with CFR 0.152.
 */
package org.joinfaces.autoconfigure.rewrite;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.ocpsoft.rewrite.el.spi.BeanNameResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.lang.Nullable;

public class SpringBootBeanNameResolver
implements BeanNameResolver {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SpringBootBeanNameResolver.class);
    private final ApplicationContext context;

    @Nullable
    public String getBeanName(Class<?> clazz) {
        Set<String> beanNames = this.resolveBeanNames((ListableBeanFactory)this.context, clazz);
        if (beanNames.size() == 0) {
            return null;
        }
        if (beanNames.size() > 1) {
            log.warn("Spring knows more than one bean of type [{}]", (Object)clazz.getName());
            return null;
        }
        return beanNames.iterator().next();
    }

    private Set<String> resolveBeanNames(ListableBeanFactory beanFactory, Class<?> clazz) {
        HashSet<String> result = new HashSet<String>();
        Map beanMap = beanFactory.getBeansOfType(clazz);
        for (String name : beanMap.keySet()) {
            if (name == null || name.startsWith("scopedTarget.")) continue;
            result.add(name);
        }
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SpringBootBeanNameResolver(ApplicationContext context) {
        this.context = context;
    }
}

