/*
 * Decompiled with CFR 0.152.
 */
package org.joinfaces.autoconfigure.scopemapping;

import jakarta.faces.view.ViewScoped;
import org.joinfaces.autoconfigure.scopemapping.CustomScopeAnnotationConfigurer;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.core.env.Environment;

@AutoConfiguration
@ConditionalOnClass(value={ViewScoped.class})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
public class FacesScopeAnnotationsAutoConfiguration {
    @Bean
    @ConditionalOnProperty(value={"joinfaces.scope-configurer.faces.enabled"}, havingValue="true", matchIfMissing=true)
    public static CustomScopeAnnotationConfigurer facesScopeAnnotationsConfigurer(Environment environment) {
        CustomScopeAnnotationConfigurer scopeAnnotationConfigurer = new CustomScopeAnnotationConfigurer();
        scopeAnnotationConfigurer.setOrder((Integer)environment.getProperty("joinfaces.scope-configurer.faces.order", Integer.class, (Object)Integer.MAX_VALUE));
        scopeAnnotationConfigurer.addMapping(ViewScoped.class, "view");
        return scopeAnnotationConfigurer;
    }
}

