/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.util;

import java.lang.management.ManagementFactory;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ServersInfo {
    private ServersInfo() {
    }

    public static String dump(Set<MBeanServerConnection> servers) {
        StringBuffer ret = new StringBuffer();
        ret.append("Found ").append(servers.size()).append(" MBeanServers\n");
        for (MBeanServerConnection c : servers) {
            MBeanServer s = (MBeanServer)c;
            ret.append("    ").append("++ ").append(s.toString()).append(": default domain = ").append(s.getDefaultDomain()).append(", ").append(s.getMBeanCount()).append(" MBeans\n");
            ret.append("        Domains:\n");
            for (String d : s.getDomains()) {
                ServersInfo.appendDomainInfo(ret, s, d);
            }
        }
        ret.append("\n");
        ret.append("Platform MBeanServer: ").append(ManagementFactory.getPlatformMBeanServer()).append("\n");
        return ret.toString();
    }

    private static void appendDomainInfo(StringBuffer pRet, MBeanServer pServer, String pDomain) {
        try {
            pRet.append("         == ").append(pDomain).append("\n");
            Set<ObjectInstance> beans = pServer.queryMBeans(new ObjectName(pDomain + ":*"), null);
            for (ObjectInstance o : beans) {
                String n = o.getObjectName().getCanonicalKeyPropertyListString();
                pRet.append("              ").append(n).append("\n");
            }
        }
        catch (MalformedObjectNameException e) {
            pRet.append("              INTERNAL ERROR: ").append(e).append("\n");
        }
    }
}

