/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.util;

import java.io.PrintWriter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import org.jooq.EnumType;
import org.jooq.MasterDataType;
import org.jooq.UDTRecord;
import org.jooq.tools.StringUtils;

public class GenerationWriter {
    private static final String SUPPRESS_WARNINGS_STATEMENT = "__SUPPRESS_WARNINGS_STATEMENT__";
    private static final String STATIC_INITIALISATION_STATEMENT = "__STATIC_INITIALISATION_STATEMENT__";
    private static final String INITIALISATION_STATEMENT = "__INITIALISATION_STATEMENT__";
    private static final String SERIAL_STATEMENT = "__SERIAL_STATEMENT__";
    private final PrintWriter writer;
    private final StringBuilder sb;
    private final List<String> staticInitialisationStatements;
    private final List<String> initialisationStatements;
    private final Set<Object> alreadyPrinted;
    private final Set<String> suppressWarnings;

    public GenerationWriter(PrintWriter writer) {
        this.writer = writer;
        this.sb = new StringBuilder();
        this.staticInitialisationStatements = new ArrayList<String>();
        this.initialisationStatements = new ArrayList<String>();
        this.alreadyPrinted = new HashSet<Object>();
        this.suppressWarnings = new TreeSet<String>();
    }

    public void printStaticInitialisationStatementsPlaceholder() {
        this.println(STATIC_INITIALISATION_STATEMENT);
    }

    public void printInitialisationStatementsPlaceholder() {
        this.println(INITIALISATION_STATEMENT);
    }

    public void printSuppressWarningsPlaceholder() {
        this.println(SUPPRESS_WARNINGS_STATEMENT);
    }

    public void printStaticInitialisationStatement(String statement) {
        this.staticInitialisationStatements.add(statement);
    }

    public void printInitialisationStatement(String statement) {
        this.initialisationStatements.add(statement);
    }

    public void print(String string) {
        this.sb.append(string);
    }

    public void println(String string) {
        this.sb.append(string + "\n");
    }

    public void println() {
        this.sb.append("\n");
    }

    public void print(Class<?> clazz) {
        this.sb.append(clazz.getCanonicalName());
    }

    public boolean printOnlyOnce(Object object) {
        if (!this.alreadyPrinted.contains(object)) {
            this.alreadyPrinted.add(object);
            return true;
        }
        return false;
    }

    public void printSerial() {
        this.println();
        this.println("\tprivate static final long serialVersionUID = __SERIAL_STATEMENT__;");
    }

    public void close() {
        String string = this.sb.toString();
        StringBuilder staticInits = new StringBuilder();
        StringBuilder inits = new StringBuilder();
        StringBuilder warnings = new StringBuilder();
        boolean hasStaticInits = false;
        boolean hasInits = false;
        for (String statement : this.staticInitialisationStatements) {
            if (StringUtils.isBlank((String)statement)) continue;
            hasStaticInits = true;
            break;
        }
        for (String statement : this.initialisationStatements) {
            if (StringUtils.isBlank((String)statement)) continue;
            hasInits = true;
            break;
        }
        if (hasStaticInits) {
            staticInits.append("\n");
            staticInits.append("\t/*\n");
            staticInits.append("\t * static initialiser\n");
            staticInits.append("\t */\n");
            staticInits.append("\tstatic {\n");
            for (String statement : this.staticInitialisationStatements) {
                staticInits.append("\t\t" + statement + "\n");
            }
            staticInits.append("\t}\n");
        }
        if (hasInits) {
            inits.append("\n");
            inits.append("\t/*\n");
            inits.append("\t * instance initialiser\n");
            inits.append("\t */\n");
            inits.append("\t{\n");
            for (String statement : this.initialisationStatements) {
                inits.append("\t\t" + statement + "\n");
            }
            inits.append("\t}\n");
        }
        if (!this.suppressWarnings.isEmpty()) {
            warnings.append("@SuppressWarnings({");
            String separator = "";
            for (String warning : this.suppressWarnings) {
                warnings.append(separator);
                warnings.append("\"");
                warnings.append(warning);
                warnings.append("\"");
                separator = ", ";
            }
            warnings.append("})\n");
        }
        string = string.replaceAll("__STATIC_INITIALISATION_STATEMENT__\\n", Matcher.quoteReplacement(staticInits.toString()));
        string = string.replaceAll("__INITIALISATION_STATEMENT__\\n", Matcher.quoteReplacement(inits.toString()));
        string = string.replaceAll("__SUPPRESS_WARNINGS_STATEMENT__\\n", Matcher.quoteReplacement(warnings.toString()));
        string = string.replaceAll(SERIAL_STATEMENT, Matcher.quoteReplacement(String.valueOf(string.hashCode())));
        this.writer.append(string);
        this.writer.close();
    }

    public <T> void printNewJavaObject(Object value) {
        this.print(this.getNewJavaObject(value));
    }

    private <T> String getNewJavaObject(Object value) {
        if (value == null) {
            return "null";
        }
        Class<?> type = value.getClass();
        if (type != Blob.class) {
            if (type == Boolean.class) {
                return Boolean.toString(this.getIsTrue(String.valueOf(value)));
            }
            if (type == BigInteger.class) {
                return "new java.math.BigInteger(\"" + value + "\")";
            }
            if (type == BigDecimal.class) {
                return "new java.math.BigDecimal(\"" + value + "\")";
            }
            if (type == Byte.class) {
                return "(byte) " + value;
            }
            if (type != byte[].class && type != Clob.class) {
                if (type == Date.class) {
                    return "new java.sql.Date(" + ((Date)value).getTime() + "L)";
                }
                if (type == Double.class) {
                    return Double.toString((Double)value);
                }
                if (type == Float.class) {
                    return Float.toString(((Float)value).floatValue()) + "f";
                }
                if (type == Integer.class) {
                    return Integer.toString((Integer)value);
                }
                if (type == Long.class) {
                    return Long.toString((Long)value) + "L";
                }
                if (type == Short.class) {
                    return "(short) " + value;
                }
                if (type == String.class) {
                    return "\"" + value.toString().replace("\"", "\\\"") + "\"";
                }
                if (type == Time.class) {
                    return "new java.sql.Time(" + ((Time)value).getTime() + "L)";
                }
                if (type == Timestamp.class) {
                    return "new java.sql.Timestamp(" + ((Timestamp)value).getTime() + "L)";
                }
                if (MasterDataType.class.isAssignableFrom(type) || EnumType.class.isAssignableFrom(type) || UDTRecord.class.isAssignableFrom(type)) {
                    // empty if block
                }
            }
        }
        throw new UnsupportedOperationException("Class " + type + " is not supported");
    }

    private boolean getIsTrue(String string) {
        if ("1".equals(string)) {
            return true;
        }
        return "true".equalsIgnoreCase(string);
    }

    public void suppressWarnings(String string) {
        this.suppressWarnings.add(string);
    }
}

