/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.util;

import java.sql.Connection;
import org.jooq.SQLDialect;
import org.jooq.impl.Factory;
import org.jooq.util.Database;
import org.jooq.util.Definition;
import org.jooq.util.SchemaDefinition;

public abstract class AbstractDefinition
implements Definition {
    private final Database database;
    private final SchemaDefinition schema;
    private final String name;
    private final String comment;
    private final String overload;

    public AbstractDefinition(Database database, SchemaDefinition schema, String name) {
        this(database, schema, name, null);
    }

    public AbstractDefinition(Database database, SchemaDefinition schema, String name, String comment) {
        this(database, schema, name, comment, null);
    }

    public AbstractDefinition(Database database, SchemaDefinition schema, String name, String comment, String overload) {
        this.database = database;
        this.schema = schema == null && this instanceof SchemaDefinition ? (SchemaDefinition)this : schema;
        this.name = name;
        this.comment = comment;
        this.overload = overload;
    }

    @Override
    public final String getOverload() {
        return this.overload;
    }

    @Override
    public final SchemaDefinition getSchema() {
        return this.schema;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final String getInputName() {
        return this.name;
    }

    @Override
    public String getOutputName() {
        return this.getInputName();
    }

    @Override
    public final String getComment() {
        return this.comment;
    }

    @Override
    public final String getQualifiedName() {
        return this.getQualifiedInputName();
    }

    @Override
    public final String getQualifiedInputName() {
        StringBuilder sb = new StringBuilder();
        String separator = "";
        for (Definition part : this.getDefinitionPath()) {
            if (part instanceof SchemaDefinition && ((SchemaDefinition)part).isDefaultSchema()) continue;
            sb.append(separator);
            sb.append(part.getInputName());
            separator = ".";
        }
        return sb.toString();
    }

    @Override
    public final String getQualifiedOutputName() {
        StringBuilder sb = new StringBuilder();
        String separator = "";
        for (Definition part : this.getDefinitionPath()) {
            if (part instanceof SchemaDefinition && ((SchemaDefinition)part).isDefaultSchema()) continue;
            sb.append(separator);
            sb.append(part.getOutputName());
            separator = ".";
        }
        return sb.toString();
    }

    @Override
    public final Database getDatabase() {
        return this.database;
    }

    protected final Connection getConnection() {
        return this.database.getConnection();
    }

    public final String toString() {
        return this.getQualifiedName();
    }

    public final boolean equals(Object obj) {
        if (obj instanceof Definition) {
            Definition that = (Definition)obj;
            return that.getQualifiedName().equals(this.getQualifiedName());
        }
        return false;
    }

    public final int hashCode() {
        return this.getQualifiedName().hashCode();
    }

    protected final Factory create() {
        return this.database.create();
    }

    protected final SQLDialect getDialect() {
        return this.create().getDialect();
    }
}

