/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.jooq.util.AbstractDefinition;
import org.jooq.util.ColumnDefinition;
import org.jooq.util.Definition;
import org.jooq.util.ForeignKeyDefinition;
import org.jooq.util.SchemaDefinition;
import org.jooq.util.TableDefinition;
import org.jooq.util.UniqueKeyDefinition;

public class DefaultForeignKeyDefinition
extends AbstractDefinition
implements ForeignKeyDefinition {
    private final List<ColumnDefinition> keyColumns = new ArrayList<ColumnDefinition>();
    private final TableDefinition table;
    private final UniqueKeyDefinition uniqueKey;

    public DefaultForeignKeyDefinition(SchemaDefinition schema, String name, TableDefinition table, UniqueKeyDefinition uniqueKey) {
        super(schema.getDatabase(), schema, name, null);
        this.table = table;
        this.uniqueKey = uniqueKey;
    }

    @Override
    public List<Definition> getDefinitionPath() {
        return Arrays.asList(this.getSchema(), this);
    }

    @Override
    public TableDefinition getKeyTable() {
        return this.table;
    }

    @Override
    public List<ColumnDefinition> getKeyColumns() {
        return this.keyColumns;
    }

    @Override
    public UniqueKeyDefinition getReferencedKey() {
        return this.uniqueKey;
    }

    @Override
    public TableDefinition getReferencedTable() {
        return this.uniqueKey.getTable();
    }

    @Override
    public List<ColumnDefinition> getReferencedColumns() {
        return this.uniqueKey.getKeyColumns();
    }

    @Override
    public int countSimilarReferences() {
        HashSet<String> keys = new HashSet<String>();
        for (ColumnDefinition column : this.table.getColumns()) {
            ForeignKeyDefinition key = this.getDatabase().getRelations().getForeignKey(column);
            if (key == null || !key.getReferencedTable().equals(this.getReferencedTable())) continue;
            keys.add(key.getName());
        }
        return keys.size();
    }
}

