/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.util;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.jooq.tools.JooqLogger;
import org.jooq.util.ColumnDefinition;
import org.jooq.util.DefaultForeignKeyDefinition;
import org.jooq.util.DefaultUniqueKeyDefinition;
import org.jooq.util.Definition;
import org.jooq.util.ForeignKeyDefinition;
import org.jooq.util.Relations;
import org.jooq.util.SchemaDefinition;
import org.jooq.util.TableDefinition;
import org.jooq.util.UniqueKeyDefinition;

public class DefaultRelations
implements Relations {
    private static final JooqLogger log = JooqLogger.getLogger(DefaultRelations.class);
    private Map<Key, ForeignKeyDefinition> foreignKeys = new LinkedHashMap<Key, ForeignKeyDefinition>();
    private Map<Key, UniqueKeyDefinition> primaryKeys = new LinkedHashMap<Key, UniqueKeyDefinition>();
    private Map<Key, UniqueKeyDefinition> uniqueKeys = new LinkedHashMap<Key, UniqueKeyDefinition>();
    private Map<ColumnDefinition, ForeignKeyDefinition> foreignKeysByColumn = new LinkedHashMap<ColumnDefinition, ForeignKeyDefinition>();
    private Map<ColumnDefinition, UniqueKeyDefinition> primaryKeysByColumn = new LinkedHashMap<ColumnDefinition, UniqueKeyDefinition>();
    private Map<ColumnDefinition, List<UniqueKeyDefinition>> uniqueKeysByColumn = new LinkedHashMap<ColumnDefinition, List<UniqueKeyDefinition>>();

    public void addPrimaryKey(String keyName, ColumnDefinition column) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Adding primary key", (Object)(keyName + " (" + column + ")"));
        }
        UniqueKeyDefinition key = this.getUniqueKey(keyName, column, true);
        key.getKeyColumns().add(column);
    }

    public void addUniqueKey(String keyName, ColumnDefinition column) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Adding unique key", (Object)(keyName + " (" + column + ")"));
        }
        UniqueKeyDefinition key = this.getUniqueKey(keyName, column, false);
        key.getKeyColumns().add(column);
    }

    private UniqueKeyDefinition getUniqueKey(String keyName, ColumnDefinition column, boolean isPK) {
        UniqueKeyDefinition key = this.uniqueKeys.get(DefaultRelations.key(column, keyName));
        if (key == null) {
            key = new DefaultUniqueKeyDefinition(column.getSchema(), keyName, (TableDefinition)column.getContainer());
            this.uniqueKeys.put(DefaultRelations.key(column, keyName), key);
            if (isPK) {
                this.primaryKeys.put(DefaultRelations.key(column, keyName), key);
            }
        }
        return key;
    }

    public void addForeignKey(String foreignKeyName, String uniqueKeyName, ColumnDefinition foreignKeyColumn, SchemaDefinition uniqueKeySchema) {
        UniqueKeyDefinition uniqueKey;
        if (uniqueKeySchema == null) {
            log.warn((Object)"Unused foreign key", (Object)(foreignKeyName + " (" + foreignKeyColumn + ") referencing " + uniqueKeyName + " references a schema out of scope for jooq-meta"));
            return;
        }
        log.info((Object)"Adding foreign key", (Object)(foreignKeyName + " (" + foreignKeyColumn + ") referencing " + uniqueKeyName));
        ForeignKeyDefinition foreignKey = this.foreignKeys.get(DefaultRelations.key(foreignKeyColumn, foreignKeyName));
        if (foreignKey == null && (uniqueKey = this.uniqueKeys.get(DefaultRelations.key(uniqueKeySchema, uniqueKeyName))) != null) {
            foreignKey = new DefaultForeignKeyDefinition(foreignKeyColumn.getSchema(), foreignKeyName, (TableDefinition)foreignKeyColumn.getContainer(), uniqueKey);
            this.foreignKeys.put(DefaultRelations.key(foreignKeyColumn, foreignKeyName), foreignKey);
            uniqueKey.getForeignKeys().add(foreignKey);
        }
        if (foreignKey != null) {
            foreignKey.getKeyColumns().add(foreignKeyColumn);
        }
    }

    @Override
    public UniqueKeyDefinition getPrimaryKey(ColumnDefinition column) {
        if (!this.primaryKeysByColumn.containsKey(column)) {
            UniqueKeyDefinition key = null;
            for (UniqueKeyDefinition primaryKey : this.primaryKeys.values()) {
                if (!primaryKey.getKeyColumns().contains(column)) continue;
                key = primaryKey;
                break;
            }
            this.primaryKeysByColumn.put(column, key);
        }
        return this.primaryKeysByColumn.get(column);
    }

    @Override
    public List<UniqueKeyDefinition> getUniqueKeys(ColumnDefinition column) {
        if (!this.uniqueKeysByColumn.containsKey(column)) {
            ArrayList<UniqueKeyDefinition> list = new ArrayList<UniqueKeyDefinition>();
            for (UniqueKeyDefinition uniqueKey : this.uniqueKeys.values()) {
                if (!uniqueKey.getKeyColumns().contains(column)) continue;
                list.add(uniqueKey);
            }
            this.uniqueKeysByColumn.put(column, list);
        }
        return this.uniqueKeysByColumn.get(column);
    }

    @Override
    public List<UniqueKeyDefinition> getUniqueKeys(TableDefinition table) {
        LinkedHashSet<UniqueKeyDefinition> result = new LinkedHashSet<UniqueKeyDefinition>();
        for (ColumnDefinition column : table.getColumns()) {
            result.addAll(this.getUniqueKeys(column));
        }
        return new ArrayList<UniqueKeyDefinition>(result);
    }

    @Override
    public ForeignKeyDefinition getForeignKey(ColumnDefinition column) {
        if (!this.foreignKeysByColumn.containsKey(column)) {
            ForeignKeyDefinition key = null;
            for (ForeignKeyDefinition foreignKey : this.foreignKeys.values()) {
                if (!foreignKey.getKeyColumns().contains(column)) continue;
                key = foreignKey;
                break;
            }
            this.foreignKeysByColumn.put(column, key);
        }
        return this.foreignKeysByColumn.get(column);
    }

    @Override
    public List<ForeignKeyDefinition> getForeignKeys(TableDefinition table) {
        LinkedHashSet<ForeignKeyDefinition> result = new LinkedHashSet<ForeignKeyDefinition>();
        for (ColumnDefinition column : table.getColumns()) {
            ForeignKeyDefinition foreignKey = this.getForeignKey(column);
            if (foreignKey == null) continue;
            result.add(foreignKey);
        }
        return new ArrayList<ForeignKeyDefinition>(result);
    }

    private static Key key(Definition definition, String keyName) {
        return new Key(definition.getSchema(), keyName);
    }

    private static class Key {
        final SchemaDefinition schema;
        final String keyName;

        Key(SchemaDefinition schema, String keyName) {
            this.schema = schema;
            this.keyName = keyName;
        }

        public String toString() {
            return "Key [schema=" + this.schema + ", keyName=" + this.keyName + "]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.keyName == null ? 0 : this.keyName.hashCode());
            result = 31 * result + (this.schema == null ? 0 : this.schema.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Key other = (Key)obj;
            if (this.keyName == null ? other.keyName != null : !this.keyName.equals(other.keyName)) {
                return false;
            }
            return !(this.schema == null ? other.schema != null : !this.schema.equals(other.schema));
        }
    }
}

