/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.util.db2;

import java.sql.SQLException;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.SortField;
import org.jooq.TableLike;
import org.jooq.util.AbstractRoutineDefinition;
import org.jooq.util.DefaultDataTypeDefinition;
import org.jooq.util.DefaultParameterDefinition;
import org.jooq.util.InOutDefinition;
import org.jooq.util.SchemaDefinition;
import org.jooq.util.db2.syscat.tables.Funcparms;
import org.jooq.util.db2.syscat.tables.Functions;
import org.jooq.util.db2.syscat.tables.Procparms;

public class DB2RoutineDefinition
extends AbstractRoutineDefinition {
    private final boolean isProcedure;

    public DB2RoutineDefinition(SchemaDefinition schema, String name, String comment, boolean isProcedure) {
        super(schema, null, name, comment, null);
        this.isProcedure = isProcedure;
    }

    @Override
    protected void init0() throws SQLException {
        if (this.isProcedure) {
            this.initP();
        } else {
            this.initF();
        }
    }

    private void initF() {
        for (Record record : this.create().select(new Field[]{Funcparms.ROWTYPE, Funcparms.TYPENAME, Funcparms.LENGTH, Funcparms.SCALE, Funcparms.ORDINAL, Funcparms.PARMNAME}).from(new TableLike[]{Funcparms.FUNCPARMS}).join((TableLike)Functions.FUNCTIONS).on(new Condition[]{Funcparms.FUNCSCHEMA.equal(Functions.FUNCSCHEMA), Funcparms.FUNCNAME.equal(Functions.FUNCNAME)}).where(new Condition[]{Funcparms.FUNCSCHEMA.equal((Object)this.getSchema().getName()), Funcparms.FUNCNAME.equal((Object)this.getName()), Functions.ORIGIN.equal((Object)"Q")}).orderBy(new SortField[]{Funcparms.FUNCNAME.asc(), Funcparms.ORDINAL.asc()}).fetch()) {
            DefaultDataTypeDefinition type;
            String rowType = (String)record.getValue(Funcparms.ROWTYPE);
            String dataType = (String)record.getValue(Funcparms.TYPENAME);
            Integer precision = (Integer)record.getValue(Funcparms.LENGTH);
            Short scale = (Short)record.getValue(Funcparms.SCALE);
            short position = (Short)record.getValue(Funcparms.ORDINAL);
            String paramName = (String)record.getValue(Funcparms.PARMNAME);
            if ("C".equals(rowType)) {
                type = new DefaultDataTypeDefinition(this.getDatabase(), this.getSchema(), dataType, precision, precision, scale);
                this.addParameter(InOutDefinition.RETURN, new DefaultParameterDefinition(this, "RETURN_VALUE", -1, type));
                continue;
            }
            if (!"P".equals(rowType)) continue;
            type = new DefaultDataTypeDefinition(this.getDatabase(), this.getSchema(), dataType, precision, precision, scale);
            DefaultParameterDefinition column = new DefaultParameterDefinition(this, paramName, position, type);
            this.addParameter(InOutDefinition.IN, column);
        }
    }

    private void initP() {
        for (Record record : this.create().select(new Field[]{Procparms.PARMNAME, Procparms.TYPENAME, Procparms.LENGTH, Procparms.SCALE, Procparms.ORDINAL, Procparms.PARM_MODE}).from(new TableLike[]{Procparms.PROCPARMS}).where(new Condition[]{Procparms.PROCSCHEMA.equal((Object)this.getSchema().getName())}).and(Procparms.PROCNAME.equal((Object)this.getName())).orderBy(new Field[]{Procparms.ORDINAL}).fetch()) {
            String paramMode = (String)record.getValue(Procparms.PARM_MODE);
            DefaultDataTypeDefinition type = new DefaultDataTypeDefinition(this.getDatabase(), this.getSchema(), (String)record.getValue(Procparms.TYPENAME), (Number)record.getValue(Procparms.LENGTH), (Number)record.getValue(Procparms.LENGTH), (Number)record.getValue(Procparms.SCALE));
            this.addParameter(InOutDefinition.getFromString(paramMode), new DefaultParameterDefinition(this, (String)record.getValue(Procparms.PARMNAME), ((Short)record.getValue(Procparms.ORDINAL)).shortValue(), type));
        }
    }
}

