/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.util.h2;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.SortField;
import org.jooq.TableLike;
import org.jooq.impl.Factory;
import org.jooq.util.AbstractDatabase;
import org.jooq.util.ArrayDefinition;
import org.jooq.util.ColumnDefinition;
import org.jooq.util.DefaultDataTypeDefinition;
import org.jooq.util.DefaultRelations;
import org.jooq.util.DefaultSequenceDefinition;
import org.jooq.util.EnumDefinition;
import org.jooq.util.PackageDefinition;
import org.jooq.util.RoutineDefinition;
import org.jooq.util.SchemaDefinition;
import org.jooq.util.SequenceDefinition;
import org.jooq.util.TableDefinition;
import org.jooq.util.UDTDefinition;
import org.jooq.util.h2.H2DataType;
import org.jooq.util.h2.H2RoutineDefinition;
import org.jooq.util.h2.H2TableDefinition;
import org.jooq.util.h2.information_schema.InformationSchemaFactory;
import org.jooq.util.h2.information_schema.tables.Constraints;
import org.jooq.util.h2.information_schema.tables.CrossReferences;
import org.jooq.util.h2.information_schema.tables.FunctionAliases;
import org.jooq.util.h2.information_schema.tables.Sequences;
import org.jooq.util.h2.information_schema.tables.Tables;
import org.jooq.util.h2.information_schema.tables.TypeInfo;

public class H2Database
extends AbstractDatabase {
    @Override
    public Factory create() {
        return new InformationSchemaFactory(this.getConnection());
    }

    @Override
    protected void loadPrimaryKeys(DefaultRelations relations) throws SQLException {
        for (Record record : this.fetchKeys("PRIMARY KEY")) {
            String[] columnNames;
            SchemaDefinition schema = this.getSchema((String)record.getValue(Constraints.TABLE_SCHEMA));
            String tableName = (String)record.getValue(Constraints.TABLE_NAME);
            String columnList = (String)record.getValue(Constraints.COLUMN_LIST);
            String primaryKey = (String)record.getValue(Constraints.CONSTRAINT_NAME);
            TableDefinition table = this.getTable(schema, tableName);
            if (table == null) continue;
            for (String columnName : columnNames = columnList.split("[,]+")) {
                relations.addPrimaryKey(primaryKey, table.getColumn(columnName));
            }
        }
    }

    @Override
    protected void loadUniqueKeys(DefaultRelations relations) throws SQLException {
        for (Record record : this.fetchKeys("UNIQUE")) {
            String[] columnNames;
            SchemaDefinition schema = this.getSchema((String)record.getValue(Constraints.TABLE_SCHEMA));
            String tableName = (String)record.getValue(Constraints.TABLE_NAME);
            String columnList = (String)record.getValue(Constraints.COLUMN_LIST);
            String primaryKey = (String)record.getValue(Constraints.CONSTRAINT_NAME);
            TableDefinition table = this.getTable(schema, tableName);
            if (table == null) continue;
            for (String columnName : columnNames = columnList.split("[,]+")) {
                relations.addUniqueKey(primaryKey, table.getColumn(columnName));
            }
        }
    }

    private List<Record> fetchKeys(String constraintType) {
        return this.create().select(new Field[]{Constraints.TABLE_SCHEMA, Constraints.TABLE_NAME, Constraints.COLUMN_LIST, Constraints.CONSTRAINT_NAME}).from(new TableLike[]{Constraints.CONSTRAINTS}).where(new Condition[]{Constraints.TABLE_SCHEMA.in(this.getInputSchemata())}).and(Constraints.CONSTRAINT_TYPE.equal((Object)constraintType)).orderBy(new Field[]{Constraints.TABLE_SCHEMA, Constraints.CONSTRAINT_NAME, Constraints.COLUMN_LIST}).fetch();
    }

    @Override
    protected void loadForeignKeys(DefaultRelations relations) throws SQLException {
        for (Record record : this.create().select(new Field[]{CrossReferences.FK_NAME, CrossReferences.FKTABLE_NAME, CrossReferences.FKTABLE_SCHEMA, CrossReferences.FKCOLUMN_NAME, Constraints.CONSTRAINT_NAME, Constraints.CONSTRAINT_SCHEMA}).from(new TableLike[]{CrossReferences.CROSS_REFERENCES}).join((TableLike)Constraints.CONSTRAINTS).on(new Condition[]{CrossReferences.PK_NAME.equal(Constraints.UNIQUE_INDEX_NAME)}).and(CrossReferences.PKTABLE_NAME.equal(Constraints.TABLE_NAME)).and(CrossReferences.PKTABLE_SCHEMA.equal(Constraints.TABLE_SCHEMA)).where(new Condition[]{CrossReferences.FKTABLE_SCHEMA.in(this.getInputSchemata())}).orderBy(new SortField[]{CrossReferences.FKTABLE_SCHEMA.asc(), CrossReferences.FK_NAME.asc(), CrossReferences.ORDINAL_POSITION.asc()}).fetch()) {
            SchemaDefinition foreignKeySchema = this.getSchema((String)record.getValue(CrossReferences.FKTABLE_SCHEMA));
            SchemaDefinition uniqueKeySchema = this.getSchema((String)record.getValue(Constraints.CONSTRAINT_SCHEMA));
            String foreignKeyTableName = (String)record.getValue(CrossReferences.FKTABLE_NAME);
            String foreignKeyColumn = (String)record.getValue(CrossReferences.FKCOLUMN_NAME);
            String foreignKey = (String)record.getValue(CrossReferences.FK_NAME);
            String uniqueKey = (String)record.getValue(Constraints.CONSTRAINT_NAME);
            TableDefinition foreignKeyTable = this.getTable(foreignKeySchema, foreignKeyTableName);
            if (foreignKeyTable == null) continue;
            ColumnDefinition referencingColumn = foreignKeyTable.getColumn(foreignKeyColumn);
            relations.addForeignKey(foreignKey, uniqueKey, referencingColumn, uniqueKeySchema);
        }
    }

    @Override
    protected List<SequenceDefinition> getSequences0() throws SQLException {
        ArrayList<SequenceDefinition> result = new ArrayList<SequenceDefinition>();
        for (Record record : this.create().select(new Field[]{Sequences.SEQUENCE_SCHEMA, Sequences.SEQUENCE_NAME}).from(new TableLike[]{Sequences.SEQUENCES}).where(new Condition[]{Sequences.SEQUENCE_SCHEMA.in(this.getInputSchemata())}).orderBy(new Field[]{Sequences.SEQUENCE_SCHEMA, Sequences.SEQUENCE_NAME}).fetch()) {
            SchemaDefinition schema = this.getSchema((String)record.getValue(Sequences.SEQUENCE_SCHEMA));
            String name = (String)record.getValue(Sequences.SEQUENCE_NAME);
            DefaultDataTypeDefinition type = new DefaultDataTypeDefinition(this, schema, H2DataType.BIGINT.getTypeName(), 0, 0, 0);
            result.add(new DefaultSequenceDefinition(schema, name, type));
        }
        return result;
    }

    @Override
    protected List<TableDefinition> getTables0() throws SQLException {
        ArrayList<TableDefinition> result = new ArrayList<TableDefinition>();
        for (Record record : this.create().select(new Field[]{Tables.TABLE_SCHEMA, Tables.TABLE_NAME, Tables.REMARKS}).from(new TableLike[]{Tables.TABLES}).where(new Condition[]{Tables.TABLE_SCHEMA.in(this.getInputSchemata())}).orderBy(new Field[]{Tables.TABLE_SCHEMA, Tables.ID}).fetch()) {
            SchemaDefinition schema = this.getSchema((String)record.getValue(Tables.TABLE_SCHEMA));
            String name = (String)record.getValue(Tables.TABLE_NAME);
            String comment = (String)record.getValue(Tables.REMARKS);
            H2TableDefinition table = new H2TableDefinition(schema, name, comment);
            result.add(table);
        }
        return result;
    }

    @Override
    protected List<RoutineDefinition> getRoutines0() throws SQLException {
        ArrayList<RoutineDefinition> result = new ArrayList<RoutineDefinition>();
        for (Record record : this.create().select(new Field[]{FunctionAliases.ALIAS_SCHEMA, FunctionAliases.ALIAS_NAME, FunctionAliases.REMARKS, FunctionAliases.DATA_TYPE, FunctionAliases.RETURNS_RESULT, TypeInfo.TYPE_NAME, TypeInfo.PRECISION, TypeInfo.MAXIMUM_SCALE}).from(new TableLike[]{FunctionAliases.FUNCTION_ALIASES}).leftOuterJoin((TableLike)TypeInfo.TYPE_INFO).on(new Condition[]{FunctionAliases.DATA_TYPE.equal(TypeInfo.DATA_TYPE)}).and(TypeInfo.POS.equal((Object)0)).where(new Condition[]{FunctionAliases.ALIAS_SCHEMA.in(this.getInputSchemata())}).and(FunctionAliases.RETURNS_RESULT.in((Object[])new Short[]{(short)1, (short)2})).orderBy(new Field[]{FunctionAliases.ALIAS_NAME}).fetch()) {
            SchemaDefinition schema = this.getSchema((String)record.getValue(FunctionAliases.ALIAS_SCHEMA));
            String name = (String)record.getValue(FunctionAliases.ALIAS_NAME);
            String comment = (String)record.getValue(FunctionAliases.REMARKS);
            String typeName = (String)record.getValue(TypeInfo.TYPE_NAME);
            Integer precision = (Integer)record.getValue(TypeInfo.PRECISION);
            Short scale = (Short)record.getValue(TypeInfo.MAXIMUM_SCALE);
            result.add(new H2RoutineDefinition(schema, name, comment, typeName, precision, scale));
        }
        return result;
    }

    @Override
    protected List<PackageDefinition> getPackages0() throws SQLException {
        ArrayList<PackageDefinition> result = new ArrayList<PackageDefinition>();
        return result;
    }

    @Override
    protected List<EnumDefinition> getEnums0() throws SQLException {
        ArrayList<EnumDefinition> result = new ArrayList<EnumDefinition>();
        return result;
    }

    @Override
    protected List<UDTDefinition> getUDTs0() throws SQLException {
        ArrayList<UDTDefinition> result = new ArrayList<UDTDefinition>();
        return result;
    }

    @Override
    protected List<ArrayDefinition> getArrays0() throws SQLException {
        ArrayList<ArrayDefinition> result = new ArrayList<ArrayDefinition>();
        return result;
    }
}

