/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.util.ingres;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.Result;
import org.jooq.SortField;
import org.jooq.TableLike;
import org.jooq.impl.Factory;
import org.jooq.util.AbstractDatabase;
import org.jooq.util.ArrayDefinition;
import org.jooq.util.ColumnDefinition;
import org.jooq.util.DefaultDataTypeDefinition;
import org.jooq.util.DefaultRelations;
import org.jooq.util.DefaultSequenceDefinition;
import org.jooq.util.EnumDefinition;
import org.jooq.util.PackageDefinition;
import org.jooq.util.RoutineDefinition;
import org.jooq.util.SchemaDefinition;
import org.jooq.util.SequenceDefinition;
import org.jooq.util.TableDefinition;
import org.jooq.util.UDTDefinition;
import org.jooq.util.ingres.IngresTableDefinition;
import org.jooq.util.ingres.ingres.$ingresFactory;
import org.jooq.util.ingres.ingres.tables.IiconstraintIndexes;
import org.jooq.util.ingres.ingres.tables.Iiconstraints;
import org.jooq.util.ingres.ingres.tables.IidbComments;
import org.jooq.util.ingres.ingres.tables.IiindexColumns;
import org.jooq.util.ingres.ingres.tables.Iiindexes;
import org.jooq.util.ingres.ingres.tables.IirefConstraints;
import org.jooq.util.ingres.ingres.tables.Iisequences;
import org.jooq.util.ingres.ingres.tables.Iitables;

public class IngresDatabase
extends AbstractDatabase {
    @Override
    public Factory create() {
        return new $ingresFactory(this.getConnection());
    }

    @Override
    protected void loadPrimaryKeys(DefaultRelations relations) throws SQLException {
        for (Record record : this.fetchKeys("P")) {
            SchemaDefinition schema = this.getSchema((String)record.getValue(Factory.trim(Iiconstraints.SCHEMA_NAME)));
            String key = (String)record.getValue(Factory.trim(Iiconstraints.CONSTRAINT_NAME));
            String tableName = (String)record.getValue(Factory.trim(Iiconstraints.TABLE_NAME));
            String columnName = (String)record.getValue(Factory.trim(IiindexColumns.COLUMN_NAME));
            TableDefinition table = this.getTable(schema, tableName);
            if (table == null) continue;
            relations.addPrimaryKey(key, table.getColumn(columnName));
        }
    }

    @Override
    protected void loadUniqueKeys(DefaultRelations relations) throws SQLException {
        for (Record record : this.fetchKeys("U")) {
            SchemaDefinition schema = this.getSchema((String)record.getValue(Factory.trim(Iiconstraints.SCHEMA_NAME)));
            String key = (String)record.getValue(Factory.trim(Iiconstraints.CONSTRAINT_NAME));
            String tableName = (String)record.getValue(Factory.trim(Iiconstraints.TABLE_NAME));
            String columnName = (String)record.getValue(Factory.trim(IiindexColumns.COLUMN_NAME));
            TableDefinition table = this.getTable(schema, tableName);
            if (table == null) continue;
            relations.addPrimaryKey(key, table.getColumn(columnName));
        }
    }

    private List<Record> fetchKeys(String constraintType) {
        return this.create().select(new Field[]{Factory.trim(Iiconstraints.SCHEMA_NAME), Factory.trim(Iiconstraints.TABLE_NAME), Factory.trim(Iiconstraints.CONSTRAINT_NAME), Factory.trim(IiindexColumns.COLUMN_NAME)}).from(new TableLike[]{Iiconstraints.IICONSTRAINTS}).join((TableLike)IiconstraintIndexes.IICONSTRAINT_INDEXES).on(new Condition[]{Iiconstraints.CONSTRAINT_NAME.equal(IiconstraintIndexes.CONSTRAINT_NAME)}).and(Iiconstraints.SCHEMA_NAME.equal(IiconstraintIndexes.SCHEMA_NAME)).join((TableLike)Iiindexes.IIINDEXES).on(new Condition[]{IiconstraintIndexes.INDEX_NAME.equal(Iiindexes.INDEX_NAME)}).and(IiconstraintIndexes.SCHEMA_NAME.equal(Iiindexes.INDEX_OWNER)).join((TableLike)IiindexColumns.IIINDEX_COLUMNS).on(new Condition[]{Iiindexes.INDEX_NAME.equal(IiindexColumns.INDEX_NAME)}).and(Iiindexes.INDEX_OWNER.equal(IiindexColumns.INDEX_OWNER)).where(new Condition[]{Iiconstraints.SCHEMA_NAME.in(this.getInputSchemata())}).and(Iiconstraints.CONSTRAINT_TYPE.equal((Object)constraintType)).orderBy(new SortField[]{Iiconstraints.SCHEMA_NAME.asc(), Iiconstraints.TABLE_NAME.asc(), IiindexColumns.INDEX_NAME.asc(), IiindexColumns.KEY_SEQUENCE.asc()}).fetch();
    }

    @Override
    protected void loadForeignKeys(DefaultRelations relations) throws SQLException {
        Result result = this.create().select(new Field[]{Factory.trim(IirefConstraints.REF_SCHEMA_NAME), Factory.trim(IirefConstraints.REF_CONSTRAINT_NAME), Factory.trim(IirefConstraints.UNIQUE_CONSTRAINT_NAME), Factory.trim(IirefConstraints.UNIQUE_SCHEMA_NAME), Factory.trim(IirefConstraints.REF_TABLE_NAME), Factory.trim(IiindexColumns.COLUMN_NAME)}).from(new TableLike[]{Iiconstraints.IICONSTRAINTS}).join((TableLike)IirefConstraints.IIREF_CONSTRAINTS).on(new Condition[]{Iiconstraints.CONSTRAINT_NAME.equal(IirefConstraints.REF_CONSTRAINT_NAME)}).and(Iiconstraints.SCHEMA_NAME.equal(IirefConstraints.REF_SCHEMA_NAME)).join((TableLike)IiconstraintIndexes.IICONSTRAINT_INDEXES).on(new Condition[]{Iiconstraints.CONSTRAINT_NAME.equal(IiconstraintIndexes.CONSTRAINT_NAME)}).and(Iiconstraints.SCHEMA_NAME.equal(IiconstraintIndexes.SCHEMA_NAME)).join((TableLike)Iiindexes.IIINDEXES).on(new Condition[]{IiconstraintIndexes.INDEX_NAME.equal(Iiindexes.INDEX_NAME)}).and(IiconstraintIndexes.SCHEMA_NAME.equal(Iiindexes.INDEX_OWNER)).join((TableLike)IiindexColumns.IIINDEX_COLUMNS).on(new Condition[]{Iiindexes.INDEX_NAME.equal(IiindexColumns.INDEX_NAME)}).and(Iiindexes.INDEX_OWNER.equal(IiindexColumns.INDEX_OWNER)).where(new Condition[]{IirefConstraints.REF_SCHEMA_NAME.in(this.getInputSchemata())}).and(Iiconstraints.CONSTRAINT_TYPE.equal((Object)"R")).orderBy(new SortField[]{IirefConstraints.REF_SCHEMA_NAME.asc(), IirefConstraints.REF_TABLE_NAME.asc(), IirefConstraints.REF_CONSTRAINT_NAME.asc(), IiindexColumns.KEY_SEQUENCE.asc()}).fetch();
        for (Record record : result) {
            SchemaDefinition foreignKeySchema = this.getSchema((String)record.getValue(Factory.trim(IirefConstraints.REF_SCHEMA_NAME)));
            SchemaDefinition uniqueKeySchema = this.getSchema((String)record.getValue(Factory.trim(IirefConstraints.UNIQUE_SCHEMA_NAME)));
            String foreignKey = (String)record.getValue(Factory.trim(IirefConstraints.REF_CONSTRAINT_NAME));
            String foreignKeyTable = (String)record.getValue(Factory.trim(IirefConstraints.REF_TABLE_NAME));
            String foreignKeyColumn = (String)record.getValue(Factory.trim(IiindexColumns.COLUMN_NAME));
            String uniqueKey = (String)record.getValue(Factory.trim(IirefConstraints.UNIQUE_CONSTRAINT_NAME));
            TableDefinition referencingTable = this.getTable(foreignKeySchema, foreignKeyTable);
            if (referencingTable == null) continue;
            ColumnDefinition referencingColumn = referencingTable.getColumn(foreignKeyColumn);
            relations.addForeignKey(foreignKey, uniqueKey, referencingColumn, uniqueKeySchema);
        }
    }

    @Override
    protected List<SequenceDefinition> getSequences0() throws SQLException {
        ArrayList<SequenceDefinition> result = new ArrayList<SequenceDefinition>();
        for (Record record : this.create().select(new Field[]{Factory.trim(Iisequences.SEQ_OWNER), Factory.trim(Iisequences.SEQ_NAME), Factory.trim(Iisequences.DATA_TYPE)}).from(new TableLike[]{Iisequences.IISEQUENCES}).where(new Condition[]{Iisequences.SEQ_OWNER.in(this.getInputSchemata())}).orderBy(new Field[]{Iisequences.SEQ_OWNER, Iisequences.SEQ_NAME}).fetch()) {
            SchemaDefinition schema = this.getSchema((String)record.getValue(Factory.trim(Iisequences.SEQ_OWNER)));
            DefaultDataTypeDefinition type = new DefaultDataTypeDefinition(this, schema, (String)record.getValue(Factory.trim(Iisequences.DATA_TYPE)), 0, 0, 0);
            result.add(new DefaultSequenceDefinition(schema, (String)record.getValue(Factory.trim(Iisequences.SEQ_NAME)), type));
        }
        return result;
    }

    @Override
    protected List<TableDefinition> getTables0() throws SQLException {
        ArrayList<TableDefinition> result = new ArrayList<TableDefinition>();
        for (Record record : this.create().select(new Field[]{Factory.trim(Iitables.TABLE_OWNER), Factory.trim(Iitables.TABLE_NAME), Factory.trim(IidbComments.LONG_REMARK)}).from(new TableLike[]{Iitables.IITABLES}).leftOuterJoin((TableLike)IidbComments.IIDB_COMMENTS).on(new Condition[]{Iitables.TABLE_NAME.equal(IidbComments.OBJECT_NAME)}).and(Iitables.TABLE_OWNER.equal(IidbComments.OBJECT_OWNER)).and(IidbComments.OBJECT_TYPE.equal((Object)"T")).and(IidbComments.TEXT_SEQUENCE.equal((Object)1L)).where(new Condition[]{Iitables.TABLE_OWNER.in(this.getInputSchemata())}).orderBy(new Field[]{Factory.trim(Iitables.TABLE_OWNER), Factory.trim(Iitables.TABLE_NAME)}).fetch()) {
            result.add(new IngresTableDefinition(this.getSchema((String)record.getValue(Factory.trim(Iitables.TABLE_OWNER))), (String)record.getValue(Factory.trim(Iitables.TABLE_NAME)), (String)record.getValue(Factory.trim(IidbComments.LONG_REMARK))));
        }
        return result;
    }

    @Override
    protected List<RoutineDefinition> getRoutines0() throws SQLException {
        ArrayList<RoutineDefinition> result = new ArrayList<RoutineDefinition>();
        return result;
    }

    @Override
    protected List<PackageDefinition> getPackages0() throws SQLException {
        ArrayList<PackageDefinition> result = new ArrayList<PackageDefinition>();
        return result;
    }

    @Override
    protected List<EnumDefinition> getEnums0() throws SQLException {
        ArrayList<EnumDefinition> result = new ArrayList<EnumDefinition>();
        return result;
    }

    @Override
    protected List<UDTDefinition> getUDTs0() throws SQLException {
        ArrayList<UDTDefinition> result = new ArrayList<UDTDefinition>();
        return result;
    }

    @Override
    protected List<ArrayDefinition> getArrays0() throws SQLException {
        ArrayList<ArrayDefinition> result = new ArrayList<ArrayDefinition>();
        return result;
    }
}

