/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.util.postgres;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.Result;
import org.jooq.Select;
import org.jooq.SortField;
import org.jooq.TableLike;
import org.jooq.impl.Factory;
import org.jooq.util.AbstractDatabase;
import org.jooq.util.AbstractDefinition;
import org.jooq.util.ArrayDefinition;
import org.jooq.util.ColumnDefinition;
import org.jooq.util.DefaultDataTypeDefinition;
import org.jooq.util.DefaultEnumDefinition;
import org.jooq.util.DefaultRelations;
import org.jooq.util.DefaultSequenceDefinition;
import org.jooq.util.EnumDefinition;
import org.jooq.util.PackageDefinition;
import org.jooq.util.RoutineDefinition;
import org.jooq.util.SchemaDefinition;
import org.jooq.util.SequenceDefinition;
import org.jooq.util.TableDefinition;
import org.jooq.util.UDTDefinition;
import org.jooq.util.postgres.PostgresRoutineDefinition;
import org.jooq.util.postgres.PostgresTableDefinition;
import org.jooq.util.postgres.PostgresUDTDefinition;
import org.jooq.util.postgres.information_schema.InformationSchemaFactory;
import org.jooq.util.postgres.information_schema.Tables;
import org.jooq.util.postgres.information_schema.tables.Routines;

public class PostgresDatabase
extends AbstractDatabase {
    @Override
    protected void loadPrimaryKeys(DefaultRelations relations) throws SQLException {
        for (Record record : this.fetchKeys("PRIMARY KEY")) {
            SchemaDefinition schema = this.getSchema((String)record.getValue(Tables.KEY_COLUMN_USAGE.TABLE_SCHEMA));
            String key = (String)record.getValue(Tables.KEY_COLUMN_USAGE.CONSTRAINT_NAME);
            String tableName = (String)record.getValue(Tables.KEY_COLUMN_USAGE.TABLE_NAME);
            String columnName = (String)record.getValue(Tables.KEY_COLUMN_USAGE.COLUMN_NAME);
            TableDefinition table = this.getTable(schema, tableName);
            if (table == null) continue;
            relations.addPrimaryKey(key, table.getColumn(columnName));
        }
    }

    @Override
    protected void loadUniqueKeys(DefaultRelations relations) throws SQLException {
        for (Record record : this.fetchKeys("UNIQUE")) {
            SchemaDefinition schema = this.getSchema((String)record.getValue(Tables.KEY_COLUMN_USAGE.TABLE_SCHEMA));
            String key = (String)record.getValue(Tables.KEY_COLUMN_USAGE.CONSTRAINT_NAME);
            String tableName = (String)record.getValue(Tables.KEY_COLUMN_USAGE.TABLE_NAME);
            String columnName = (String)record.getValue(Tables.KEY_COLUMN_USAGE.COLUMN_NAME);
            TableDefinition table = this.getTable(schema, tableName);
            if (table == null) continue;
            relations.addUniqueKey(key, table.getColumn(columnName));
        }
    }

    private List<Record> fetchKeys(String constraintType) {
        return this.create().select(new Field[]{Tables.KEY_COLUMN_USAGE.CONSTRAINT_NAME, Tables.KEY_COLUMN_USAGE.TABLE_SCHEMA, Tables.KEY_COLUMN_USAGE.TABLE_NAME, Tables.KEY_COLUMN_USAGE.COLUMN_NAME}).from(new TableLike[]{Tables.TABLE_CONSTRAINTS}).join((TableLike)Tables.KEY_COLUMN_USAGE).on(new Condition[]{Tables.TABLE_CONSTRAINTS.CONSTRAINT_SCHEMA.equal(Tables.KEY_COLUMN_USAGE.CONSTRAINT_SCHEMA)}).and(Tables.TABLE_CONSTRAINTS.CONSTRAINT_NAME.equal(Tables.KEY_COLUMN_USAGE.CONSTRAINT_NAME)).where(new Condition[]{Tables.TABLE_CONSTRAINTS.CONSTRAINT_TYPE.equal((Object)constraintType)}).and(Tables.TABLE_CONSTRAINTS.TABLE_SCHEMA.in(this.getInputSchemata())).orderBy(new SortField[]{Tables.KEY_COLUMN_USAGE.TABLE_SCHEMA.asc(), Tables.KEY_COLUMN_USAGE.TABLE_NAME.asc(), Tables.KEY_COLUMN_USAGE.CONSTRAINT_NAME.asc(), Tables.KEY_COLUMN_USAGE.ORDINAL_POSITION.asc()}).fetch();
    }

    @Override
    protected void loadForeignKeys(DefaultRelations relations) throws SQLException {
        Result result = this.create().select(new Field[]{Tables.REFERENTIAL_CONSTRAINTS.UNIQUE_CONSTRAINT_NAME, Tables.REFERENTIAL_CONSTRAINTS.UNIQUE_CONSTRAINT_SCHEMA, Tables.KEY_COLUMN_USAGE.CONSTRAINT_NAME, Tables.KEY_COLUMN_USAGE.TABLE_SCHEMA, Tables.KEY_COLUMN_USAGE.TABLE_NAME, Tables.KEY_COLUMN_USAGE.COLUMN_NAME}).from(new TableLike[]{Tables.REFERENTIAL_CONSTRAINTS}).join((TableLike)Tables.KEY_COLUMN_USAGE).on(new Condition[]{Tables.KEY_COLUMN_USAGE.CONSTRAINT_SCHEMA.equal(Tables.REFERENTIAL_CONSTRAINTS.CONSTRAINT_SCHEMA)}).and(Tables.KEY_COLUMN_USAGE.CONSTRAINT_NAME.equal(Tables.REFERENTIAL_CONSTRAINTS.CONSTRAINT_NAME)).where(new Condition[]{Tables.KEY_COLUMN_USAGE.TABLE_SCHEMA.in(this.getInputSchemata())}).orderBy(new SortField[]{Tables.KEY_COLUMN_USAGE.TABLE_SCHEMA.asc(), Tables.KEY_COLUMN_USAGE.TABLE_NAME.asc(), Tables.KEY_COLUMN_USAGE.CONSTRAINT_NAME.asc(), Tables.KEY_COLUMN_USAGE.ORDINAL_POSITION.asc()}).fetch();
        for (Record record : result) {
            SchemaDefinition foreignKeySchema = this.getSchema((String)record.getValue(Tables.KEY_COLUMN_USAGE.TABLE_SCHEMA));
            SchemaDefinition uniqueKeySchema = this.getSchema((String)record.getValue(Tables.REFERENTIAL_CONSTRAINTS.UNIQUE_CONSTRAINT_SCHEMA));
            String foreignKey = (String)record.getValue(Tables.KEY_COLUMN_USAGE.CONSTRAINT_NAME);
            String foreignKeyTable = (String)record.getValue(Tables.KEY_COLUMN_USAGE.TABLE_NAME);
            String foreignKeyColumn = (String)record.getValue(Tables.KEY_COLUMN_USAGE.COLUMN_NAME);
            String uniqueKey = (String)record.getValue(Tables.REFERENTIAL_CONSTRAINTS.UNIQUE_CONSTRAINT_NAME);
            TableDefinition referencingTable = this.getTable(foreignKeySchema, foreignKeyTable);
            if (referencingTable == null) continue;
            ColumnDefinition referencingColumn = referencingTable.getColumn(foreignKeyColumn);
            relations.addForeignKey(foreignKeyTable + "__" + foreignKey, uniqueKey, referencingColumn, uniqueKeySchema);
        }
    }

    @Override
    protected List<TableDefinition> getTables0() throws SQLException {
        ArrayList<TableDefinition> result = new ArrayList<TableDefinition>();
        for (Record record : this.create().select(new Field[]{Tables.TABLES.TABLE_SCHEMA, Tables.TABLES.TABLE_NAME}).from(new TableLike[]{Tables.TABLES}).where(new Condition[]{Tables.TABLES.TABLE_SCHEMA.in(this.getInputSchemata())}).orderBy(new Field[]{Tables.TABLES.TABLE_SCHEMA, Tables.TABLES.TABLE_NAME}).fetch()) {
            SchemaDefinition schema = this.getSchema((String)record.getValue(Tables.TABLES.TABLE_SCHEMA));
            String name = (String)record.getValue(Tables.TABLES.TABLE_NAME);
            String comment = "";
            result.add(new PostgresTableDefinition(schema, name, comment));
        }
        return result;
    }

    @Override
    protected List<SequenceDefinition> getSequences0() throws SQLException {
        ArrayList<SequenceDefinition> result = new ArrayList<SequenceDefinition>();
        for (Record record : this.create().select(new Field[]{Tables.SEQUENCES.SEQUENCE_SCHEMA, Tables.SEQUENCES.SEQUENCE_NAME, Tables.SEQUENCES.DATA_TYPE, Tables.SEQUENCES.NUMERIC_PRECISION, Tables.SEQUENCES.NUMERIC_SCALE}).from(new TableLike[]{Tables.SEQUENCES}).where(new Condition[]{Tables.SEQUENCES.SEQUENCE_SCHEMA.in(this.getInputSchemata())}).orderBy(new Field[]{Tables.SEQUENCES.SEQUENCE_SCHEMA, Tables.SEQUENCES.SEQUENCE_NAME}).fetch()) {
            SchemaDefinition schema = this.getSchema((String)record.getValue(Tables.SEQUENCES.SEQUENCE_SCHEMA));
            DefaultDataTypeDefinition type = new DefaultDataTypeDefinition(this, schema, (String)record.getValue(Tables.SEQUENCES.DATA_TYPE), 0, (Number)record.getValue(Tables.SEQUENCES.NUMERIC_PRECISION), (Number)record.getValue(Tables.SEQUENCES.NUMERIC_SCALE));
            result.add(new DefaultSequenceDefinition(schema, (String)record.getValue(Tables.SEQUENCES.SEQUENCE_NAME), type));
        }
        return result;
    }

    @Override
    protected List<EnumDefinition> getEnums0() throws SQLException {
        ArrayList<EnumDefinition> result = new ArrayList<EnumDefinition>();
        Result records = this.create().select(new Field[]{org.jooq.util.postgres.pg_catalog.Tables.PG_NAMESPACE.NSPNAME, org.jooq.util.postgres.pg_catalog.Tables.PG_TYPE.TYPNAME, org.jooq.util.postgres.pg_catalog.Tables.PG_ENUM.ENUMLABEL}).from(new TableLike[]{org.jooq.util.postgres.pg_catalog.Tables.PG_ENUM}).join((TableLike)org.jooq.util.postgres.pg_catalog.Tables.PG_TYPE).on("pg_enum.enumtypid = pg_type.oid").join((TableLike)org.jooq.util.postgres.pg_catalog.Tables.PG_NAMESPACE).on("pg_type.typnamespace = pg_namespace.oid").where(new Condition[]{org.jooq.util.postgres.pg_catalog.Tables.PG_NAMESPACE.NSPNAME.in(this.getInputSchemata())}).orderBy(new Field[]{org.jooq.util.postgres.pg_catalog.Tables.PG_NAMESPACE.NSPNAME, org.jooq.util.postgres.pg_catalog.Tables.PG_TYPE.TYPNAME, org.jooq.util.postgres.pg_catalog.Tables.PG_ENUM.ENUMLABEL}).fetch();
        AbstractDefinition definition = null;
        for (Record record : records) {
            SchemaDefinition schema = this.getSchema((String)record.getValue(org.jooq.util.postgres.pg_catalog.Tables.PG_NAMESPACE.NSPNAME));
            String typeName = String.valueOf(record.getValue(org.jooq.util.postgres.pg_catalog.Tables.PG_TYPE.TYPNAME));
            if (definition == null || !definition.getName().equals(typeName)) {
                definition = new DefaultEnumDefinition(schema, typeName, null);
                result.add((EnumDefinition)((Object)definition));
            }
            ((DefaultEnumDefinition)definition).addLiteral(String.valueOf(record.getValue(org.jooq.util.postgres.pg_catalog.Tables.PG_ENUM.ENUMLABEL)));
        }
        return result;
    }

    @Override
    protected List<UDTDefinition> getUDTs0() throws SQLException {
        ArrayList<UDTDefinition> result = new ArrayList<UDTDefinition>();
        for (Record record : this.create().selectDistinct(new Field[]{Tables.ATTRIBUTES.UDT_SCHEMA, Tables.ATTRIBUTES.UDT_NAME}).from(new TableLike[]{Tables.ATTRIBUTES}).where(new Condition[]{Tables.ATTRIBUTES.UDT_SCHEMA.in(this.getInputSchemata())}).orderBy(new Field[]{Tables.ATTRIBUTES.UDT_SCHEMA, Tables.ATTRIBUTES.UDT_NAME}).fetch()) {
            SchemaDefinition schema = this.getSchema((String)record.getValue(Tables.ATTRIBUTES.UDT_SCHEMA));
            String name = (String)record.getValue(Tables.ATTRIBUTES.UDT_NAME);
            result.add(new PostgresUDTDefinition(schema, name, null));
        }
        return result;
    }

    @Override
    protected List<ArrayDefinition> getArrays0() throws SQLException {
        ArrayList<ArrayDefinition> result = new ArrayList<ArrayDefinition>();
        return result;
    }

    @Override
    protected List<RoutineDefinition> getRoutines0() throws SQLException {
        ArrayList<RoutineDefinition> result = new ArrayList<RoutineDefinition>();
        Routines r1 = Tables.ROUTINES.as("r1");
        Routines r2 = Tables.ROUTINES.as("r2");
        for (Record record : this.create().select(new Field[]{r1.ROUTINE_SCHEMA, r1.ROUTINE_NAME, r1.SPECIFIC_NAME, Factory.decode().when(Factory.exists((Select)this.create().selectOne().from(new TableLike[]{Tables.PARAMETERS}).where(new Condition[]{Tables.PARAMETERS.SPECIFIC_SCHEMA.equal(r1.SPECIFIC_SCHEMA)}).and(Tables.PARAMETERS.SPECIFIC_NAME.equal(r1.SPECIFIC_NAME)).and(Factory.upper(Tables.PARAMETERS.PARAMETER_MODE).notEqual((Object)"IN"))), Factory.val((Object)"void")).otherwise(r1.DATA_TYPE).as("data_type"), r1.CHARACTER_MAXIMUM_LENGTH, r1.NUMERIC_PRECISION, r1.NUMERIC_SCALE, r1.TYPE_UDT_NAME, Factory.decode().when(Factory.exists((Select)this.create().selectOne().from(new TableLike[]{r2}).where(new Condition[]{r2.ROUTINE_SCHEMA.in(this.getInputSchemata())}).and(r2.ROUTINE_SCHEMA.equal(r1.ROUTINE_SCHEMA)).and(r2.ROUTINE_NAME.equal(r1.ROUTINE_NAME)).and(r2.SPECIFIC_NAME.notEqual(r1.SPECIFIC_NAME))), this.create().select(new Field[]{Factory.count()}).from(new TableLike[]{r2}).where(new Condition[]{r2.ROUTINE_SCHEMA.in(this.getInputSchemata())}).and(r2.ROUTINE_SCHEMA.equal(r1.ROUTINE_SCHEMA)).and(r2.ROUTINE_NAME.equal(r1.ROUTINE_NAME)).and(r2.SPECIFIC_NAME.lessOrEqual(r1.SPECIFIC_NAME)).asField()).as("overload")}).from(new TableLike[]{r1}).where(new Condition[]{r1.ROUTINE_SCHEMA.in(this.getInputSchemata())}).orderBy(new SortField[]{r1.ROUTINE_SCHEMA.asc(), r1.ROUTINE_NAME.asc()}).fetch()) {
            result.add(new PostgresRoutineDefinition(this, record));
        }
        return result;
    }

    @Override
    protected List<PackageDefinition> getPackages0() throws SQLException {
        ArrayList<PackageDefinition> result = new ArrayList<PackageDefinition>();
        return result;
    }

    @Override
    public Factory create() {
        return new InformationSchemaFactory(this.getConnection());
    }
}

