/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.util.sqlserver;

import java.sql.SQLException;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.Result;
import org.jooq.SortField;
import org.jooq.TableLike;
import org.jooq.tools.StringUtils;
import org.jooq.util.AbstractRoutineDefinition;
import org.jooq.util.DefaultDataTypeDefinition;
import org.jooq.util.DefaultParameterDefinition;
import org.jooq.util.InOutDefinition;
import org.jooq.util.SchemaDefinition;
import org.jooq.util.sqlserver.information_schema.Tables;

public class SQLServerRoutineDefinition
extends AbstractRoutineDefinition {
    private final String specificName;

    public SQLServerRoutineDefinition(SchemaDefinition schema, String name, String specificName, String dataType, Number length, Number precision, Number scale) {
        super(schema, null, name, null, null);
        if (!StringUtils.isBlank((String)dataType)) {
            DefaultDataTypeDefinition type = new DefaultDataTypeDefinition(this.getDatabase(), schema, dataType, length, precision, scale);
            this.returnValue = new DefaultParameterDefinition(this, "RETURN_VALUE", -1, type);
        }
        this.specificName = specificName;
    }

    @Override
    protected void init0() throws SQLException {
        Result result = this.create().selectDistinct(new Field[]{Tables.PARAMETERS.PARAMETER_MODE, Tables.PARAMETERS.PARAMETER_NAME, Tables.PARAMETERS.DATA_TYPE, Tables.PARAMETERS.CHARACTER_MAXIMUM_LENGTH, Tables.PARAMETERS.NUMERIC_PRECISION, Tables.PARAMETERS.NUMERIC_SCALE, Tables.PARAMETERS.ORDINAL_POSITION, Tables.PARAMETERS.IS_RESULT}).from(new TableLike[]{Tables.PARAMETERS}).join((TableLike)Tables.ROUTINES).on(new Condition[]{Tables.PARAMETERS.SPECIFIC_SCHEMA.equal(Tables.ROUTINES.SPECIFIC_SCHEMA)}).and(Tables.PARAMETERS.SPECIFIC_NAME.equal(Tables.ROUTINES.SPECIFIC_NAME)).where(new Condition[]{Tables.PARAMETERS.SPECIFIC_SCHEMA.equal((Object)this.getSchema().getName())}).and(Tables.PARAMETERS.SPECIFIC_NAME.equal((Object)this.specificName)).and(Tables.PARAMETERS.IS_RESULT.isFalse()).orderBy(new SortField[]{Tables.PARAMETERS.ORDINAL_POSITION.asc()}).fetch();
        for (Record record : result) {
            String inOut = (String)record.getValue(Tables.PARAMETERS.PARAMETER_MODE);
            DefaultDataTypeDefinition type = new DefaultDataTypeDefinition(this.getDatabase(), this.getSchema(), (String)record.getValue(Tables.PARAMETERS.DATA_TYPE), (Number)record.getValue(Tables.PARAMETERS.CHARACTER_MAXIMUM_LENGTH), (Number)record.getValue(Tables.PARAMETERS.NUMERIC_PRECISION), (Number)record.getValue(Tables.PARAMETERS.NUMERIC_SCALE));
            DefaultParameterDefinition parameter = new DefaultParameterDefinition(this, ((String)record.getValue(Tables.PARAMETERS.PARAMETER_NAME)).replaceAll("@", ""), record.getValueAsInteger(Tables.PARAMETERS.ORDINAL_POSITION), type);
            this.addParameter(InOutDefinition.getFromString(inOut), parameter);
        }
    }
}

