/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.meta.firebird;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.jooq.TableOptions;
import org.jooq.impl.DSL;
import org.jooq.meta.AbstractTableDefinition;
import org.jooq.meta.ColumnDefinition;
import org.jooq.meta.DataTypeDefinition;
import org.jooq.meta.DefaultColumnDefinition;
import org.jooq.meta.DefaultDataTypeDefinition;
import org.jooq.meta.SchemaDefinition;
import org.jooq.meta.firebird.FirebirdDatabase;
import org.jooq.meta.firebird.rdb.Tables;
import org.jooq.meta.firebird.rdb.tables.Rdb$fields;
import org.jooq.meta.firebird.rdb.tables.Rdb$relationFields;

public class FirebirdTableDefinition
extends AbstractTableDefinition {
    private static final Pattern P_DEFAULT = Pattern.compile("DEFAULT\\s+");

    public FirebirdTableDefinition(SchemaDefinition schema, String name, String comment) {
        super(schema, name, comment);
    }

    public FirebirdTableDefinition(SchemaDefinition schema, String name, String comment, TableOptions.TableType tableType, String source) {
        super(schema, name, comment, tableType, source);
    }

    @Override
    protected List<ColumnDefinition> getElements0() throws SQLException {
        ArrayList<ColumnDefinition> result = new ArrayList<ColumnDefinition>();
        Rdb$relationFields r = Tables.RDB$RELATION_FIELDS.as("r");
        Rdb$fields f = Tables.RDB$FIELDS.as("f");
        for (Record record : this.create().select((SelectField)r.RDB$FIELD_NAME.trim(), r.RDB$DESCRIPTION, r.RDB$DEFAULT_VALUE, (SelectField)DSL.bitOr((Field)r.RDB$NULL_FLAG.nvl((Object)0), (Field)f.RDB$NULL_FLAG.nvl((Object)0)).as(r.RDB$NULL_FLAG), r.RDB$DEFAULT_SOURCE, r.RDB$FIELD_POSITION, (SelectField)FirebirdDatabase.CHARACTER_LENGTH(f).as("CHAR_LEN"), f.RDB$FIELD_PRECISION, (SelectField)FirebirdDatabase.FIELD_SCALE(f).as("FIELD_SCALE"), (SelectField)FirebirdDatabase.FIELD_TYPE(f).as("FIELD_TYPE"), f.RDB$FIELD_SUB_TYPE, r.RDB$DESCRIPTION).from((TableLike)r).leftOuterJoin((TableLike)f).on(r.RDB$FIELD_SOURCE.eq(f.RDB$FIELD_NAME)).where(r.RDB$RELATION_NAME.eq((Object)this.getName())).orderBy(r.RDB$FIELD_POSITION).fetch()) {
            String defaultValue = (String)record.get(r.RDB$DEFAULT_SOURCE);
            if (defaultValue != null) {
                defaultValue = P_DEFAULT.matcher(defaultValue).replaceFirst("");
            }
            DefaultDataTypeDefinition type = new DefaultDataTypeDefinition(this.getDatabase(), this.getSchema(), (String)record.get("FIELD_TYPE", String.class), (Number)record.get("CHAR_LEN", Short.TYPE), (Number)record.get(f.RDB$FIELD_PRECISION), (Number)record.get("FIELD_SCALE", Integer.class), (Boolean)((Short)record.get(r.RDB$NULL_FLAG) == 0 ? 1 : 0), defaultValue);
            DefaultColumnDefinition column = new DefaultColumnDefinition(this.getDatabase().getTable(this.getSchema(), this.getName()), (String)record.get(r.RDB$FIELD_NAME.trim()), (int)((Short)record.get(r.RDB$FIELD_POSITION)).shortValue(), (DataTypeDefinition)type, false, (String)record.get(r.RDB$DESCRIPTION));
            result.add(column);
        }
        return result;
    }
}

