/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.meta.postgres;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.OrderField;
import org.jooq.Record;
import org.jooq.Select;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.TableOptions;
import org.jooq.WindowSpecification;
import org.jooq.impl.DSL;
import org.jooq.meta.AbstractTableDefinition;
import org.jooq.meta.ColumnDefinition;
import org.jooq.meta.DataTypeDefinition;
import org.jooq.meta.DefaultColumnDefinition;
import org.jooq.meta.DefaultDataTypeDefinition;
import org.jooq.meta.ParameterDefinition;
import org.jooq.meta.SchemaDefinition;
import org.jooq.meta.postgres.PostgresDatabase;
import org.jooq.meta.postgres.PostgresRoutineDefinition;
import org.jooq.meta.postgres.information_schema.Tables;
import org.jooq.meta.postgres.information_schema.tables.Columns;
import org.jooq.meta.postgres.information_schema.tables.Parameters;
import org.jooq.meta.postgres.information_schema.tables.Routines;
import org.jooq.meta.postgres.pg_catalog.tables.PgAttribute;
import org.jooq.meta.postgres.pg_catalog.tables.PgClass;
import org.jooq.meta.postgres.pg_catalog.tables.PgProc;
import org.jooq.meta.postgres.pg_catalog.tables.PgType;
import org.jooq.tools.StringUtils;

public class PostgresTableValuedFunction
extends AbstractTableDefinition {
    private final PostgresRoutineDefinition routine;
    private final String specificName;

    public PostgresTableValuedFunction(SchemaDefinition schema, String name, String specificName, String comment) {
        this(schema, name, specificName, comment, null);
    }

    public PostgresTableValuedFunction(SchemaDefinition schema, String name, String specificName, String comment, String source) {
        this(schema, name, specificName, comment, source, null, null);
    }

    public PostgresTableValuedFunction(SchemaDefinition schema, String name, String specificName, String comment, String source, SchemaDefinition referencedSchema, String referencedName) {
        super(schema, name, comment, TableOptions.TableType.FUNCTION, source, referencedSchema, referencedName);
        this.routine = new PostgresRoutineDefinition(schema.getDatabase(), schema.getInputName(), name, specificName);
        this.specificName = specificName;
    }

    @Override
    public List<ColumnDefinition> getElements0() throws SQLException {
        ArrayList<ColumnDefinition> result = new ArrayList<ColumnDefinition>();
        PostgresDatabase db = (PostgresDatabase)this.getDatabase();
        Routines r = Tables.ROUTINES.as("r");
        Parameters p = Tables.PARAMETERS.as("p");
        Columns c = Tables.COLUMNS.as("c");
        Columns x = Tables.COLUMNS.as("x");
        PgClass pg_c = org.jooq.meta.postgres.pg_catalog.Tables.PG_CLASS.as("pgc");
        PgAttribute pg_a = org.jooq.meta.postgres.pg_catalog.Tables.PG_ATTRIBUTE.as("pga");
        PgProc pg_p = org.jooq.meta.postgres.pg_catalog.Tables.PG_PROC.as("pgp");
        PgType pg_t = org.jooq.meta.postgres.pg_catalog.Tables.PG_TYPE.as("pgt");
        Field<Integer> pPrecision = PostgresRoutineDefinition.pNumericPrecision(p);
        Field cPrecision = DSL.nvl(c.DATETIME_PRECISION, c.NUMERIC_PRECISION);
        Field rPrecision = DSL.nvl(r.DATETIME_PRECISION, r.NUMERIC_PRECISION);
        for (Record record : this.create().select(p.PARAMETER_NAME, (SelectField)DSL.rowNumber().over((WindowSpecification)DSL.partitionBy((GroupField[])new GroupField[]{p.SPECIFIC_NAME}).orderBy(new OrderField[]{p.ORDINAL_POSITION})).as(p.ORDINAL_POSITION), (SelectField)DSL.when((Condition)p.DATA_TYPE.eq((Field)DSL.inline((String)"ARRAY")), (Field)DSL.substring(p.UDT_NAME, (Field)DSL.inline((int)2)).concat(new String[]{" ARRAY"})).else_(p.DATA_TYPE).as(p.DATA_TYPE), p.CHARACTER_MAXIMUM_LENGTH, (SelectField)pPrecision.as(p.NUMERIC_PRECISION), p.NUMERIC_SCALE, (SelectField)DSL.inline((String)"true").as(c.IS_NULLABLE), (SelectField)(db.is94() ? p.PARAMETER_DEFAULT : DSL.inline((String)null)).as(c.COLUMN_DEFAULT), p.UDT_SCHEMA, (SelectField)DSL.when((Condition)p.DATA_TYPE.eq((Field)DSL.inline((String)"ARRAY")), (Field)DSL.substring(p.UDT_NAME, (Field)DSL.inline((int)2))).else_(p.UDT_NAME).as(p.UDT_NAME)).from((TableLike)r).join((TableLike)p).on(DSL.row(r.SPECIFIC_CATALOG, r.SPECIFIC_SCHEMA, r.SPECIFIC_NAME).eq(p.SPECIFIC_CATALOG, p.SPECIFIC_SCHEMA, p.SPECIFIC_NAME)).join((TableLike)pg_p).on(pg_p.PRONAME.concat(new String[]{"_"}).concat(new Field[]{pg_p.OID}).eq(r.SPECIFIC_NAME)).and(pg_p.pgNamespace().NSPNAME.eq(r.SPECIFIC_SCHEMA)).where(r.SPECIFIC_NAME.eq((Object)this.specificName)).and(p.PARAMETER_MODE.ne((Object)"IN")).and(pg_p.PRORETSET).unionAll((Select)DSL.select((SelectField)DSL.coalesce(c.COLUMN_NAME, (Object)this.getName()).as(c.COLUMN_NAME), (SelectField)DSL.coalesce(c.ORDINAL_POSITION, (Field[])new Field[]{DSL.inline((int)1)}).as(c.ORDINAL_POSITION), (SelectField)db.arrayDataType((Field<String>)x.DATA_TYPE, (Field<String>)x.UDT_NAME, (Field<Integer>)pg_a.ATTNDIMS).as(c.DATA_TYPE), (SelectField)DSL.coalesce(c.CHARACTER_MAXIMUM_LENGTH, (Field[])new Field[]{r.CHARACTER_MAXIMUM_LENGTH}).as(c.CHARACTER_MAXIMUM_LENGTH), (SelectField)DSL.coalesce((Field)cPrecision, (Field[])new Field[]{rPrecision}).as(c.NUMERIC_PRECISION), (SelectField)DSL.coalesce(c.NUMERIC_SCALE, (Field[])new Field[]{r.NUMERIC_SCALE}).as(c.NUMERIC_SCALE), (SelectField)DSL.coalesce(c.IS_NULLABLE, (Field[])new Field[]{DSL.inline((String)"true")}).as(c.IS_NULLABLE), (SelectField)DSL.coalesce(c.COLUMN_DEFAULT, (Field[])new Field[]{DSL.inline((String)null)}).as(c.COLUMN_DEFAULT), (SelectField)DSL.coalesce(c.UDT_SCHEMA, (Field[])new Field[]{DSL.inline((String)null)}).as(c.UDT_SCHEMA), (SelectField)db.arrayUdtName((Field<String>)x.DATA_TYPE, (Field<String>)x.UDT_NAME).as(c.UDT_NAME)).from((TableLike)r).join((TableLike)pg_p).on(pg_p.PRONAME.concat(new String[]{"_"}).concat(new Field[]{pg_p.OID}).eq(r.SPECIFIC_NAME)).and(pg_p.pgNamespace().NSPNAME.eq(r.SPECIFIC_SCHEMA)).leftJoin((TableLike)c).on(DSL.row(r.TYPE_UDT_CATALOG, r.TYPE_UDT_SCHEMA, r.TYPE_UDT_NAME).eq(c.TABLE_CATALOG, c.TABLE_SCHEMA, c.TABLE_NAME)).leftJoin((TableLike)pg_c).on(c.TABLE_NAME.eq(pg_c.RELNAME)).and(pg_c.pgNamespace().NSPNAME.eq(r.SPECIFIC_SCHEMA)).leftJoin((TableLike)pg_a).on(pg_c.OID.eq(pg_a.ATTRELID)).and(c.COLUMN_NAME.eq(pg_a.ATTNAME)).crossApply((TableLike)DSL.select((SelectField)DSL.coalesce(c.DATA_TYPE, (Field[])new Field[]{r.DATA_TYPE}).as(x.DATA_TYPE), (SelectField)DSL.coalesce(c.UDT_NAME, (Field[])new Field[]{r.UDT_NAME, DSL.field((Select)DSL.select(pg_t.TYPNAME).from((TableLike)pg_t).where(pg_t.OID.eq(pg_p.PRORETTYPE)))}).as(x.UDT_NAME)).asTable((Table)x)).where(r.SPECIFIC_NAME.eq((Object)this.specificName)).and(DSL.row(r.SPECIFIC_CATALOG, r.SPECIFIC_SCHEMA, r.SPECIFIC_NAME).notIn((Select)DSL.select(p.SPECIFIC_CATALOG, p.SPECIFIC_SCHEMA, p.SPECIFIC_NAME).from((TableLike)p).where(p.PARAMETER_MODE.eq((Object)"OUT")))).and(pg_p.PRORETSET)).orderBy(new int[]{2})) {
            SchemaDefinition typeSchema = null;
            String schemaName = (String)record.get(p.UDT_SCHEMA);
            if (schemaName != null) {
                typeSchema = this.getDatabase().getSchema(schemaName);
            }
            DefaultDataTypeDefinition type = new DefaultDataTypeDefinition(this.getDatabase(), typeSchema, (String)record.get(p.DATA_TYPE), (Number)record.get(p.CHARACTER_MAXIMUM_LENGTH), (Number)record.get(p.NUMERIC_PRECISION), (Number)record.get(p.NUMERIC_SCALE), (Boolean)record.get(c.IS_NULLABLE, Boolean.TYPE), (String)record.get(c.COLUMN_DEFAULT), DSL.name((String[])new String[]{(String)record.get(p.UDT_SCHEMA), (String)record.get(p.UDT_NAME)}));
            result.add(new DefaultColumnDefinition(this.getDatabase().getTable(this.getSchema(), this.getName()), (String)record.get(p.PARAMETER_NAME), result.size() + 1, (DataTypeDefinition)type, StringUtils.defaultString((String)((String)record.get(c.COLUMN_DEFAULT))).startsWith("nextval"), null));
        }
        return result;
    }

    @Override
    protected List<ParameterDefinition> getParameters0() {
        return this.routine.getInParameters();
    }
}

