/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.meta;

import org.jooq.SQLDialect;
import org.jooq.meta.Database;
import org.jooq.meta.clickhouse.ClickHouseDatabase;
import org.jooq.meta.cubrid.CUBRIDDatabase;
import org.jooq.meta.derby.DerbyDatabase;
import org.jooq.meta.duckdb.DuckDBDatabase;
import org.jooq.meta.firebird.FirebirdDatabase;
import org.jooq.meta.h2.H2Database;
import org.jooq.meta.hsqldb.HSQLDBDatabase;
import org.jooq.meta.ignite.IgniteDatabase;
import org.jooq.meta.jdbc.JDBCDatabase;
import org.jooq.meta.mariadb.MariaDBDatabase;
import org.jooq.meta.mysql.MySQLDatabase;
import org.jooq.meta.postgres.PostgresDatabase;
import org.jooq.meta.sqlite.SQLiteDatabase;
import org.jooq.meta.trino.TrinoDatabase;
import org.jooq.meta.yugabytedb.YugabyteDBDatabase;

public class Databases {
    public static final Class<? extends Database> databaseClass(SQLDialect dialect) {
        Class result = JDBCDatabase.class;
        switch (dialect.family()) {
            case CLICKHOUSE: {
                result = ClickHouseDatabase.class;
                break;
            }
            case CUBRID: {
                result = CUBRIDDatabase.class;
                break;
            }
            case DERBY: {
                result = DerbyDatabase.class;
                break;
            }
            case DUCKDB: {
                result = DuckDBDatabase.class;
                break;
            }
            case FIREBIRD: {
                result = FirebirdDatabase.class;
                break;
            }
            case H2: {
                result = H2Database.class;
                break;
            }
            case HSQLDB: {
                result = HSQLDBDatabase.class;
                break;
            }
            case IGNITE: {
                result = IgniteDatabase.class;
                break;
            }
            case MARIADB: {
                result = MariaDBDatabase.class;
                break;
            }
            case MYSQL: {
                result = MySQLDatabase.class;
                break;
            }
            case POSTGRES: {
                result = PostgresDatabase.class;
                break;
            }
            case SQLITE: {
                result = SQLiteDatabase.class;
                break;
            }
            case TRINO: {
                result = TrinoDatabase.class;
                break;
            }
            case YUGABYTEDB: {
                result = YugabyteDBDatabase.class;
                break;
            }
            case DEFAULT: {
                result = JDBCDatabase.class;
            }
        }
        return result;
    }

    public static final Database database(SQLDialect dialect) {
        try {
            Database result = Databases.databaseClass(dialect).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            result.setDialect(dialect);
            return result;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot create an Database instance for " + String.valueOf(dialect), e);
        }
    }
}

