/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.meta;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.jooq.impl.QOM;
import org.jooq.meta.AbstractConstraintDefinition;
import org.jooq.meta.ColumnDefinition;
import org.jooq.meta.DefaultInverseForeignKeyDefinition;
import org.jooq.meta.ForeignKeyDefinition;
import org.jooq.meta.InverseForeignKeyDefinition;
import org.jooq.meta.SchemaDefinition;
import org.jooq.meta.TableDefinition;
import org.jooq.meta.UniqueKeyDefinition;

public class DefaultForeignKeyDefinition
extends AbstractConstraintDefinition
implements ForeignKeyDefinition {
    private final List<ColumnDefinition> fkColumns = new ArrayList<ColumnDefinition>();
    private final List<ColumnDefinition> ukColumns = new ArrayList<ColumnDefinition>();
    private final UniqueKeyDefinition uk;
    private final QOM.ForeignKeyRule deleteRule;
    private final QOM.ForeignKeyRule updateRule;

    public DefaultForeignKeyDefinition(SchemaDefinition schema, String name, TableDefinition table, UniqueKeyDefinition uk) {
        this(schema, name, table, uk, true);
    }

    public DefaultForeignKeyDefinition(SchemaDefinition schema, String name, TableDefinition table, UniqueKeyDefinition uk, boolean enforced) {
        this(schema, name, table, uk, enforced, null, null);
    }

    public DefaultForeignKeyDefinition(SchemaDefinition schema, String name, TableDefinition table, UniqueKeyDefinition uk, boolean enforced, QOM.ForeignKeyRule deleteRule, QOM.ForeignKeyRule updateRule) {
        super(schema, table, name, enforced);
        this.uk = uk;
        this.deleteRule = deleteRule;
        this.updateRule = updateRule;
    }

    @Override
    public TableDefinition getKeyTable() {
        return this.getTable();
    }

    @Override
    public List<ColumnDefinition> getKeyColumns() {
        return this.fkColumns;
    }

    @Override
    public UniqueKeyDefinition getReferencedKey() {
        return this.uk;
    }

    @Override
    public UniqueKeyDefinition resolveReferencedKey() {
        return this.uk.resolveReferencedKey();
    }

    @Override
    public TableDefinition getReferencedTable() {
        return this.uk.getTable();
    }

    @Override
    public List<ColumnDefinition> getReferencedColumns() {
        return this.ukColumns;
    }

    @Override
    public int countSimilarReferences() {
        HashSet<String> keys = new HashSet<String>();
        for (ForeignKeyDefinition key : this.getDatabase().getRelations().getForeignKeys(this.getTable())) {
            if (!key.getReferencedTable().equals(this.getReferencedTable())) continue;
            keys.add(key.getName());
        }
        return keys.size();
    }

    @Override
    public InverseForeignKeyDefinition getInverse() {
        return new DefaultInverseForeignKeyDefinition(this);
    }

    @Override
    public QOM.ForeignKeyRule getDeleteRule() {
        return this.deleteRule;
    }

    @Override
    public QOM.ForeignKeyRule getUpdateRule() {
        return this.updateRule;
    }
}

