/*
 * Decompiled with CFR 0.152.
 */
package org.josso.gateway.identity.service;

import java.rmi.RemoteException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.josso.gateway.assertion.exceptions.AssertionNotValidException;
import org.josso.gateway.identity.exceptions.IdentityProvisioningException;
import org.josso.gateway.identity.service.SSOIdentityProviderService;
import org.josso.gateway.ws._1_2.protocol.AssertIdentityWithSimpleAuthenticationRequestType;
import org.josso.gateway.ws._1_2.protocol.AssertIdentityWithSimpleAuthenticationResponseType;
import org.josso.gateway.ws._1_2.protocol.AssertionNotValidErrorType;
import org.josso.gateway.ws._1_2.protocol.GlobalSignoffRequestType;
import org.josso.gateway.ws._1_2.protocol.GlobalSignoffResponseType;
import org.josso.gateway.ws._1_2.protocol.ResolveAuthenticationAssertionRequestType;
import org.josso.gateway.ws._1_2.protocol.ResolveAuthenticationAssertionResponseType;
import org.josso.gateway.ws._1_2.protocol.SSOIdentityProviderErrorType;
import org.josso.gateway.ws._1_2.wsdl.SSOIdentityProvider;

public class WebserviceSSOIdentityProvider
implements SSOIdentityProviderService {
    private static final Log logger = LogFactory.getLog((Class)WebserviceSSOIdentityProvider.class);
    private SSOIdentityProvider _wsSSOIdentityProvider;
    private int _errorCount;
    private int _processedCount;

    public WebserviceSSOIdentityProvider(SSOIdentityProvider wsSSOIdentityProvider) {
        this._wsSSOIdentityProvider = wsSSOIdentityProvider;
    }

    public void initialize() {
    }

    public String assertIdentityWithSimpleAuthentication(String requester, String securityDomain, String username, String password) throws IdentityProvisioningException {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("[assertIdentityWithSimpleAuthentication()] : " + username));
            }
            AssertIdentityWithSimpleAuthenticationRequestType request = new AssertIdentityWithSimpleAuthenticationRequestType();
            request.setRequester(requester);
            request.setSecurityDomain(securityDomain);
            request.setUsername(username);
            request.setPassword(password);
            AssertIdentityWithSimpleAuthenticationResponseType response = this._wsSSOIdentityProvider.assertIdentityWithSimpleAuthentication(request);
            String string = response.getAssertionId();
            return string;
        }
        catch (SSOIdentityProviderErrorType e) {
            throw new IdentityProvisioningException(e.getMessage(), (Exception)((Object)e));
        }
        catch (RemoteException e) {
            ++this._errorCount;
            throw new IdentityProvisioningException(e.getMessage(), e);
        }
        catch (Exception e) {
            ++this._errorCount;
            throw new IdentityProvisioningException(e.getMessage(), e);
        }
        finally {
            ++this._processedCount;
        }
    }

    public String resolveAuthenticationAssertion(String requester, String authenticationAssertionId) throws AssertionNotValidException, IdentityProvisioningException {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("[resolveAuthenticationAssertion()] : " + authenticationAssertionId));
            }
            ResolveAuthenticationAssertionRequestType request = new ResolveAuthenticationAssertionRequestType();
            request.setRequester(requester);
            request.setAssertionId(authenticationAssertionId);
            ResolveAuthenticationAssertionResponseType response = this._wsSSOIdentityProvider.resolveAuthenticationAssertion(request);
            String string = response.getSsoSessionId();
            return string;
        }
        catch (AssertionNotValidErrorType e) {
            throw new AssertionNotValidException(e.getAssertionId());
        }
        catch (SSOIdentityProviderErrorType e) {
            throw new IdentityProvisioningException(e.getMessage(), (Exception)((Object)e));
        }
        catch (RemoteException e) {
            ++this._errorCount;
            throw new IdentityProvisioningException(e.getMessage(), e);
        }
        catch (Exception e) {
            ++this._errorCount;
            throw new IdentityProvisioningException(e.getMessage(), e);
        }
        finally {
            ++this._processedCount;
        }
    }

    public void globalSignoff(String requester, String sessionId) throws IdentityProvisioningException {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("[globalSignoff()] : " + sessionId));
            }
            GlobalSignoffRequestType request = new GlobalSignoffRequestType();
            request.setRequester(requester);
            request.setSsoSessionId(sessionId);
            GlobalSignoffResponseType repsonse = this._wsSSOIdentityProvider.globalSignoff(request);
        }
        catch (SSOIdentityProviderErrorType e) {
            throw new IdentityProvisioningException(e.getMessage(), (Exception)((Object)e));
        }
        catch (RemoteException e) {
            ++this._errorCount;
            throw new IdentityProvisioningException(e.getMessage(), e);
        }
        catch (Exception e) {
            ++this._errorCount;
            throw new IdentityProvisioningException(e.getMessage(), e);
        }
        finally {
            ++this._processedCount;
        }
    }
}

