/*
 * Decompiled with CFR 0.152.
 */
package org.josso.agent.http;

import java.security.Principal;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.josso.agent.SSOAgentRequest;
import org.josso.agent.http.HttpSSOAgent;
import org.josso.agent.http.JOSSOSecurityContext;
import org.josso.agent.http.SSOGatewayHandler;

public class JaasHttpSSOAgent
extends HttpSSOAgent {
    private static final Log log = LogFactory.getLog(JaasHttpSSOAgent.class);

    protected Principal authenticate(SSOAgentRequest request) {
        String ssoSessionId = request.getSessionId();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Attempting SSO Session authentication by " + request.getRequester() + ":" + ssoSessionId));
        }
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Creating callback handler for " + request.getRequester() + "/" + ssoSessionId));
            }
            SSOGatewayHandler ch = new SSOGatewayHandler(request.getRequester(), ssoSessionId, request.getNodeId());
            LoginContext lc = new LoginContext("josso", ch);
            lc.login();
            if (log.isDebugEnabled()) {
                log.debug((Object)("SSO Session authenticated " + ssoSessionId));
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"Creating new JOSSO Security Context instance");
            }
            Subject s = lc.getSubject();
            JOSSOSecurityContext ctx = new JOSSOSecurityContext(s);
            return ctx.getCurrentPrincipal();
        }
        catch (LoginException e) {
            log.error((Object)e.getMessage());
            return null;
        }
    }

    protected void log(String message) {
        if (this.debug > 0) {
            log.debug((Object)message);
        }
    }

    protected void log(String message, Throwable throwable) {
        if (this.debug > 0) {
            log.debug((Object)message, throwable);
        }
    }
}

