/*
 * Decompiled with CFR 0.152.
 */
package org.josso.agent.http;

import java.io.Serializable;
import java.security.Principal;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.josso.gateway.identity.SSORole;
import org.josso.gateway.identity.SSOUser;

public class JOSSOSecurityContext
implements Serializable {
    private static final Log logger = LogFactory.getLog(JOSSOSecurityContext.class);
    private Subject subject;
    private SSOUser ssoUser;
    private Map roles;
    private String ssoSession;

    public JOSSOSecurityContext(Subject subject) {
        Set<Principal> principals = subject.getPrincipals();
        this.roles = new HashMap();
        for (Principal p : principals) {
            if (p instanceof SSOUser) {
                if (this.ssoUser != null) {
                    throw new IllegalArgumentException("Subject cannot contain multiple SSOUser instances");
                }
                this.ssoUser = (SSOUser)p;
                continue;
            }
            if (!(p instanceof SSORole)) continue;
            SSORole r = (SSORole)p;
            this.roles.put(r.getName(), r);
        }
        if (this.ssoUser == null) {
            throw new IllegalArgumentException("No SSOUser principal found in subject");
        }
    }

    public SSOUser getCurrentPrincipal() {
        return this.ssoUser;
    }

    public boolean isUserInRole(String role) {
        return this.roles.containsKey(role);
    }

    Subject getSubject() {
        return this.subject;
    }

    public String getSSOSession() {
        return this.ssoSession;
    }

    public void setSSOSession(String ssoSession) {
        this.ssoSession = ssoSession;
    }
}

