/*
 * Decompiled with CFR 0.152.
 */
package org.josso.agent;

import java.io.IOException;
import java.security.Principal;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.josso.agent.LocalSession;
import org.josso.agent.LocalSessionEvent;
import org.josso.agent.SSOAgent;
import org.josso.agent.SSOAgentConfiguration;
import org.josso.agent.SSOAgentRequest;
import org.josso.agent.SSOPartnerAppConfig;
import org.josso.agent.SingleSignOnEntry;
import org.josso.gateway.GatewayServiceLocator;
import org.josso.gateway.assertion.exceptions.AssertionNotValidException;
import org.josso.gateway.identity.service.SSOIdentityManagerService;
import org.josso.gateway.identity.service.SSOIdentityProviderService;
import org.josso.gateway.session.exceptions.FatalSSOSessionException;
import org.josso.gateway.session.exceptions.NoSuchSessionException;
import org.josso.gateway.session.exceptions.SSOSessionException;
import org.josso.gateway.session.service.SSOSessionManagerService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSSOAgent
implements SSOAgent {
    public static final long DEFAULT_SESSION_ACCESS_MIN_INTERVAL = 1000L;
    public static final ThreadLocal<SSOAgentRequest> _currentRequest = new ThreadLocal();
    protected final Map<String, SingleSignOnEntry> cache = Collections.synchronizedMap(new HashMap());
    protected final Map<LocalSession, String> reverse = Collections.synchronizedMap(new HashMap());
    protected boolean started = false;
    protected int debug = 0;
    protected GatewayServiceLocator gsl;
    protected SSOSessionManagerService sm;
    protected SSOIdentityManagerService im;
    protected SSOIdentityProviderService ip;
    protected Map<String, GatewayServiceLocator> gslsByNode = new HashMap<String, GatewayServiceLocator>();
    protected Map<String, NodeServices> servicesByNode = new HashMap<String, NodeServices>();
    protected SSOAgentConfiguration _cfg;
    private String _gatewayLoginUrl;
    private String _gatewayLogoutUrl;
    private String _gatewayLoginErrorUrl;
    private String _singlePointOfAccess;
    private long _sessionAccessMinInterval = 1000L;
    private boolean _isStateOnClient = false;
    private long _requestCount;
    private long _l1CacheHits;
    private long _l2CacheHits;

    @Override
    public void setGatewayServiceLocator(GatewayServiceLocator gsl) {
        this.gsl = gsl;
    }

    public GatewayServiceLocator getGatewayServiceLocator() {
        return this.gsl;
    }

    @Override
    public SSOSessionManagerService getSSOSessionManager() {
        return this.sm;
    }

    @Override
    public SSOSessionManagerService getSSOSessionManager(String nodeId) {
        NodeServices svcs = this.servicesByNode.get(nodeId);
        if (svcs != null) {
            return svcs.getSm();
        }
        return this.sm;
    }

    @Override
    public SSOIdentityManagerService getSSOIdentityManager() {
        return this.im;
    }

    @Override
    public SSOIdentityManagerService getSSOIdentityManager(String nodeId) {
        NodeServices svcs = this.servicesByNode.get(nodeId);
        if (svcs != null) {
            return svcs.getIm();
        }
        return this.im;
    }

    public Map<String, GatewayServiceLocator> getGatewayServiceLocators() {
        return this.gslsByNode;
    }

    public void setGatewayServiceLocators(Map<String, GatewayServiceLocator> gslsByNode) {
        this.gslsByNode = gslsByNode;
    }

    public void setGatewayLoginUrl(String gatewayLoginUrl) {
        this._gatewayLoginUrl = gatewayLoginUrl;
    }

    public String getGatewayLoginUrl() {
        return this._gatewayLoginUrl;
    }

    public String getGatewayLoginErrorUrl() {
        return this._gatewayLoginErrorUrl;
    }

    public void setGatewayLoginErrorUrl(String gatewayLoginErrorUrl) {
        this.log("gatewayLoginErrorUrl is no longer supported, modify your agent config.  Check customLoginUrl in JOSSO Gwy config for alternatives.");
        this._gatewayLoginErrorUrl = gatewayLoginErrorUrl;
    }

    public void setGatewayLogoutUrl(String gatewayLogoutUrl) {
        this._gatewayLogoutUrl = gatewayLogoutUrl;
    }

    public String getGatewayLogoutUrl() {
        return this._gatewayLogoutUrl;
    }

    public void setSessionAccessMinInterval(String v) {
        this.setSessionAccessMinInterval(Long.parseLong(v));
    }

    public long getSessionAccessMinInterval() {
        return this._sessionAccessMinInterval;
    }

    public void setSessionAccessMinInterval(long sessionAccessMinInterval) {
        this._sessionAccessMinInterval = sessionAccessMinInterval;
    }

    public String getSinglePointOfAccess() {
        return this._singlePointOfAccess;
    }

    public void setSinglePointOfAccess(String singlePointOfAccess) {
        this._singlePointOfAccess = singlePointOfAccess;
    }

    @Override
    public boolean isPartnerApp(String vhost, String contextPath) {
        return this.getPartnerAppConfig(vhost, contextPath) != null;
    }

    public SSOPartnerAppConfig getPartnerAppConfig(String vhost, String contextPath) {
        List<SSOPartnerAppConfig> papps = this._cfg.getSsoPartnerApps();
        if (contextPath == null || "".equals(contextPath)) {
            contextPath = "/";
        }
        for (SSOPartnerAppConfig ssoPartnerAppConfig : papps) {
            if (ssoPartnerAppConfig.getVhost() != null && !ssoPartnerAppConfig.getVhost().equals(vhost) || !contextPath.equals(ssoPartnerAppConfig.getContext())) continue;
            return ssoPartnerAppConfig;
        }
        this.log("No partner application configured for '" + vhost + "' and '" + contextPath + "'");
        return null;
    }

    @Override
    public void start() {
        try {
            this.sm = this.gsl.getSSOSessionManager();
            this.im = this.gsl.getSSOIdentityManager();
            this.ip = this.gsl.getSSOIdentityProvider();
            for (String nodeId : this.gslsByNode.keySet()) {
                GatewayServiceLocator gsl = this.gslsByNode.get(nodeId);
                NodeServices svcs = new NodeServices(nodeId, gsl);
                svcs.start();
                this.servicesByNode.put(nodeId, svcs);
            }
            for (SSOPartnerAppConfig cfg : this._cfg.getSsoPartnerApps()) {
                if (cfg.getId() != null) continue;
                this.log("ERROR! You should define an ID for partner application " + cfg.getContext());
            }
            if (this.debug > 0) {
                this.log("Agent Started");
            }
        }
        catch (Exception e) {
            this.log("Can't create session/identity/provider managers : \n" + e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final SingleSignOnEntry processRequest(SSOAgentRequest request) {
        try {
            _currentRequest.set(request);
            SingleSignOnEntry singleSignOnEntry = this.execute(request);
            return singleSignOnEntry;
        }
        finally {
            _currentRequest.remove();
        }
    }

    protected SingleSignOnEntry execute(SSOAgentRequest request) {
        try {
            SingleSignOnEntry entry;
            ++this._requestCount;
            int action = request.getAction();
            String jossoSessionId = request.getSessionId();
            LocalSession localSession = request.getLocalSession();
            if (action == 3) {
                try {
                    this.accessSession(request.getRequester(), jossoSessionId, request.getNodeId());
                }
                catch (SSOSessionException e) {
                    throw new FatalSSOSessionException("Assertion error for session : " + jossoSessionId, (Throwable)e);
                }
                return null;
            }
            if (action == 4) {
                this.sendCustomAuthentication(request);
                return null;
            }
            if (action == 2) {
                String assertionId = request.getAssertionId();
                jossoSessionId = this.resolveAssertion(request.getRequester(), assertionId, request.getNodeId());
                request.setSessionId(jossoSessionId);
            }
            if (this.debug > 0) {
                this.log("Checking for cached principal for " + jossoSessionId);
            }
            if ((entry = this.lookup(jossoSessionId)) != null) {
                if (this.debug > 0) {
                    this.log(" Found cached principal '" + entry.principal.getName() + "' with auth type '" + entry.authType + "'");
                }
                ++this._l1CacheHits;
                entry = this.accessSession(request.getRequester(), entry, jossoSessionId, request.getNodeId());
                if (entry != null) {
                    if (this.isAuthenticationAlwaysRequired()) {
                        Principal p = this.authenticate(request);
                        if (this.debug > 0) {
                            this.log("Updating Principal information");
                        }
                        entry.updatePrincipal(p);
                    }
                    this.propagateSecurityContext(request, entry.principal);
                }
                return entry;
            }
            localSession.addSessionListener(this);
            this.associateLocalSession(jossoSessionId, localSession);
            Principal ssoUserPrincipal = this.authenticate(request);
            if (ssoUserPrincipal != null) {
                if (this.debug > 0) {
                    this.log("Principal checked for SSO Session '" + jossoSessionId + "' : " + ssoUserPrincipal);
                }
                this.register(jossoSessionId, ssoUserPrincipal, "JOSSO");
                entry = this.lookup(jossoSessionId);
                entry = this.accessSession(request.getRequester(), entry, jossoSessionId, request.getNodeId());
                if (entry != null) {
                    this.propagateSecurityContext(request, entry.principal);
                }
                return entry;
            }
            if (this.debug > 0) {
                this.log("There is no associated principal for SSO Session '" + jossoSessionId + "'");
            }
            return null;
        }
        catch (Exception e) {
            this.log("Error processing JOSSO Agent request : " + e.getMessage());
            if (this.debug > 0) {
                this.log("Exception recieved while processing JOSSO Agent request : " + e.getMessage(), e);
            }
            return null;
        }
    }

    protected void propagateSecurityContext(SSOAgentRequest request, Principal principal) {
        throw new UnsupportedOperationException("No support for alternative mechanisms for security context propagation");
    }

    protected String resolveAssertion(String requester, String assertionId, String nodeId) {
        try {
            NodeServices svcs;
            if (this.debug > 0) {
                this.log("Dereferencing assertion for id '" + assertionId + "'");
            }
            String ssoSessionId = null;
            ssoSessionId = nodeId != null && !"".equals(nodeId) ? ((svcs = this.servicesByNode.get(nodeId)) != null ? svcs.getIp().resolveAuthenticationAssertion(requester, assertionId) : this.ip.resolveAuthenticationAssertion(requester, assertionId)) : this.ip.resolveAuthenticationAssertion(requester, assertionId);
            if (this.debug > 0) {
                this.log("Dereferencing assertion for id '" + assertionId + "' as SSO Session '" + ssoSessionId + "'");
            }
            return ssoSessionId;
        }
        catch (AssertionNotValidException e) {
            if (this.debug > 0) {
                this.log("Invalid Assertion");
            }
            return null;
        }
        catch (Exception e) {
            this.log(e.getMessage() != null ? e.getMessage() : e.toString(), e);
            return null;
        }
    }

    protected SingleSignOnEntry accessSession(String requester, SingleSignOnEntry entry, String jossoSessionId, String nodeId) {
        if (entry == null) {
            return entry;
        }
        long now = System.currentTimeMillis();
        if (now - entry.lastAccessTime < this.getSessionAccessMinInterval()) {
            ++this._l2CacheHits;
            return entry;
        }
        try {
            if (this.debug > 0) {
                this.log("Notifying keep-alive event for session '" + jossoSessionId + "'");
            }
            if (nodeId != null && !"".equals(nodeId)) {
                NodeServices svcs = this.servicesByNode.get(nodeId);
                if (svcs != null) {
                    if (this.debug > 0) {
                        this.log("Using services for node : " + nodeId);
                    }
                    svcs.getSm().accessSession(requester, jossoSessionId);
                } else {
                    if (this.debug > 0) {
                        this.log("Using default services for node : " + nodeId);
                    }
                    this.sm.accessSession(requester, jossoSessionId);
                }
            } else {
                if (this.debug > 0) {
                    this.log("Using default services, no node found");
                }
                this.sm.accessSession(requester, jossoSessionId);
            }
            entry.lastAccessTime = now;
            return entry;
        }
        catch (NoSuchSessionException e) {
            if (this.debug > 0) {
                this.log("SSO Session is no longer valid");
            }
            this.deregister(entry.ssoId);
            return null;
        }
        catch (Exception e) {
            this.log(e.getMessage() != null ? e.getMessage() : e.toString(), e);
            this.deregister(entry.ssoId);
            return null;
        }
    }

    protected void accessSession(String requester, String jossoSessionId, String nodeId) throws SSOSessionException {
        try {
            if (this.debug > 0) {
                this.log("Notifying keep-alive event for session '" + jossoSessionId + "'");
            }
            if (nodeId != null && !"".equals(nodeId)) {
                NodeServices svcs = this.servicesByNode.get(nodeId);
                if (svcs != null) {
                    if (this.debug > 0) {
                        this.log("Using services for node : " + nodeId);
                    }
                    svcs.getSm().accessSession(requester, jossoSessionId);
                } else {
                    if (this.debug > 0) {
                        this.log("Using default services for node : " + nodeId);
                    }
                    this.sm.accessSession(requester, jossoSessionId);
                }
            } else {
                if (this.debug > 0) {
                    this.log("Using default services, no node found");
                }
                this.sm.accessSession(requester, jossoSessionId);
            }
        }
        catch (NoSuchSessionException e) {
            if (this.debug > 0) {
                this.log("SSO Session is no longer valid");
            }
            throw e;
        }
        catch (Exception e) {
            this.log(e.getMessage() != null ? e.getMessage() : e.toString(), e);
            throw new SSOSessionException(e.getMessage() != null ? e.getMessage() : e.toString(), (Throwable)e);
        }
    }

    protected abstract void sendCustomAuthentication(SSOAgentRequest var1) throws IOException;

    protected abstract Principal authenticate(SSOAgentRequest var1);

    protected abstract boolean isAuthenticationAlwaysRequired();

    protected abstract void log(String var1);

    protected abstract void log(String var1, Throwable var2);

    @Override
    public void stop() {
        if (this.debug > 0) {
            this.log("Agent Stopped");
        }
    }

    @Override
    public void localSessionEvent(LocalSessionEvent event) {
        if (!"destroyLocalSession".equals(event.getType())) {
            return;
        }
        LocalSession session = event.getLocalSession();
        if (this.debug > 0) {
            this.log("Local session destroyed on " + session);
        }
        this.localSessionDestroyedEvent(session);
    }

    @Override
    public void setConfiguration(SSOAgentConfiguration cfg) {
        this._cfg = cfg;
    }

    @Override
    public SSOAgentConfiguration getConfiguration() {
        return this._cfg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void localSessionDestroyedEvent(LocalSession session) {
        String ssoId = null;
        Map<LocalSession, String> map = this.reverse;
        synchronized (map) {
            ssoId = this.reverse.remove(session);
        }
        if (ssoId == null) {
            return;
        }
        this.deregister(ssoId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void associateLocalSession(String ssoId, LocalSession localSession) {
        SingleSignOnEntry sso = this.lookup(ssoId);
        if (sso != null) {
            sso.addSession(localSession);
        }
        Map<LocalSession, String> map = this.reverse;
        synchronized (map) {
            this.reverse.put(localSession, ssoId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deregister(String ssoId) {
        SingleSignOnEntry sso = null;
        Map<String, SingleSignOnEntry> map = this.cache;
        synchronized (map) {
            sso = this.cache.remove(ssoId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void register(String ssoId, Principal principal, String authType) {
        Map<String, SingleSignOnEntry> map = this.cache;
        synchronized (map) {
            this.cache.put(ssoId, new SingleSignOnEntry(ssoId, principal, authType));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SingleSignOnEntry lookup(String ssoId) {
        Map<String, SingleSignOnEntry> map = this.cache;
        synchronized (map) {
            return this.cache.get(ssoId);
        }
    }

    public int getDebug() {
        return this.debug;
    }

    public void setDebug(int debug) {
        this.debug = debug;
    }

    public long getRequestCount() {
        return this._requestCount;
    }

    public long getL1CacheHits() {
        return this._l1CacheHits;
    }

    public long getL2CacheHits() {
        return this._l2CacheHits;
    }

    public boolean isStateOnClient() {
        return this._isStateOnClient;
    }

    public void setIsStateOnClient(boolean isStateOnClient) {
        this._isStateOnClient = isStateOnClient;
    }

    public void setStateOnClient(boolean isStateOnClient) {
        this._isStateOnClient = isStateOnClient;
    }

    public class NodeServices {
        private String nodeId;
        protected GatewayServiceLocator gsl;
        protected SSOSessionManagerService sm;
        protected SSOIdentityManagerService im;
        protected SSOIdentityProviderService ip;

        public NodeServices(String nodeId, GatewayServiceLocator gsl) {
            this.nodeId = nodeId;
            this.gsl = gsl;
        }

        public void start() {
            try {
                this.sm = this.gsl.getSSOSessionManager();
                this.im = this.gsl.getSSOIdentityManager();
                this.ip = this.gsl.getSSOIdentityProvider();
                if (AbstractSSOAgent.this.debug > 0) {
                    AbstractSSOAgent.this.log("Agent Services clients started for " + this.nodeId);
                }
            }
            catch (Exception e) {
                AbstractSSOAgent.this.log("Can't create session/identity/provider managers : \n" + e.getMessage(), e);
            }
        }

        public SSOSessionManagerService getSm() {
            return this.sm;
        }

        public SSOIdentityManagerService getIm() {
            return this.im;
        }

        public SSOIdentityProviderService getIp() {
            return this.ip;
        }
    }
}

