/*
 * Decompiled with CFR 0.152.
 */
package org.josso.agent.http;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.josso.agent.http.AbstractAutomaticLoginStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultAutomaticLoginStrategy
extends AbstractAutomaticLoginStrategy {
    private static final Log log = LogFactory.getLog(DefaultAutomaticLoginStrategy.class);
    private List<String> ignoredReferrers = new ArrayList<String>();

    public DefaultAutomaticLoginStrategy() {
    }

    public DefaultAutomaticLoginStrategy(String mode) {
        super(mode);
    }

    public List<String> getIgnoredReferrers() {
        return this.ignoredReferrers;
    }

    public void setIgnoredReferrers(List<String> ignoredReferrers) {
        this.ignoredReferrers = ignoredReferrers;
    }

    @Override
    public boolean isAutomaticLoginRequired(HttpServletRequest hreq, HttpServletResponse hres) {
        block17: {
            try {
                Boolean autoLoginExecuted = Boolean.parseBoolean(this.getAgent().getAttribute(hreq, "JOSSO_AUTOMATIC_LOGIN_EXECUTED"));
                if (autoLoginExecuted == null || !autoLoginExecuted.booleanValue()) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"No referer found and automatic login was never executed.  Require Autologin!");
                    }
                    this.getAgent().setAttribute(hreq, hres, "JOSSO_AUTOMATIC_LOGIN_EXECUTED", "TRUE");
                    return true;
                }
                String referer = hreq.getHeader("referer");
                if (referer != null && !"".equals(referer)) {
                    for (String ignoredReferrer : this.ignoredReferrers) {
                        if (!referer.startsWith(ignoredReferrer)) continue;
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Referer should be ignored " + referer));
                        }
                        return false;
                    }
                    String oldReferer = this.getAgent().getAttribute(hreq, "JOSSO_AUTOMATIC_LOGIN_REFERER");
                    if (oldReferer != null && oldReferer.equals(referer)) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Referer already processed " + referer));
                        }
                        this.getAgent().removeAttribute(hreq, hres, "JOSSO_AUTOMATIC_LOGIN_REFERER");
                        return false;
                    }
                    StringBuffer mySelf = hreq.getRequestURL();
                    URL myUrl = new URL(mySelf.toString());
                    String myUrlStr = myUrl.getProtocol() + "://" + myUrl.getHost() + (myUrl.getPort() > 0 && myUrl.getPort() != 80 && myUrl.getPort() != 443 ? ":" + myUrl.getPort() : "") + hreq.getContextPath();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Processing referer " + referer + " for host " + myUrlStr));
                    }
                    if (!referer.startsWith(myUrlStr)) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"Referer found differs from current host.  Require Autologin!");
                        }
                        this.getAgent().setAttribute(hreq, hres, "JOSSO_AUTOMATIC_LOGIN_REFERER", referer);
                        return true;
                    }
                    break block17;
                }
                String oldReferer = this.getAgent().getAttribute(hreq, "JOSSO_AUTOMATIC_LOGIN_REFERER");
                if (oldReferer != null && oldReferer.equals("NO_REFERER")) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Referer already processed " + referer));
                    }
                    this.getAgent().removeAttribute(hreq, hres, "JOSSO_AUTOMATIC_LOGIN_REFERER");
                    return false;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)"No old Referer found.  Require Autologin!");
                }
                this.getAgent().setAttribute(hreq, hres, "JOSSO_AUTOMATIC_LOGIN_REFERER", "NO_REFERER");
                return true;
            }
            catch (MalformedURLException e) {
                log.debug((Object)("Error creating Referer URL : " + e.getMessage()), (Throwable)e);
            }
            catch (Exception e) {
                log.debug((Object)("Cannot verify request for automatic login : " + e.getMessage()), (Throwable)e);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Do not Require Autologin!");
        }
        return false;
    }
}

