/*
 * Decompiled with CFR 0.152.
 */
package org.josso.agent;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.josso.agent.SSOAgent;
import org.josso.agent.config.ComponentKeeper;
import org.josso.agent.config.ComponentKeeperFactory;
import org.josso.agent.reverseproxy.ReverseProxyConfiguration;

public class Lookup {
    private static final Log logger = LogFactory.getLog((Class)Lookup.class);
    private String configResourceName;
    private static final Lookup INSTANCE = new Lookup();
    private ComponentKeeper _componentKeeper;
    private SSOAgent _ssoAgent;
    private ReverseProxyConfiguration reverseProxyConfiguration;

    private Lookup() {
    }

    public static Lookup getInstance() {
        return INSTANCE;
    }

    public void init(String configResourceName) {
        logger.info((Object)("Init resourceName <" + configResourceName + ">"));
        this.configResourceName = configResourceName;
    }

    public synchronized SSOAgent lookupSSOAgent() throws Exception {
        if (this._ssoAgent == null) {
            this._ssoAgent = this.getComponentKeeper().fetchSSOAgent();
        }
        return this._ssoAgent;
    }

    public ComponentKeeper getComponentKeeper() throws Exception {
        if (this._componentKeeper == null) {
            ComponentKeeperFactory factory = ComponentKeeperFactory.getInstance();
            factory.setResourceFileName(this.configResourceName);
            this._componentKeeper = factory.newComponentKeeper();
            logger.info((Object)("Using ComponentKeeper : " + this._componentKeeper.getClass().getName()));
        }
        return this._componentKeeper;
    }

    public ReverseProxyConfiguration lookupReverseProxyConfiguration() throws Exception {
        if (this.reverseProxyConfiguration == null) {
            this.reverseProxyConfiguration = this.getComponentKeeper().fetchReverseProxyConfiguration();
        }
        return this.reverseProxyConfiguration;
    }

    public ReverseProxyConfiguration getReverseProxyConfiguration() {
        return this.reverseProxyConfiguration;
    }

    public void setReverseProxyConfiguration(ReverseProxyConfiguration reverseProxyConfiguration) {
        this.reverseProxyConfiguration = reverseProxyConfiguration;
    }

    public static void main(String[] args) throws Exception {
    }
}

