/*
 * Decompiled with CFR 0.152.
 */
package org.josso.agent.http;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.josso.agent.http.AbstractAutomaticLoginStrategy;
import org.josso.agent.http.Robot;

public class BotAutomaticLoginStrategy
extends AbstractAutomaticLoginStrategy {
    private static final Log log = LogFactory.getLog((Class)BotAutomaticLoginStrategy.class);
    private String file = "/bots.properties";
    private Map bots;

    public BotAutomaticLoginStrategy() {
    }

    public BotAutomaticLoginStrategy(String mode) {
        super(mode);
    }

    public boolean isAutomaticLoginRequired(HttpServletRequest hreq, HttpServletResponse hres) {
        String userAgent;
        if (this.bots == null) {
            this.loadRobots();
        }
        if (this.bots.get(userAgent = hreq.getHeader("User-Agent")) != null) {
            log.debug((Object)("Autologin not required for bot: " + userAgent));
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadRobots() {
        this.bots = new HashMap();
        InputStream is = null;
        try {
            is = this.getClass().getResourceAsStream(this.file);
            if (is == null) {
                throw new IOException("Cannot find resource: " + this.file + ". Make sure this file is installed with JOSSO Agent!");
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            String line = null;
            Robot robot = new Robot();
            String name = null;
            String value = null;
            while ((line = br.readLine()) != null) {
                if (!line.trim().equals("")) {
                    if (line.startsWith("robot-") || line.startsWith("modified-")) {
                        int separatorIndex = line.indexOf(":");
                        name = line.substring(0, separatorIndex);
                        value = line.substring(separatorIndex + 1).trim();
                        this.setRobotProperty(robot, name, value, false);
                        continue;
                    }
                    this.setRobotProperty(robot, name, line, true);
                    continue;
                }
                this.bots.put(robot.getUserAgent(), robot);
                robot = new Robot();
                name = null;
                value = null;
            }
            log.info((Object)("Loaded bots file: " + this.file));
        }
        catch (IOException e) {
            log.error((Object)("Cannot load bot properties from " + this.file + " : " + e.getMessage()), (Throwable)e);
            this.bots = null;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void setRobotProperty(Robot robot, String name, String value, boolean append) {
        if (robot == null || name == null || value == null) {
            return;
        }
        value = value.trim();
        if (name.startsWith("robot-id")) {
            robot.setId(value);
        } else if (name.startsWith("robot-name")) {
            robot.setName(value);
        } else if (name.startsWith("robot-cover-url")) {
            robot.setCoverUrl(value);
        } else if (name.startsWith("robot-details-url")) {
            robot.setDetailsUrl(value);
        } else if (name.startsWith("robot-owner-name")) {
            robot.setOwnerName(value);
        } else if (name.startsWith("robot-owner-url")) {
            robot.setOwnerUrl(value);
        } else if (name.startsWith("robot-owner-email")) {
            robot.setOwnerEmail(value);
        } else if (name.startsWith("robot-status")) {
            robot.setStatus(value);
        } else if (name.startsWith("robot-purpose")) {
            robot.setPurpose(value);
        } else if (name.startsWith("robot-type")) {
            robot.setType(value);
        } else if (name.startsWith("robot-platform")) {
            robot.setPlatform(value);
        } else if (name.startsWith("robot-availability")) {
            robot.setAvailability(value);
        } else if (name.startsWith("robot-exclusion-useragent")) {
            robot.setExclusionUserAgent(value);
        } else if (name.startsWith("robot-exclusion")) {
            robot.setExclusion(value);
        } else if (name.startsWith("robot-noindex")) {
            robot.setNoindex(value);
        } else if (name.startsWith("robot-host")) {
            robot.setHost(value);
        } else if (name.startsWith("robot-from")) {
            robot.setFrom(value);
        } else if (name.startsWith("robot-useragent")) {
            robot.setUserAgent(value);
        } else if (name.startsWith("robot-language")) {
            robot.setLanguage(value);
        } else if (name.startsWith("robot-description")) {
            if (append && robot.getDescription() != null) {
                robot.setDescription(robot.getDescription() + " " + value);
            } else {
                robot.setDescription(value);
            }
        } else if (name.startsWith("robot-history")) {
            if (append && robot.getHistory() != null) {
                robot.setHistory(robot.getHistory() + " " + value);
            } else {
                robot.setHistory(value);
            }
        } else if (name.startsWith("robot-environment")) {
            robot.setEnvironment(value);
        } else if (name.startsWith("modified-date")) {
            robot.setModifiedDate(value);
        } else if (name.startsWith("modified-by")) {
            robot.setModifiedBy(value);
        }
    }

    public String getFile() {
        return this.file;
    }

    public void setFile(String file) {
        this.file = file;
    }
}

