/*
 * Decompiled with CFR 0.152.
 */
package org.josso.gateway;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.josso.gateway.SSORequest;
import org.josso.gateway.SecurityDomainMatcher;

public class AppContextSecurityDomainMatcher
implements SecurityDomainMatcher {
    private static Log logger = LogFactory.getLog(AppContextSecurityDomainMatcher.class);
    private List<String> appWebCtxs = new ArrayList<String>();

    public void init() {
        if (this.appWebCtxs.isEmpty()) {
            logger.warn((Object)"No web contexts defined for this matcher, check JOSSO configuration!");
        }
    }

    public boolean match(SSORequest req) {
        boolean match;
        String appWebCtx = req.getParameter("josso_partnerapp_ctx");
        boolean bl = match = appWebCtx != null && this.appWebCtxs.contains(appWebCtx.toLowerCase());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Request does " + (match ? "" : "not") + " match ctx : " + appWebCtx));
        }
        return match;
    }

    public void setAppWebContexts(String stAppWebCtxs) {
        StringTokenizer st = new StringTokenizer(stAppWebCtxs, ",");
        while (st.hasMoreTokens()) {
            String appWebCtx = st.nextToken();
            this.appWebCtxs.add(appWebCtx.toLowerCase());
            if (!logger.isDebugEnabled()) continue;
            logger.debug((Object)("Adding AppWebCtx :" + appWebCtx));
        }
    }
}

