/*
 * Decompiled with CFR 0.152.
 */
package org.josso.util.id;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.josso.util.id.IdGenerator;

public abstract class AbstractIdGenerator
implements IdGenerator {
    private static final Log logger = LogFactory.getLog(AbstractIdGenerator.class);
    protected static final String DEFAULT_ALGORITHM = "MD5";
    private String _algorithm = "MD5";
    private int _assertionIdLength = 16;
    private String _entropy;
    private Random _random;
    protected String _randomClass = "java.security.SecureRandom";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Random getRandom() {
        if (this._random == null) {
            AbstractIdGenerator abstractIdGenerator = this;
            synchronized (abstractIdGenerator) {
                if (this._random == null) {
                    long seed;
                    long t1 = seed = System.currentTimeMillis();
                    char[] entropy = this.getEntropy().toCharArray();
                    for (int i = 0; i < entropy.length; ++i) {
                        long update = (byte)entropy[i] << i % 8 * 8;
                        seed ^= update;
                    }
                    try {
                        Class<?> clazz = Class.forName(this._randomClass);
                        this._random = (Random)clazz.newInstance();
                        this._random.setSeed(seed);
                    }
                    catch (Exception e) {
                        logger.error((Object)("Can't use random class : " + this._randomClass + ", fall back to the simple case."), (Throwable)e);
                        this._random = new Random();
                        this._random.setSeed(seed);
                    }
                    long t2 = System.currentTimeMillis();
                    if (t2 - t1 > 100L) {
                        logger.debug((Object)("Delay getting Random with class : " + this._randomClass + " [getRandom()] " + (t2 - t1) + " ms."));
                    }
                }
            }
        }
        return this._random;
    }

    public synchronized MessageDigest getDigest() {
        MessageDigest digest = null;
        if (this._algorithm != null) {
            try {
                digest = MessageDigest.getInstance(this._algorithm);
                logger.debug((Object)("Using hash algorithm/encoding : " + this._algorithm));
            }
            catch (NoSuchAlgorithmException e) {
                logger.error((Object)("Algorithm not supported : " + this._algorithm), (Throwable)e);
                try {
                    digest = MessageDigest.getInstance(DEFAULT_ALGORITHM);
                }
                catch (NoSuchAlgorithmException f) {
                    logger.error((Object)"Algorithm not supported : MD5", (Throwable)e);
                    digest = null;
                }
            }
        }
        return digest;
    }

    protected void getRandomBytes(byte[] bytes) {
        Random random = this.getRandom();
        random.nextBytes(bytes);
    }

    public String getEntropy() {
        if (this._entropy == null) {
            this.setEntropy(this.toString());
        }
        return this._entropy;
    }

    public void setEntropy(String entropy) {
        this._entropy = entropy;
    }

    public String getAlgorithm() {
        return this._algorithm;
    }

    public void setAlgorithm(String algorithm) {
        this._algorithm = algorithm;
    }

    public int getAssertionIdLength() {
        return this._assertionIdLength;
    }

    public void setAssertionIdLength(int idLength) {
        this._assertionIdLength = idLength;
    }

    public String getRandomClass() {
        return this._randomClass;
    }

    public void setRandomClass(String randomClass) {
        this._randomClass = randomClass;
        this._random = null;
    }
}

