/*
 * Decompiled with CFR 0.152.
 */
package org.josso.gateway;

import org.josso.gateway.ServiceLocatorConfigurationError;
import org.josso.gateway.identity.service.SSOIdentityManagerService;
import org.josso.gateway.identity.service.SSOIdentityProviderService;
import org.josso.gateway.session.service.SSOSessionManagerService;

public abstract class GatewayServiceLocator {
    protected static final String property = "org.josso.gateway.GatewayServiceLocator";
    protected static final String gwyLocator = "org.josso.gateway.WebserviceGatewayServiceLocator";
    protected static final String TRANSPORT_SECURITY_NONE = "none";
    protected static final String TRANSPORT_SECURITY_CONFIDENTIAL = "confidential";
    private String endpoint;
    private String username;
    private String transportSecurity = "none";
    private String servicesWebContext;
    private String sessionManagerServicePath;
    private String identityManagerServicePath;
    private String identityProviderServicePath;
    private String password;

    public static GatewayServiceLocator newInstance() {
        String n = gwyLocator;
        try {
            n = System.getProperty(property, gwyLocator);
        }
        catch (SecurityException e) {
            n = gwyLocator;
        }
        try {
            return (GatewayServiceLocator)Class.forName(n).newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new ServiceLocatorConfigurationError("Cannot load class GatewayServiceLocator class \"" + n + "\"");
        }
        catch (InstantiationException e) {
            throw new ServiceLocatorConfigurationError("Cannot instantiate the specified GatewayServiceLocator class \"" + n + "\"");
        }
        catch (IllegalAccessException e) {
            throw new ServiceLocatorConfigurationError("Cannot access the specified GatewayServiceLocator class \"" + n + "\"");
        }
        catch (ClassCastException e) {
            throw new ServiceLocatorConfigurationError("The specified class \"" + n + "\" is not instance of \"org.josso.gateway.GatewayServiceLocator\"");
        }
    }

    public abstract SSOSessionManagerService getSSOSessionManager() throws Exception;

    public abstract SSOIdentityManagerService getSSOIdentityManager() throws Exception;

    public abstract SSOIdentityProviderService getSSOIdentityProvider() throws Exception;

    public String getEndpointBase() {
        return (this.transportSecurity.equalsIgnoreCase(TRANSPORT_SECURITY_CONFIDENTIAL) ? "https" : "http") + "://" + this.endpoint + "/";
    }

    public String getSSOSessionManagerEndpoint() {
        if (this.sessionManagerServicePath != null) {
            return this.getEndpointBase() + this.sessionManagerServicePath;
        }
        return this.getEndpointBase() + (this.servicesWebContext != null ? this.servicesWebContext : "josso") + "/services/SSOSessionManagerSoap";
    }

    public String getSSOIdentityManagerEndpoint() {
        if (this.identityManagerServicePath != null) {
            return this.getEndpointBase() + this.identityManagerServicePath;
        }
        return this.getEndpointBase() + (this.servicesWebContext != null ? this.servicesWebContext : "josso") + "/services/SSOIdentityManagerSoap";
    }

    public String getSSOIdentityProviderEndpoint() {
        if (this.identityProviderServicePath != null) {
            return this.getEndpointBase() + this.identityProviderServicePath;
        }
        return this.getEndpointBase() + (this.servicesWebContext != null ? this.servicesWebContext : "josso") + "/services/SSOIdentityProviderSoap";
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setServicesWebContext(String servicesWebContext) {
        this.servicesWebContext = servicesWebContext;
    }

    public String getServicesWebContext() {
        return this.servicesWebContext;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return "*";
    }

    public void setTransportSecurity(String transportSecurity) {
        this.transportSecurity = transportSecurity;
    }

    public String getTransportSecurity() {
        return this.transportSecurity;
    }

    public String getSessionManagerServicePath() {
        return this.sessionManagerServicePath;
    }

    public void setSessionManagerServicePath(String sessionManagerServicePath) {
        this.sessionManagerServicePath = sessionManagerServicePath;
    }

    public String getIdentityManagerServicePath() {
        return this.identityManagerServicePath;
    }

    public void setIdentityManagerServicePath(String identityManagerServicePath) {
        this.identityManagerServicePath = identityManagerServicePath;
    }

    public String getIdentityProviderServicePath() {
        return this.identityProviderServicePath;
    }

    public void setIdentityProviderServicePath(String identityProviderServicePath) {
        this.identityProviderServicePath = identityProviderServicePath;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }
}

