/*
 * Decompiled with CFR 0.152.
 */
package org.josso.gateway.identity.service.store.db;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.josso.gateway.identity.exceptions.SSOIdentityException;
import org.josso.gateway.identity.service.store.db.AbstractDBIdentityStore;

public class JDBCIdentityStore
extends AbstractDBIdentityStore {
    private static final Log logger = LogFactory.getLog(JDBCIdentityStore.class);
    protected String _connectionName = null;
    protected String _connectionPassword = null;
    protected String _connectionURL = null;
    protected Driver _driver = null;
    protected String _driverName = null;

    protected Connection getDBConnection() throws SSOIdentityException {
        if (this._driver == null) {
            try {
                Class<?> clazz = Class.forName(this._driverName);
                this._driver = (Driver)clazz.newInstance();
            }
            catch (Throwable e) {
                throw new SSOIdentityException(e.getMessage(), e);
            }
        }
        Properties props = new Properties();
        if (this._connectionName != null) {
            props.put("user", this._connectionName);
        }
        if (this._connectionPassword != null) {
            props.put("password", this._connectionPassword);
        }
        try {
            Connection c = this._driver.connect(this._connectionURL, props);
            c.setAutoCommit(false);
            return c;
        }
        catch (SQLException e) {
            logger.error((Object)("[getDBConnection()]:" + e.getErrorCode() + "/" + e.getSQLState() + "]" + e.getMessage()));
            throw new SSOIdentityException(e.getMessage(), (Throwable)e);
        }
    }

    public String getConnectionName() {
        return this._connectionName;
    }

    public void setConnectionName(String connectionName) {
        this._connectionName = connectionName;
    }

    public String getConnectionPassword() {
        return this._connectionPassword;
    }

    public void setConnectionPassword(String connectionPassword) {
        this._connectionPassword = connectionPassword;
    }

    public String getConnectionURL() {
        return this._connectionURL;
    }

    public void setConnectionURL(String connectionURL) {
        this._connectionURL = connectionURL;
    }

    public String getDriverName() {
        return this._driverName;
    }

    public void setDriverName(String driverName) {
        this._driverName = driverName;
    }
}

