/*
 * Decompiled with CFR 0.152.
 */
package org.josso.gateway.event;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.josso.gateway.event.SSOEvent;
import org.josso.gateway.event.SSOEventListener;
import org.josso.gateway.event.SSOEventManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SSOEventManagerImpl
implements SSOEventManager {
    private static Log log = LogFactory.getLog(SSOEventManagerImpl.class);
    private List<SSOEventListener> listeners = new ArrayList<SSOEventListener>();

    public void initialize() {
    }

    public void destroy() {
    }

    public void fireSSOEvent(SSOEvent event) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            SSOEventListener listener = this.listeners.get(i);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Handling SSO event to " + listener.getName() + " [" + listener.getClass().getName() + "]"));
            }
            listener.handleSSOEvent(event);
        }
    }

    public void registerListener(SSOEventListener listener) {
        this.listeners.add(listener);
    }

    public List<SSOEventListener> getListeners() {
        return this.listeners;
    }

    public void removeAllListeners() {
        this.listeners.clear();
    }

    public void setListeners(List<SSOEventListener> listeners) {
        for (SSOEventListener listener : listeners) {
            this.registerListener(listener);
        }
    }
}

