/*
 * Decompiled with CFR 0.152.
 */
package org.josso.selfservices.password.generator;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.josso.selfservices.password.generator.IPasswordFilter;
import org.josso.selfservices.password.generator.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultBlacklistFilter
implements IPasswordFilter {
    private static final Log logger = LogFactory.getLog(DefaultBlacklistFilter.class);
    private List<String> blacklist = new ArrayList<String>();

    @Override
    public String filter(int passwordFlags, String password) {
        for (String blackword : this.blacklist) {
            logger.debug((Object)(Messages.getString("DefaultBlacklistFilter.CHECK_PASSWD") + password + Messages.getString("DefaultBlacklistFilter.BLACKLIST_ENTRY") + blackword + "\""));
            if (!password.equals(blackword)) continue;
            return null;
        }
        return password;
    }

    @Override
    public List<String> filter(int passwordFlags, List<String> password) {
        ArrayList<String> suiatble = new ArrayList<String>();
        for (String element : password) {
            if (this.filter(passwordFlags, password) == null) continue;
            suiatble.add(element);
        }
        return suiatble;
    }

    @Override
    public String getDescription() {
        return Messages.getString("DefaultBlacklistFilter.DESCR");
    }

    @Override
    public String getId() {
        return this.getClass().getName();
    }

    @Override
    public void setDescription(String description) {
    }

    @Override
    public void setId(String id) {
        logger.debug((Object)Messages.getString("DefaultBlacklistFilter.ID_CHANGE"));
    }

    @Override
    public List<String> getBlacklist() {
        return this.blacklist;
    }

    @Override
    public void setBlacklist(List<String> blacklist) {
        if (logger.isDebugEnabled()) {
            for (String blacklisted : blacklist) {
                logger.debug((Object)("Blacklisted password [" + blacklisted + "] "));
            }
        }
        this.blacklist = blacklist;
    }

    @Override
    public boolean addToBlacklist(String blackWord) {
        return this.blacklist.add(blackWord);
    }

    @Override
    public boolean removeFromBlacklist(String blackWord) {
        return this.blacklist.remove(blackWord);
    }
}

