/*
 * Decompiled with CFR 0.152.
 */
package org.josso.selfservices.password.generator;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.josso.selfservices.password.generator.IPasswordFilter;
import org.josso.selfservices.password.generator.IPwGenConstants;
import org.josso.selfservices.password.generator.IPwGenRegEx;
import org.josso.selfservices.password.generator.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultRegExFilter
implements IPasswordFilter,
IPwGenConstants,
IPwGenRegEx {
    private List<String> blacklist = new ArrayList<String>();
    private static final Pattern REGEX_STARTS_NO_SMALL_LETTER_P = Pattern.compile("^[a-z]");
    private static final Pattern REGEX_ENDS_NO_SMALL_LETTER_P = Pattern.compile("[a-z]$");
    private static final Pattern REGEX_STARTS_NO_UPPER_LETTER_P = Pattern.compile("^[A-Z]");
    private static final Pattern REGEX_ENDS_NO_UPPER_LETTER_P = Pattern.compile("[A-Z]$");
    private static final Pattern REGEX_STARTS_NO_DIGIT_P = Pattern.compile("^\\d");
    private static final Pattern REGEX_ENDS_NO_DIGIT_P = Pattern.compile("\\d$");
    private static final Pattern REGEX_STARTS_NO_SYMBOL_P = Pattern.compile("^\\W");
    private static final Pattern REGEX_ENDS_NO_SYMBOL_P = Pattern.compile("[\\W]$");
    private static final Pattern REGEX_ONLY_1_CAPITAL_P = Pattern.compile("^[^A-Z]*[A-Z][^A-Z]*$");
    private static final Pattern REGEX_ONLY_1_SYMBOL_P = Pattern.compile("^\\w*\\W\\w*$");
    private static final Pattern REGEX_ONLY_1_DIGIT_P = Pattern.compile("^[\\D]*\\d[\\D]*$");
    private static final Pattern REGEX_AT_LEAST_2_SYMBOLS_P = Pattern.compile("\\w*[^\\w]\\w*[^\\w]\\w*");
    private static final Pattern REGEX_AT_LEAST_2_DIGITS_P = Pattern.compile("\\w*[\\W]*[\\d]\\w*[\\W]*[\\d]\\w*[\\W]*");
    private static final Log logger = LogFactory.getLog(DefaultRegExFilter.class);

    @Override
    public String filter(int passwordFlags, String password) {
        Matcher matcher;
        if ((passwordFlags & 0x20) != 0 && (matcher = REGEX_ENDS_NO_SMALL_LETTER_P.matcher(password)).find()) {
            logger.debug((Object)(Messages.getString("DefaultRegExFilter.debug_PASSWD") + password + Messages.getString("DefaultRegExFilter.ENDS_SMALL")));
            return null;
        }
        if ((passwordFlags & 0x80) != 0 && (matcher = REGEX_ENDS_NO_UPPER_LETTER_P.matcher(password)).find()) {
            logger.debug((Object)(Messages.getString("DefaultRegExFilter.debug_PASSWD") + password + Messages.getString("DefaultRegExFilter.ENDS_UPPER")));
            return null;
        }
        if ((passwordFlags & 0x100) != 0 && (matcher = REGEX_ENDS_NO_DIGIT_P.matcher(password)).find()) {
            logger.debug((Object)(Messages.getString("DefaultRegExFilter.debug_PASSWD") + password + Messages.getString("DefaultRegExFilter.ENDS_DIGIT")));
            return null;
        }
        if ((passwordFlags & 0x800) != 0 && (matcher = REGEX_ENDS_NO_SYMBOL_P.matcher(password)).find()) {
            logger.debug((Object)(Messages.getString("DefaultRegExFilter.debug_PASSWD") + password + Messages.getString("DefaultRegExFilter.debug_ENDS_SYMBOL")));
            return null;
        }
        if ((passwordFlags & 0x400) != 0 && (matcher = REGEX_STARTS_NO_SYMBOL_P.matcher(password)).find()) {
            logger.debug((Object)(Messages.getString("DefaultRegExFilter.debug_PASSWD") + password + Messages.getString("DefaultRegExFilter.debug_STARTS_SYMBOL")));
            return null;
        }
        if ((passwordFlags & 0x200) != 0 && (matcher = REGEX_STARTS_NO_DIGIT_P.matcher(password)).find()) {
            logger.debug((Object)(Messages.getString("DefaultRegExFilter.debug_PASSWD") + password + Messages.getString("DefaultRegExFilter.debug_STARTS_DIGIT")));
            return null;
        }
        if ((passwordFlags & 0x40) != 0 && (matcher = REGEX_STARTS_NO_UPPER_LETTER_P.matcher(password)).find()) {
            logger.debug((Object)(Messages.getString("DefaultRegExFilter.debug_PASSWD") + password + Messages.getString("DefaultRegExFilter.debug_STARTS_UPERCASE")));
            return null;
        }
        if ((passwordFlags & 0x10) != 0 && (matcher = REGEX_STARTS_NO_SMALL_LETTER_P.matcher(password)).find()) {
            logger.debug((Object)(Messages.getString("DefaultRegExFilter.debug_PASSWD") + password + Messages.getString("DefaultRegExFilter.debug_STARTS_SMALL")));
            return null;
        }
        if ((passwordFlags & 0x2000) != 0 && !(matcher = REGEX_ONLY_1_SYMBOL_P.matcher(password)).find()) {
            logger.debug((Object)(Messages.getString("DefaultRegExFilter.debug_PASSWD") + password + Messages.getString("DefaultRegExFilter.debug_MORE_SYMBOLS")));
            return null;
        }
        if ((passwordFlags & 0x4000) != 0 && !(matcher = REGEX_AT_LEAST_2_SYMBOLS_P.matcher(password)).find()) {
            logger.debug((Object)(Messages.getString("DefaultRegExFilter.debug_PASSWD") + password + Messages.getString("DefaultRegExFilter.debug_NO_SYMBOLS")));
            return null;
        }
        if ((passwordFlags & 0x8000) != 0 && !(matcher = REGEX_ONLY_1_DIGIT_P.matcher(password)).find()) {
            logger.debug((Object)(Messages.getString("DefaultRegExFilter.debug_PASSWD") + password + Messages.getString("DefaultRegExFilter.debug_MORE_DIGITS")));
            return null;
        }
        if ((passwordFlags & 0x10000) != 0 && !(matcher = REGEX_AT_LEAST_2_DIGITS_P.matcher(password)).find()) {
            logger.debug((Object)(Messages.getString("DefaultRegExFilter.debug_PASSWD") + password + Messages.getString("DefaultRegExFilter.debug_NO_DIGITS")));
            return null;
        }
        if ((passwordFlags & 0x1000) != 0 && !(matcher = REGEX_ONLY_1_CAPITAL_P.matcher(password)).find()) {
            logger.debug((Object)(Messages.getString("DefaultRegExFilter.debug_PASSWD") + password + Messages.getString("DefaultRegExFilter.debug_MORE_UPPERCASE")));
            return null;
        }
        return password;
    }

    @Override
    public String getDescription() {
        return Messages.getString("DefaultRegExFilter.DESC");
    }

    @Override
    public List<String> filter(int passwordFlags, List<String> password) {
        ArrayList<String> suiatble = new ArrayList<String>();
        for (String element : password) {
            if (this.filter(passwordFlags, password) == null) continue;
            suiatble.add(element);
        }
        return suiatble;
    }

    @Override
    public String getId() {
        return this.getClass().getName();
    }

    @Override
    public void setDescription(String description) {
    }

    @Override
    public void setId(String id) {
        System.err.println(Messages.getString("DefaultRegExFilter.ID_CHANGE"));
    }

    @Override
    public List<String> getBlacklist() {
        return this.blacklist;
    }

    @Override
    public void setBlacklist(List<String> blacklist) {
        if (logger.isDebugEnabled()) {
            for (String blacklisted : blacklist) {
                logger.debug((Object)("Blacklisted password with regular expression [" + blacklisted + "] "));
            }
        }
        this.blacklist = blacklist;
    }

    @Override
    public boolean addToBlacklist(String blackWord) {
        return this.blacklist.add(blackWord);
    }

    @Override
    public boolean removeFromBlacklist(String blackWord) {
        return this.blacklist.remove(blackWord);
    }
}

