/*
 * Decompiled with CFR 0.152.
 */
package org.josso.gateway;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.josso.SecurityDomain;
import org.josso.gateway.SSORequest;
import org.josso.gateway.SSOSecurityDomainSelector;
import org.josso.gateway.SecurityDomainMatcher;
import org.josso.gateway.identity.exceptions.NoSuchDomainException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DomainSelectorImpl
implements SSOSecurityDomainSelector {
    private static final Log logger = LogFactory.getLog(DomainSelectorImpl.class);

    public SecurityDomain selectDomain(SSORequest req, List<SecurityDomain> domains) throws NoSuchDomainException {
        SecurityDomain sd = this.matchDomain(req, domains);
        if (sd == null) {
            sd = this.selectByName(req, domains);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Selected domain is " + (sd != null ? sd.getName() : null)));
        }
        if (sd == null) {
            throw new NoSuchDomainException(req);
        }
        return sd;
    }

    public SecurityDomain matchDomain(SSORequest req, List<SecurityDomain> domains) throws NoSuchDomainException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("SecurityDomain by request: " + req));
        }
        for (SecurityDomain sd : domains) {
            boolean match = true;
            for (SecurityDomainMatcher matcher : sd.getMatchers()) {
                if (matcher.match(req)) continue;
                match = false;
                break;
            }
            if (!match) continue;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Domain " + sd.getName() + " matched request " + req));
            }
            return sd;
        }
        return null;
    }

    protected SecurityDomain selectByName(SSORequest req, List<SecurityDomain> domains) throws NoSuchDomainException {
        String name = req.getAttribute("org.josso.gateway.securityDomainName");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("SecurityDomain by name : " + name));
        }
        if (name == null) {
            return null;
        }
        for (SecurityDomain sd : domains) {
            if (!name.equals(sd.getName())) continue;
            return sd;
        }
        throw new NoSuchDomainException(name);
    }
}

