/*
 * Decompiled with CFR 0.152.
 */
package org.josso.jaspi.agent;

import java.security.Principal;
import javax.security.auth.Subject;
import javax.security.auth.message.AuthException;
import javax.security.auth.message.AuthStatus;
import javax.security.auth.message.MessageInfo;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.josso.agent.LocalSession;
import org.josso.agent.Lookup;
import org.josso.agent.SSOAgentRequest;
import org.josso.agent.SSOPartnerAppConfig;
import org.josso.agent.SingleSignOnEntry;
import org.josso.agent.http.HttpSSOAgent;
import org.josso.gateway.identity.SSORole;
import org.josso.jaspi.agent.JASPILocalSession;
import org.josso.jaspi.agent.JASPISSOAgentRequest;
import org.josso.jaspi.agent.JOSSOServerAuthModule;

public class JASPISSOAuthModule
extends JOSSOServerAuthModule {
    private static final Log log = LogFactory.getLog(JASPISSOAuthModule.class);
    private static HttpSSOAgent _agent;

    public JASPISSOAuthModule() {
        try {
            if (_agent == null) {
                Lookup lookup = Lookup.getInstance();
                lookup.init("josso-agent-config.xml");
                _agent = (HttpSSOAgent)lookup.lookupSSOAgent();
                if (log.isDebugEnabled()) {
                    _agent.setDebug(1);
                }
                _agent.start();
            }
        }
        catch (Exception e) {
            log.error((Object)("Error starting SSO Agent : " + e.getMessage()), (Throwable)e);
            throw new RuntimeException("Error starting SSO Agent : " + e.getMessage(), e);
        }
    }

    public AuthStatus secureResponse(MessageInfo messageInfo, Subject serviceSubject) throws AuthException {
        throw new RuntimeException("Not Applicable");
    }

    public AuthStatus validateRequest(MessageInfo messageInfo, Subject clientSubject, Subject serviceSubject) throws AuthException {
        HttpServletRequest hreq = (HttpServletRequest)messageInfo.getRequestMessage();
        HttpServletResponse hres = (HttpServletResponse)messageInfo.getResponseMessage();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Processing : " + hreq.getContextPath() + " [" + hreq.getRequestURL() + "]"));
        }
        try {
            AuthStatus status;
            String jossoSessionId;
            String contextPath = hreq.getContextPath();
            String vhost = hreq.getServerName();
            if ("".equals(contextPath)) {
                contextPath = "/";
            }
            if (!_agent.isPartnerApp(vhost, contextPath)) {
                AuthStatus status2;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Context is not a josso partner app : " + hreq.getContextPath()));
                }
                AuthStatus authStatus = status2 = AuthStatus.SUCCESS;
                return authStatus;
            }
            SSOPartnerAppConfig cfg = _agent.getPartnerAppConfig(vhost, contextPath);
            if (cfg.isSendP3PHeader() && !hres.isCommitted()) {
                hres.setHeader("P3P", cfg.getP3PHeaderValue());
            }
            HttpSession session = hreq.getSession(true);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Checking if its a josso_login_request for '" + hreq.getRequestURI() + "'"));
            }
            if (hreq.getRequestURI().endsWith(_agent.getJOSSOLoginUri()) || hreq.getRequestURI().endsWith(_agent.getJOSSOUserLoginUri())) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("josso_login_request received for uri '" + hreq.getRequestURI() + "'"));
                }
                if (hreq.getRequestURI().endsWith(_agent.getJOSSOUserLoginUri())) {
                    this.saveLoginBackToURL(hreq, hres, session, true);
                } else {
                    this.saveLoginBackToURL(hreq, hres, session, false);
                }
                String loginUrl = _agent.buildLoginUrl(hreq);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Redirecting to login url '" + loginUrl + "'"));
                }
                _agent.prepareNonCacheResponse(hres);
                hres.sendRedirect(hres.encodeRedirectURL(loginUrl));
                AuthStatus authStatus = AuthStatus.SEND_CONTINUE;
                return authStatus;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Checking if its a josso_logout request for '" + hreq.getRequestURI() + "'"));
            }
            if (hreq.getRequestURI().endsWith(_agent.getJOSSOLogoutUri())) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("josso_logout request received for uri '" + hreq.getRequestURI() + "'"));
                }
                String logoutUrl = _agent.buildLogoutUrl(hreq, cfg);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Redirecting to logout url '" + logoutUrl + "'"));
                }
                Cookie ssoCookie = _agent.newJossoCookie(hreq.getContextPath(), "-");
                hres.addCookie(ssoCookie);
                session.invalidate();
                _agent.prepareNonCacheResponse(hres);
                hres.sendRedirect(hres.encodeRedirectURL(logoutUrl));
                AuthStatus authStatus = AuthStatus.SEND_CONTINUE;
                return authStatus;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"Checking for SSO cookie");
            }
            Cookie cookie = null;
            Cookie[] cookies = hreq.getCookies();
            if (cookies == null) {
                cookies = new Cookie[]{};
            }
            for (int i = 0; i < cookies.length; ++i) {
                if (!"JOSSO_SESSIONID".equals(cookies[i].getName())) continue;
                cookie = cookies[i];
                break;
            }
            String string = jossoSessionId = cookie == null ? null : cookie.getValue();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Session is: " + session));
            }
            JASPILocalSession localSession = new JASPILocalSession(session);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Checking if its a josso_authentication for '" + hreq.getRequestURI() + "'"));
            }
            if (hreq.getRequestURI().endsWith(_agent.getJOSSOAuthenticationUri())) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("josso_authentication received for uri '" + hreq.getRequestURI() + "'"));
                }
                JASPISSOAgentRequest customAuthRequest = (JASPISSOAgentRequest)this.doMakeSSOAgentRequest(cfg.getId(), 4, jossoSessionId, localSession, null, hreq, hres);
                _agent.processRequest((SSOAgentRequest)customAuthRequest);
                AuthStatus authStatus = AuthStatus.SEND_CONTINUE;
                return authStatus;
            }
            if (cookie == null || cookie.getValue().equals("-")) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"SSO cookie is not present, verifying optional login process ");
                }
                if (hreq.getRequestURI().endsWith(_agent.getJOSSOSecurityCheckUri()) && hreq.getParameter("josso_assertion_id") == null) {
                    AuthStatus status3;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)(_agent.getJOSSOSecurityCheckUri() + " received without assertion.  Login Optional Process failed"));
                    }
                    String requestURI = this.getSavedRequestURL(hreq);
                    _agent.prepareNonCacheResponse(hres);
                    hres.sendRedirect(hres.encodeRedirectURL(requestURI));
                    AuthStatus authStatus = status3 = AuthStatus.SEND_CONTINUE;
                    return authStatus;
                }
                if (!hreq.getRequestURI().endsWith(_agent.getJOSSOSecurityCheckUri())) {
                    if (!_agent.isResourceIgnored(cfg, hreq) && _agent.isAutomaticLoginRequired(hreq, hres)) {
                        AuthStatus status4;
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"SSO cookie is not present, attempting automatic login");
                        }
                        this.saveRequestURL(hreq, hres);
                        String loginUrl = _agent.buildLoginOptionalUrl(hreq);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Redirecting to login url '" + loginUrl + "'"));
                        }
                        _agent.prepareNonCacheResponse(hres);
                        hres.sendRedirect(hres.encodeRedirectURL(loginUrl));
                        AuthStatus authStatus = status4 = AuthStatus.SEND_CONTINUE;
                        return authStatus;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"SSO cookie is not present, but login optional process is not required");
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)"SSO cookie is not present, checking for outbound relaying");
                }
                if (!hreq.getRequestURI().endsWith(_agent.getJOSSOSecurityCheckUri()) || hreq.getParameter("josso_assertion_id") == null) {
                    AuthStatus status5;
                    log.debug((Object)"SSO cookie not present and relaying was not requested, skipping");
                    AuthStatus status4 = status5 = AuthStatus.SUCCESS;
                    return status4;
                }
            }
            if (_agent.isResourceIgnored(cfg, hreq)) {
                AuthStatus status5 = AuthStatus.SEND_CONTINUE;
                return status5;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Session is: " + session));
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"Executing agent...");
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Checking if its a josso_security_check for '" + hreq.getRequestURI() + "'"));
            }
            if (hreq.getRequestURI().endsWith(_agent.getJOSSOSecurityCheckUri()) && hreq.getParameter("josso_assertion_id") != null) {
                AuthStatus status6;
                JASPISSOAgentRequest relayRequest;
                SingleSignOnEntry entry;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("josso_security_check received for uri '" + hreq.getRequestURI() + "' assertion id '" + hreq.getParameter("josso_assertion_id")));
                }
                String assertionId = hreq.getParameter("josso_assertion_id");
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Outbound relaying requested for assertion id [" + assertionId + "]"));
                }
                if ((entry = _agent.processRequest((SSOAgentRequest)(relayRequest = (JASPISSOAgentRequest)this.doMakeSSOAgentRequest(cfg.getId(), 2, null, localSession, assertionId, hreq, hres)))) == null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Outbound relaying failed for assertion id [" + assertionId + "], no Principal found."));
                    }
                    throw new RuntimeException("Outbound relaying failed. No Principal found. Verify your SSO Agent Configuration!");
                }
                if (!clientSubject.getPrincipals().contains(entry.principal)) {
                    clientSubject.getPrincipals().add(entry.principal);
                }
                SSORole[] ssoRolePrincipals = _agent.getRoleSets(cfg.getId(), entry.ssoId);
                for (int i = 0; i < ssoRolePrincipals.length; ++i) {
                    if (clientSubject.getPrincipals().contains(ssoRolePrincipals[i])) continue;
                    clientSubject.getPrincipals().add((Principal)ssoRolePrincipals[i]);
                    log.debug((Object)("Added SSORole Principal to the Subject : " + ssoRolePrincipals[i]));
                }
                this.registerWithCallbackHandler(entry.principal, entry.principal.getName(), entry.ssoId);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Outbound relaying succesfull for assertion id [" + assertionId + "]"));
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Assertion id [" + assertionId + "] mapped to SSO session id [" + entry.ssoId + "]"));
                }
                cookie = _agent.newJossoCookie(hreq.getContextPath(), entry.ssoId);
                hres.addCookie(cookie);
                String requestURI = this.getSavedSplashResource(hreq);
                if (requestURI == null && (requestURI = this.getSavedRequestURL(hreq)) == null) {
                    requestURI = cfg.getDefaultResource() != null ? cfg.getDefaultResource() : hreq.getRequestURI().substring(0, hreq.getRequestURI().length() - _agent.getJOSSOSecurityCheckUri().length());
                    String singlePointOfAccess = _agent.getSinglePointOfAccess();
                    if (singlePointOfAccess != null) {
                        requestURI = singlePointOfAccess + requestURI;
                    } else {
                        String reverseProxyHost = hreq.getHeader("Josso-ReversE-Proxy");
                        if (reverseProxyHost != null) {
                            requestURI = reverseProxyHost + requestURI;
                        }
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("No saved request found, using : '" + requestURI + "'"));
                    }
                }
                _agent.clearAutomaticLoginReferer(hreq, hres);
                _agent.prepareNonCacheResponse(hres);
                String postAuthURI = cfg.getPostAuthenticationResource();
                if (postAuthURI != null) {
                    String postAuthURL = _agent.buildPostAuthUrl(hres, requestURI, postAuthURI);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Redirecting to post-auth-resource '" + postAuthURL + "'"));
                    }
                    hres.sendRedirect(postAuthURL);
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Redirecting to original '" + requestURI + "'"));
                    }
                    hres.sendRedirect(hres.encodeRedirectURL(requestURI));
                }
                AuthStatus authStatus = status6 = AuthStatus.SEND_SUCCESS;
                return authStatus;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Creating Security Context for Session [" + session + "]"));
            }
            SSOAgentRequest r = this.doMakeSSOAgentRequest(cfg.getId(), 1, jossoSessionId, localSession, null, hreq, hres);
            SingleSignOnEntry entry = _agent.processRequest(r);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Executed agent.");
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Process request for '" + hreq.getRequestURI() + "'"));
            }
            if (entry != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Principal '" + entry.principal + "' has already been authenticated"));
                }
                if (!clientSubject.getPrincipals().contains(entry.principal)) {
                    clientSubject.getPrincipals().add(entry.principal);
                }
                SSORole[] ssoRolePrincipals = _agent.getRoleSets(cfg.getId(), entry.ssoId);
                for (int i = 0; i < ssoRolePrincipals.length; ++i) {
                    if (clientSubject.getPrincipals().contains(ssoRolePrincipals[i])) continue;
                    clientSubject.getPrincipals().add((Principal)ssoRolePrincipals[i]);
                    log.debug((Object)("Added SSORole Principal to the Subject : " + ssoRolePrincipals[i]));
                }
                this.registerWithCallbackHandler(entry.principal, entry.principal.getName(), entry.ssoId);
            } else {
                log.debug((Object)"No Valid SSO Session, attempt an optional login?");
                if (cookie != null) {
                    cookie = _agent.newJossoCookie(hreq.getContextPath(), "-");
                    hres.addCookie(cookie);
                }
                if (cookie != null || this.getSavedRequestURL(hreq) == null && _agent.isAutomaticLoginRequired(hreq, hres)) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"SSO Session is not valid, attempting automatic login");
                    }
                    this.saveRequestURL(hreq, hres);
                    String loginUrl = _agent.buildLoginOptionalUrl(hreq);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Redirecting to login url '" + loginUrl + "'"));
                    }
                    _agent.prepareNonCacheResponse(hres);
                    hres.sendRedirect(hres.encodeRedirectURL(loginUrl));
                    AuthStatus authStatus = AuthStatus.SEND_CONTINUE;
                    return authStatus;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)"SSO cookie is not present, but login optional process is not required");
                }
            }
            hreq.setAttribute("org.josso.agent.gateway-login-url", (Object)_agent.getGatewayLoginUrl());
            hreq.setAttribute("org.josso.agent.gateway-logout-url", (Object)_agent.getGatewayLogoutUrl());
            hreq.setAttribute("org.josso.agent.ssoSessionid", (Object)jossoSessionId);
            this.clearSavedRequestURLs(hreq, hres);
            AuthStatus authStatus = status = AuthStatus.SUCCESS;
            return authStatus;
        }
        catch (Throwable t) {
            throw new AuthException(t.getMessage());
        }
        finally {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Processed : " + hreq.getContextPath() + " [" + hreq.getRequestURL() + "]"));
            }
        }
    }

    protected SSOAgentRequest doMakeSSOAgentRequest(String requester, int action, String sessionId, LocalSession session, String assertionId, HttpServletRequest hreq, HttpServletResponse hres) {
        JASPISSOAgentRequest r = new JASPISSOAgentRequest(requester, action, sessionId, session, assertionId);
        r.setRequest(hreq);
        r.setResponse(hres);
        return r;
    }

    private String getSavedRequestURL(HttpServletRequest hreq) {
        return _agent.getAttribute(hreq, "JOSSO_SAVED_REQUEST");
    }

    private String getSavedSplashResource(HttpServletRequest hreq) {
        return _agent.getAttribute(hreq, "josso_splash_resource");
    }

    private void saveRequestURL(HttpServletRequest hreq, HttpServletResponse hres) {
        StringBuffer sb = new StringBuffer(hreq.getRequestURI());
        if (hreq.getQueryString() != null) {
            String q = hreq.getQueryString();
            if (!q.startsWith("?")) {
                sb.append('?');
            }
            sb.append(q);
        }
        _agent.setAttribute(hreq, hres, "JOSSO_SAVED_REQUEST", sb.toString());
    }

    protected void saveLoginBackToURL(HttpServletRequest request, HttpServletResponse response, HttpSession session, boolean overrideSavedResource) {
        String referer = request.getHeader("referer");
        if ((this.getSavedRequestURL(request) == null || overrideSavedResource) && referer != null && !referer.equals("")) {
            _agent.setAttribute(request, response, "JOSSO_SAVED_REQUEST", referer);
        }
    }

    protected void clearSavedRequestURLs(HttpServletRequest hreq, HttpServletResponse hres) {
        _agent.removeAttribute(hreq, hres, "JOSSO_SAVED_REQUEST");
        _agent.removeAttribute(hreq, hres, "josso_splash_resource");
    }
}

