/*
 * Decompiled with CFR 0.152.
 */
package org.josso.jb42.agent;

import java.security.Principal;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.util.CachePolicy;

public class SessionMappingCachePolicy
implements CachePolicy {
    private static final Log logger = LogFactory.getLog(SessionMappingCachePolicy.class);
    private HashMap _userSessionMap = new HashMap();
    private CachePolicy _cachePolicy;

    public SessionMappingCachePolicy(CachePolicy cachePolicy) {
        this._cachePolicy = cachePolicy;
    }

    public void attachSessionToUser(Principal session, Principal user) {
        this._userSessionMap.put(user, session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(Object key) {
        Object targetKey = key;
        logger.debug((Object)("Get, Entries = " + this._cachePolicy.size()));
        SessionMappingCachePolicy sessionMappingCachePolicy = this;
        synchronized (sessionMappingCachePolicy) {
            if (this._userSessionMap.containsKey(key)) {
                targetKey = this._userSessionMap.get(key);
                logger.debug((Object)("Get, mapped user principal '" + key + "'" + " to session principal '" + targetKey + "'"));
            }
        }
        return this._cachePolicy.get(targetKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object peek(Object key) {
        Object targetKey = key;
        logger.debug((Object)("Peek, Entries = " + this._cachePolicy.size()));
        SessionMappingCachePolicy sessionMappingCachePolicy = this;
        synchronized (sessionMappingCachePolicy) {
            if (this._userSessionMap.containsKey(key)) {
                targetKey = this._userSessionMap.get(key);
                logger.debug((Object)("Peek, mapped user principal '" + key + "'" + " to session principal '" + targetKey + "'"));
            }
        }
        return this._cachePolicy.peek(targetKey);
    }

    public void insert(Object key, Object object) {
        logger.debug((Object)("Insert, key = " + key + ", object = " + object + " Entries = " + this._cachePolicy.size()));
        this._cachePolicy.insert(key, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Object key) {
        logger.debug((Object)("Remove, key = " + key + ", Entries = " + this._cachePolicy.size()));
        SessionMappingCachePolicy sessionMappingCachePolicy = this;
        synchronized (sessionMappingCachePolicy) {
            if (this._userSessionMap.containsKey(key)) {
                this._userSessionMap.remove(key);
                logger.debug((Object)("Remove, removed session mapping for user '" + key + "'"));
            }
        }
        this._cachePolicy.remove(key);
    }

    public void flush() {
        logger.debug((Object)("Flush Entries = " + this._cachePolicy.size()));
        this._userSessionMap.clear();
        this._cachePolicy.flush();
    }

    public int size() {
        return this._cachePolicy.size();
    }

    public void create() throws Exception {
        this._cachePolicy.create();
    }

    public void start() throws Exception {
        this._cachePolicy.start();
    }

    public void stop() {
        this._cachePolicy.stop();
    }

    public void destroy() {
        this._cachePolicy.destroy();
    }
}

