/*
 * Decompiled with CFR 0.152.
 */
package org.josso.jbportal27.agent;

import java.security.Principal;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.josso.gateway.identity.SSORole;
import org.josso.gateway.identity.SSOUser;
import org.josso.gateway.identity.service.BaseRoleImpl;
import org.josso.gateway.identity.service.BaseUserImpl;
import org.josso.tc55.agent.jaas.SSOGatewayLoginModule;

public class JOSSOLoginModule
extends SSOGatewayLoginModule {
    private static final Log logger = LogFactory.getLog(JOSSOLoginModule.class);
    private Subject _savedSubject;
    protected SSOUser _unauthenticatedIdentity;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        this._savedSubject = subject;
        super.initialize(subject, callbackHandler, sharedState, options);
        String name = (String)options.get("unauthenticatedIdentity");
        if (name != null) {
            try {
                this._unauthenticatedIdentity = this.createIdentity(name);
                logger.debug((Object)("Saw unauthenticatedIdentity=" + name));
            }
            catch (Exception e) {
                logger.warn((Object)"Failed to create custom unauthenticatedIdentity", (Throwable)e);
            }
        }
    }

    public boolean login() throws LoginException {
        if (!super.login()) {
            if (this._unauthenticatedIdentity != null) {
                logger.debug((Object)("Authenticated as unauthenticatedIdentity : " + this._unauthenticatedIdentity));
                this._ssoUserPrincipal = this._unauthenticatedIdentity;
                this._succeeded = true;
                return true;
            }
            return false;
        }
        return true;
    }

    public boolean commit() throws LoginException {
        boolean rc = false;
        rc = super.commit();
        Set<SSORole> ssoRolePrincipals = this._savedSubject.getPrincipals(SSORole.class);
        BaseRoleImpl targetGrp = new BaseRoleImpl("Roles");
        Iterator<SSORole> i = ssoRolePrincipals.iterator();
        HashSet cour = new HashSet();
        while (i.hasNext()) {
            Principal p = (Principal)i.next();
            targetGrp.addMember(p);
            ((BaseRoleImpl)p).addMember((Principal)this.createIdentity(p.getName()));
        }
        this._savedSubject.getPrincipals().removeAll(ssoRolePrincipals);
        this._savedSubject.getPrincipals().add((Principal)targetGrp);
        return rc;
    }

    protected SSOUser createIdentity(String username) {
        return new BaseUserImpl(username);
    }

    protected SSORole[] getRoleSets() throws LoginException {
        if (this._ssoUserPrincipal == this._unauthenticatedIdentity) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Using unauthenticatedIdentity " + this._ssoUserPrincipal + ", returning no roles."));
            }
            return new SSORole[0];
        }
        return super.getRoleSets();
    }
}

