/*
 * Decompiled with CFR 0.152.
 */
package org.josso.gateway.identity.service.store.ldap;

import javax.naming.AuthenticationException;
import javax.naming.ldap.InitialLdapContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.josso.auth.BindableCredentialStore;
import org.josso.auth.exceptions.SSOAuthenticationException;
import org.josso.gateway.identity.service.store.ldap.LDAPIdentityStore;

public class LDAPBindIdentityStore
extends LDAPIdentityStore
implements BindableCredentialStore {
    private static final Log logger = LogFactory.getLog(LDAPBindIdentityStore.class);

    public boolean bind(String username, String password) throws SSOAuthenticationException {
        try {
            String dn = this.selectUserDN(username);
            if (dn == null) {
                throw new SSOAuthenticationException("No DN found for user : " + username);
            }
            logger.debug((Object)("user dn = " + dn));
            try {
                InitialLdapContext ctx = this.createLdapInitialContext(dn, password);
                ctx.close();
            }
            catch (AuthenticationException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Authentication error : " + e.getMessage()), (Throwable)e);
                }
                return false;
            }
            return true;
        }
        catch (Exception e) {
            throw new SSOAuthenticationException("Cannot bind as user : " + username + " " + e.getMessage(), (Throwable)e);
        }
    }
}

