/*
 * Decompiled with CFR 0.152.
 */
package org.josso.gateway.ws._1_1.wsdl.soapbinding;

import java.rmi.RemoteException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.josso.SecurityDomain;
import org.josso.gateway.SSOContext;
import org.josso.gateway.assertion.AssertionManager;
import org.josso.gateway.assertion.exceptions.AssertionNotValidException;
import org.josso.gateway.session.service.SSOSessionManager;
import org.josso.gateway.ws._1_1.protocol.AssertIdentityWithSimpleAuthenticationRequestType;
import org.josso.gateway.ws._1_1.protocol.AssertIdentityWithSimpleAuthenticationResponseType;
import org.josso.gateway.ws._1_1.protocol.AssertionNotValidErrorType;
import org.josso.gateway.ws._1_1.protocol.GlobalSignoffRequestType;
import org.josso.gateway.ws._1_1.protocol.GlobalSignoffResponseType;
import org.josso.gateway.ws._1_1.protocol.ResolveAuthenticationAssertionRequestType;
import org.josso.gateway.ws._1_1.protocol.ResolveAuthenticationAssertionResponseType;
import org.josso.gateway.ws._1_1.protocol.SSOIdentityProviderErrorType;
import org.josso.gateway.ws._1_1.wsdl.SSOIdentityProvider;
import org.josso.gateway.ws._1_1.wsdl.soapbinding.BaseSSOService;

public class SSOIdentityProviderBindingImpl
extends BaseSSOService
implements SSOIdentityProvider {
    private static Log logger = LogFactory.getLog(SSOIdentityProviderBindingImpl.class);

    public ResolveAuthenticationAssertionResponseType resolveAuthenticationAssertion(ResolveAuthenticationAssertionRequestType body) throws RemoteException {
        try {
            String aaId = body.getAssertionId();
            this.prepareCtx(AssertionManager.TOKEN_TYPE, aaId);
            SecurityDomain sd = SSOContext.getCurrent().getSecurityDomain();
            String ssoSessionId = sd.getIdentityProvider().resolveAuthenticationAssertion(aaId);
            ResolveAuthenticationAssertionResponseType response = new ResolveAuthenticationAssertionResponseType();
            response.setSecurityDomain(sd.getName());
            response.setSsoSessionId(ssoSessionId);
            return response;
        }
        catch (AssertionNotValidException e) {
            throw new AssertionNotValidErrorType(body.getAssertionId());
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new SSOIdentityProviderErrorType("SSOIdentityProvider error : " + e.getMessage());
        }
    }

    public AssertIdentityWithSimpleAuthenticationResponseType assertIdentityWithSimpleAuthentication(AssertIdentityWithSimpleAuthenticationRequestType body) throws RemoteException {
        try {
            this.prepareCtx(body.getSecurityDomain());
            String username = body.getUsername();
            String password = body.getPassword();
            String aaId = SSOContext.getCurrent().getSecurityDomain().getIdentityProvider().assertIdentityWithSimpleAuthentication(username, password);
            AssertIdentityWithSimpleAuthenticationResponseType response = new AssertIdentityWithSimpleAuthenticationResponseType();
            response.setAssertionId(aaId);
            return response;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new SSOIdentityProviderErrorType("SSOIdentityProvider error : " + e.getMessage());
        }
    }

    public GlobalSignoffResponseType globalSignoff(GlobalSignoffRequestType body) throws RemoteException {
        try {
            String ssoSessionId = body.getSsoSessionId();
            this.prepareCtx(SSOSessionManager.TOKEN_TYPE, ssoSessionId);
            SSOContext.getCurrent().getSecurityDomain().getIdentityProvider().globalSignoff(ssoSessionId);
            GlobalSignoffResponseType response = new GlobalSignoffResponseType();
            response.setSsoSessionId(ssoSessionId);
            return response;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new SSOIdentityProviderErrorType("SSOIdentityProvider error : " + e.getMessage());
        }
    }
}

