/*
 * Decompiled with CFR 0.152.
 */
package org.josso.gateway.ws._1_1.wsdl.soapbinding;

import java.rmi.RemoteException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.josso.SecurityDomain;
import org.josso.gateway.SSOContext;
import org.josso.gateway.session.SSOSession;
import org.josso.gateway.session.exceptions.NoSuchSessionException;
import org.josso.gateway.ws._1_1.protocol.AccessSessionRequestType;
import org.josso.gateway.ws._1_1.protocol.AccessSessionResponseType;
import org.josso.gateway.ws._1_1.protocol.NoSuchSessionErrorType;
import org.josso.gateway.ws._1_1.protocol.SSOSessionErrorType;
import org.josso.gateway.ws._1_1.protocol.SSOSessionType;
import org.josso.gateway.ws._1_1.protocol.SessionRequestType;
import org.josso.gateway.ws._1_1.protocol.SessionResponseType;
import org.josso.gateway.ws._1_1.wsdl.SSOSessionManager;
import org.josso.gateway.ws._1_1.wsdl.soapbinding.BaseSSOService;

public class SSOSessionManagerBindingImpl
extends BaseSSOService
implements SSOSessionManager {
    private static Log logger = LogFactory.getLog(SSOSessionManagerBindingImpl.class);

    public AccessSessionResponseType accessSession(AccessSessionRequestType body) throws RemoteException {
        try {
            String ssoSessionId = body.getSsoSessionId();
            this.prepareCtx(org.josso.gateway.session.service.SSOSessionManager.TOKEN_TYPE, ssoSessionId);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"About to access session");
            }
            if (SSOContext.getCurrent() == null) {
                throw new NoSuchSessionErrorType(body.getSsoSessionId() != null && !"".equals(body.getSsoSessionId()) ? body.getSsoSessionId() : "[NULL]");
            }
            SecurityDomain sd = SSOContext.getCurrent().getSecurityDomain();
            sd.getSessionManager().accessSession(ssoSessionId);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"After access session");
            }
            AccessSessionResponseType response = new AccessSessionResponseType();
            response.setSsoSessionId(ssoSessionId);
            return response;
        }
        catch (NoSuchSessionException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)e.getMessage());
            }
            throw new NoSuchSessionErrorType(body.getSsoSessionId() != null && !"".equals(body.getSsoSessionId()) ? body.getSsoSessionId() : "[NULL]");
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new SSOSessionErrorType("SSOSessionManager error : " + e.getMessage());
        }
    }

    public SessionResponseType getSession(SessionRequestType body) throws RemoteException, NoSuchSessionErrorType, SSOSessionErrorType {
        try {
            String ssoSessionId = body.getSessionId();
            this.prepareCtx(org.josso.gateway.session.service.SSOSessionManager.TOKEN_TYPE, ssoSessionId);
            SSOSession s = SSOContext.getCurrent().getSecurityDomain().getSessionManager().getSession(ssoSessionId);
            SessionResponseType response = new SessionResponseType();
            response.setSSOSession(this.adaptSession(s));
            return response;
        }
        catch (NoSuchSessionException e) {
            throw new NoSuchSessionErrorType(body.getSessionId() != null && !"".equals(body.getSessionId()) ? body.getSessionId() : "[NULL]");
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new SSOSessionErrorType("SSOSessionManager error : " + e.getMessage());
        }
    }

    private SSOSessionType adaptSession(SSOSession s) {
        SSOSessionType st = new SSOSessionType();
        st.setId(s.getId());
        st.setAccessCount(s.getAccessCount());
        st.setCreationTime(s.getCreationTime());
        st.setLastAccessTime(s.getLastAccessTime());
        st.setMaxInactiveInterval(s.getMaxInactiveInterval());
        st.setUsername(s.getUsername());
        return st;
    }
}

