/*
 * Decompiled with CFR 0.152.
 */
package org.josso.tc55.agent;

import java.security.Principal;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Realm;
import org.josso.agent.SSOAgentRequest;
import org.josso.agent.http.HttpSSOAgent;
import org.josso.tc55.agent.CatalinaSSOAgentRequest;

public class CatalinaSSOAgent
extends HttpSSOAgent {
    private Container _container;

    public CatalinaSSOAgent() {
    }

    public CatalinaSSOAgent(Container container) {
        this._container = container;
    }

    public void start() {
        super.start();
        if (this._container instanceof Context) {
            Context context = (Context)this._container;
            this._cfg.addSSOPartnerApp(context.getPublicId(), null, context.getPath(), null, null);
        }
    }

    public void setCatalinaContainer(Container container) {
        this._container = container;
    }

    protected Principal authenticate(SSOAgentRequest request) {
        CatalinaSSOAgentRequest r = (CatalinaSSOAgentRequest)request;
        Context c = r.getContext();
        Realm realm = c.getRealm();
        if (this.debug > 0) {
            this.log("Using realm : " + realm.getClass().getName() + " SSOSID : " + r.getSessionId());
        }
        Principal p = realm.authenticate(r.getSessionId(), r.getSessionId());
        if (this.debug > 0) {
            this.log("Received principal : " + p + "[" + (p != null ? p.getClass().getName() : "<null>") + "]");
        }
        return p;
    }

    protected void log(String message) {
        if (this._container != null) {
            if (this._container.getLogger().isDebugEnabled()) {
                this._container.getLogger().debug((Object)(this.toString() + ": " + message));
            }
        } else {
            System.out.println(this.toString() + ": " + message);
        }
    }

    protected void log(String message, Throwable throwable) {
        if (this._container != null) {
            if (this._container.getLogger().isDebugEnabled()) {
                this._container.getLogger().debug((Object)(this.toString() + ": " + message), throwable);
            }
        } else {
            System.out.println(this.toString() + ": " + message);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("CatalinaSSOAgent[");
        sb.append(this._container != null ? this._container.getName() : "");
        sb.append("]");
        return sb.toString();
    }
}

