/*
 * Decompiled with CFR 0.152.
 */
package org.josso.gateway;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.josso.gateway.SSORequest;
import org.josso.gateway.SecurityDomainMatcher;

public class VHostSecurityDomainMatcher
implements SecurityDomainMatcher {
    private static Log logger = LogFactory.getLog(VHostSecurityDomainMatcher.class);
    private List<String> vhosts = new ArrayList<String>();

    public void init() {
        if (this.vhosts.isEmpty()) {
            logger.warn((Object)"No Virtual hosts defined for this matcher.  Check JOSSO configuration!");
        }
    }

    public boolean match(SSORequest req) {
        boolean match;
        String vhost = req.getParameter("josso_partnerapp_host");
        boolean bl = match = vhost != null && this.vhosts.contains(vhost.toLowerCase());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Request does " + (match ? "" : "not") + " match vhost : " + vhost));
        }
        return match;
    }

    public void setVhosts(String stVhosts) {
        StringTokenizer st = new StringTokenizer(stVhosts, ",");
        while (st.hasMoreTokens()) {
            String vhost = st.nextToken();
            this.vhosts.add(vhost.toLowerCase());
            if (!logger.isDebugEnabled()) continue;
            logger.debug((Object)("Adding VHost :" + vhost));
        }
    }
}

