/*
 * Decompiled with CFR 0.152.
 */
package org.josso.wls10.agent.jaas;

import java.io.IOException;
import java.security.Principal;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.josso.agent.AbstractSSOAgent;
import org.josso.agent.Lookup;
import org.josso.agent.SSOAgentRequest;
import org.josso.gateway.identity.SSORole;
import org.josso.gateway.identity.SSOUser;
import org.josso.gateway.identity.exceptions.SSOIdentityException;
import org.josso.gateway.identity.service.SSOIdentityManagerService;
import org.josso.wls10.agent.jaas.WLSJOSSORole;
import org.josso.wls10.agent.jaas.WLSJOSSOUser;

public class SSOGatewayLoginModuleImpl
implements LoginModule {
    private static final Log logger = LogFactory.getLog(SSOGatewayLoginModuleImpl.class);
    private Subject _subject;
    private CallbackHandler _callbackHandler;
    protected boolean _succeeded;
    protected boolean commitSucceeded;
    protected String _requester;
    protected String _currentSSOSessionId;
    protected WLSJOSSOUser _ssoUserPrincipal;
    protected WLSJOSSORole[] _ssoRolePrincipals;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        this._subject = subject;
        this._callbackHandler = callbackHandler;
    }

    public boolean login() throws LoginException {
        String ssoSessionId;
        if (this._callbackHandler == null) {
            throw new LoginException("Error: no CallbackHandler available to garner authentication information from the user");
        }
        Callback[] callbacks = new Callback[]{new NameCallback("ssoSessionId"), new PasswordCallback("password", false)};
        String ssoSessionId2 = null;
        try {
            this._callbackHandler.handle(callbacks);
            ssoSessionId = ((NameCallback)callbacks[0]).getName();
            if (((PasswordCallback)callbacks[1]).getPassword() != null) {
                ssoSessionId2 = String.valueOf(((PasswordCallback)callbacks[1]).getPassword());
            }
            this._requester = "";
            SSOAgentRequest request = (SSOAgentRequest)AbstractSSOAgent._currentRequest.get();
            if (request != null) {
                this._requester = request.getRequester();
            } else {
                logger.warn((Object)"No SSO Agent request found in thread local variable, can't identify requester");
            }
        }
        catch (IOException ioe) {
            throw new LoginException(ioe.toString());
        }
        catch (UnsupportedCallbackException uce) {
            throw new LoginException("Error: " + uce.getCallback().toString() + " not available to garner authentication information " + "from the user");
        }
        logger.debug((Object)("Requested authentication to gateway by " + this._requester + " using sso session " + ssoSessionId + "/" + ssoSessionId2));
        try {
            if (ssoSessionId2 != null && !ssoSessionId2.equals(ssoSessionId)) {
                ssoSessionId = ssoSessionId2;
            }
            if (ssoSessionId == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Session authentication failed : " + ssoSessionId));
                }
                this._succeeded = false;
                return false;
            }
            this._currentSSOSessionId = ssoSessionId;
            SSOIdentityManagerService im = Lookup.getInstance().lookupSSOAgent().getSSOIdentityManager();
            SSOUser jossoUser = im.findUserInSession(this._requester, ssoSessionId);
            WLSJOSSOUser wlsUser = new WLSJOSSOUser(jossoUser);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Session authentication succeeded : " + ssoSessionId));
            }
            this._ssoUserPrincipal = wlsUser;
            this._succeeded = true;
        }
        catch (SSOIdentityException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)e.getMessage(), (Throwable)e);
            }
            this._succeeded = false;
            return false;
        }
        catch (Exception e) {
            logger.error((Object)("Session login failed for Principal : " + (Object)((Object)this._ssoUserPrincipal) + e.getMessage()));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)e.getMessage(), (Throwable)e);
            }
            this._succeeded = false;
            this.clearCredentials();
            throw new FailedLoginException("Fatal error authenticating session : " + (Object)((Object)this._ssoUserPrincipal) + " : " + e.getMessage());
        }
        return true;
    }

    public boolean commit() throws LoginException {
        if (!this._succeeded) {
            return false;
        }
        try {
            int i;
            if (!this._subject.getPrincipals().contains((Object)this._ssoUserPrincipal)) {
                this._subject.getPrincipals().add((Principal)((Object)this._ssoUserPrincipal));
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Added SSOUser Principal to the Subject : " + (Object)((Object)this._ssoUserPrincipal)));
            }
            this._ssoRolePrincipals = this.getRoleSets();
            for (i = 0; i < this._ssoRolePrincipals.length; ++i) {
                if (this._subject.getPrincipals().contains((Object)this._ssoRolePrincipals[i])) continue;
                this._subject.getPrincipals().add((Principal)((Object)this._ssoRolePrincipals[i]));
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("Added SSORole Principal to the Subject : " + (Object)((Object)this._ssoRolePrincipals[i])));
            }
            this.commitSucceeded = true;
            i = 1;
            return i != 0;
        }
        catch (Exception e) {
            logger.error((Object)("Session commit failed for Principal : " + (Object)((Object)this._ssoUserPrincipal) + e.getMessage()));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)e.getMessage(), (Throwable)e);
            }
            throw new LoginException("Session commit failed for Principal : " + (Object)((Object)this._ssoUserPrincipal) + " : " + e.getMessage());
        }
        finally {
            this.clearCredentials();
        }
    }

    public boolean abort() throws LoginException {
        if (!this._succeeded) {
            return false;
        }
        if (this._succeeded && !this.commitSucceeded) {
            this._succeeded = false;
            this.clearCredentials();
        } else {
            this.logout();
        }
        return true;
    }

    public boolean logout() throws LoginException {
        this._subject.getPrincipals().remove((Object)this._ssoUserPrincipal);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Removed SSOUser Principal from Subject : " + (Object)((Object)this._ssoUserPrincipal)));
        }
        for (int i = 0; i < this._ssoRolePrincipals.length; ++i) {
            this._subject.getPrincipals().remove((Object)this._ssoRolePrincipals[i]);
            if (!logger.isDebugEnabled()) continue;
            logger.debug((Object)("Removed SSORole Principal from Subject : " + (Object)((Object)this._ssoRolePrincipals[i])));
        }
        this._succeeded = this.commitSucceeded;
        this.clearCredentials();
        return true;
    }

    private void clearCredentials() {
        this._ssoUserPrincipal = null;
        this._ssoRolePrincipals = null;
        this._currentSSOSessionId = null;
    }

    protected WLSJOSSORole[] getRoleSets() throws LoginException {
        try {
            SSOIdentityManagerService im = Lookup.getInstance().lookupSSOAgent().getSSOIdentityManager();
            SSORole[] roles = im.findRolesBySSOSessionId(this._requester, this._currentSSOSessionId);
            WLSJOSSORole[] wlsRoles = new WLSJOSSORole[roles.length];
            for (int i = 0; i < roles.length; ++i) {
                WLSJOSSORole wlsRole;
                SSORole role = roles[i];
                wlsRoles[i] = wlsRole = new WLSJOSSORole(role);
            }
            return wlsRoles;
        }
        catch (Exception e) {
            logger.error((Object)("Session login failed for Principal : " + (Object)((Object)this._ssoUserPrincipal)), (Throwable)e);
            throw new LoginException("Session login failed for Principal : " + (Object)((Object)this._ssoUserPrincipal));
        }
    }
}

